/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.PipeUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityThermalEvaporationValve
extends TileEntityThermalEvaporationBlock
implements IFluidHandler,
IHeatTransfer {
    public boolean prevMaster = false;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.master != null != this.prevMaster) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    Coord4D obj = Coord4D.get(this).getFromSide(side);
                    if (obj.isAirBlock((IBlockAccess)this.field_145850_b) || obj.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock) continue;
                    obj.getBlock((IBlockAccess)this.field_145850_b).onNeighborChange((IBlockAccess)this.field_145850_b, obj.xCoord, obj.yCoord, obj.zCoord, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.prevMaster = this.master != null;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller == null ? 0 : controller.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null && (resource == null || resource.isFluidEqual(controller.outputTank.getFluid()))) {
            return controller.outputTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null) {
            return controller.outputTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller != null && controller.hasRecipe(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        TileEntityThermalEvaporationController controller = this.getController();
        return controller != null && controller.outputTank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller == null) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)controller.inputTank), new FluidTankInfo((IFluidTank)controller.outputTank)};
    }

    @Override
    public double getTemp() {
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 0.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        TileEntityThermalEvaporationController controller = this.getController();
        if (controller != null) {
            controller.heatToAbsorb = (float)((double)controller.heatToAbsorb + heat);
        }
    }

    @Override
    public double[] simulateHeat() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double applyTemperatureChange() {
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return this.getController() != null;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        return null;
    }
}

