/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.security;

import io.netty.buffer.ByteBuf;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;

public class SecurityData {
    public ISecurityTile.SecurityMode mode = ISecurityTile.SecurityMode.PUBLIC;
    public boolean override;

    public SecurityData() {
    }

    public SecurityData(SecurityFrequency frequency) {
        this.mode = frequency.securityMode;
        this.override = frequency.override;
    }

    public void write(ByteBuf dataStream) {
        dataStream.writeInt(this.mode.ordinal());
        dataStream.writeBoolean(this.override);
    }

    public static SecurityData read(ByteBuf dataStream) {
        SecurityData data = new SecurityData();
        data.mode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        data.override = dataStream.readBoolean();
        return data;
    }
}

