/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import mekanism.common.Mekanism;
import mekanism.common.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessMekanismRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList<Object> input = new ArrayList();

    public ShapelessMekanismRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessMekanismRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessMekanismRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object obj : recipe) {
            if (obj instanceof ItemStack) {
                this.input.add(((ItemStack)obj).func_77946_l());
                continue;
            }
            if (obj instanceof Item) {
                this.input.add(new ItemStack((Item)obj));
                continue;
            }
            if (obj instanceof Block) {
                this.input.add(new ItemStack((Block)obj));
                continue;
            }
            if (obj instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)obj)));
                continue;
            }
            String ret = "Invalid shapeless Mekanism recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return RecipeUtils.getCraftingResult(inv, this.output.func_77946_l());
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = RecipeUtils.areItemsEqualForCrafting((ItemStack)next, slot);
                } else if (next instanceof ArrayList) {
                    Iterator itr = ((ArrayList)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = RecipeUtils.areItemsEqualForCrafting((ItemStack)itr.next(), slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public static ShapelessMekanismRecipe create(NBTTagCompound nbtTags) {
        if (!nbtTags.func_74764_b("result") || !nbtTags.func_74764_b("input")) {
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: missing input or result compound tag.");
            return null;
        }
        ItemStack result = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("result"));
        NBTTagList list = nbtTags.func_150295_c("input", 10);
        if (result == null || list.func_74745_c() == 0) {
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: invalid result stack or input data list.");
            return null;
        }
        Object[] ret = new Object[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74764_b("oredict")) {
                ret[i] = compound.func_74779_i("oredict");
                continue;
            }
            if (compound.func_74764_b("itemstack")) {
                ret[i] = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("itemstack"));
                continue;
            }
            Mekanism.logger.error("[Mekanism] Shapeless recipe parse error: invalid input tag data key.");
            return null;
        }
        return new ShapelessMekanismRecipe(result, ret);
    }
}

