/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class MatrixUpdateProtocol
extends UpdateProtocol<SynchronizedMatrixData> {
    public MatrixUpdateProtocol(TileEntityInductionCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return this.pointer.func_145831_w().func_147439_a(x, y, z) == MekanismBlocks.BasicBlock2 && this.pointer.func_145831_w().func_72805_g(x, y, z) == 1;
    }

    @Override
    public boolean isValidInnerNode(int x, int y, int z) {
        TileEntity tile = this.pointer.func_145831_w().func_147438_o(x, y, z);
        if (tile != null && (tile instanceof TileEntityInductionCell || tile instanceof TileEntityInductionProvider)) {
            return true;
        }
        return this.isAir(x, y, z);
    }

    protected MatrixCache getNewCache() {
        return new MatrixCache();
    }

    @Override
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData();
    }

    @Override
    protected MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedMatrixData> cache, MultiblockCache<SynchronizedMatrixData> merge) {
        List<ItemStack> rejects = StackUtils.getMergeRejects(((MatrixCache)cache).inventory, ((MatrixCache)merge).inventory);
        if (!rejects.isEmpty()) {
            rejectedItems.addAll(rejects);
        }
        StackUtils.merge(((MatrixCache)cache).inventory, ((MatrixCache)merge).inventory);
    }

    @Override
    protected boolean canForm(SynchronizedMatrixData structure) {
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (tile instanceof TileEntityInductionCell) {
                structure.cells.add(coord);
                structure.storageCap += ((TileEntityInductionCell)tile).tier.maxEnergy;
                continue;
            }
            if (!(tile instanceof TileEntityInductionProvider)) continue;
            structure.providers.add(coord);
            structure.transferCap += ((TileEntityInductionProvider)tile).tier.output;
        }
        return true;
    }
}

