/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.client.render.block.TextureSubmap;
import mekanism.common.CTMTextureData;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CTMData {
    public CTMTextureData mainTextureData;
    public HashMap<Block, List<Integer>> acceptableBlockMetas = new HashMap();
    public CTMTextureData[] sideOverrides = new CTMTextureData[6];
    public CTMTextureData facingOverride;
    public int facing;
    public boolean renderConvexConnections = false;

    public CTMData(String textureName, Block block, List<Integer> connectableMeta) {
        this.mainTextureData = new CTMTextureData(textureName);
        this.acceptableBlockMetas.put(block, connectableMeta);
    }

    public CTMData addSideOverride(ForgeDirection side, String sideTexture) {
        this.sideOverrides[side.ordinal()] = new CTMTextureData(sideTexture);
        return this;
    }

    public CTMData addFacingOverride(String facingTexture) {
        this.facingOverride = new CTMTextureData(facingTexture);
        return this;
    }

    public boolean hasFacingOverride() {
        return this.facingOverride != null;
    }

    public void setFacing(int newFacing) {
        this.facing = newFacing;
    }

    public CTMData registerIcons(IIconRegister register) {
        this.mainTextureData.registerIcons(register);
        if (this.facingOverride != null) {
            this.facingOverride.registerIcons(register);
        }
        for (CTMTextureData data : this.sideOverrides) {
            if (data == null) continue;
            data.registerIcons(register);
        }
        return this;
    }

    public CTMTextureData getTextureData(int side) {
        if (this.hasFacingOverride() && side == this.facing) {
            return this.facingOverride;
        }
        if (this.sideOverrides[side] != null) {
            return this.sideOverrides[side];
        }
        return this.mainTextureData;
    }

    public IIcon getIcon(int side) {
        return this.getTextureData((int)side).icon;
    }

    public TextureSubmap getSubmap(int side) {
        return this.getTextureData((int)side).submap;
    }

    public TextureSubmap getSmallSubmap(int side) {
        return this.getTextureData((int)side).submapSmall;
    }

    public CTMData addOtherBlockConnectivities(Block block, List<Integer> connectableMeta) {
        this.acceptableBlockMetas.put(block, connectableMeta);
        return this;
    }

    public CTMData setRenderConvexConnections() {
        this.renderConvexConnections = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderSide(IBlockAccess world, int x, int y, int z, int side) {
        Coord4D obj = new Coord4D(x, y, z);
        Block coordBlock = obj.getBlock(world);
        int coordMeta = obj.getMetadata(world);
        boolean valid = false;
        for (Map.Entry<Block, List<Integer>> entry : this.acceptableBlockMetas.entrySet()) {
            valid |= entry.getKey().equals(coordBlock) && entry.getValue().contains(coordMeta);
        }
        return !valid;
    }
}

