/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class MachineRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;

    public abstract String getRecipeId();

    public abstract Collection<? extends BasicMachineRecipe> getRecipes();

    public abstract GuiProgress.ProgressBar getProgressType();

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 16));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 111, 30));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return MachineRecipeHandler.this.ticksPassed <= 20 ? (double)((float)MachineRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return MachineRecipeHandler.this.ticksPassed >= 20 ? (double)((float)((MachineRecipeHandler.this.ticksPassed - 20) % 20) / 20.0f) : 0.0;
            }
        }, this.getProgressType(), this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 77, 37));
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)12, (int)0, (int)28, (int)5, (int)144, (int)68);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -16, -5);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 34, 24, 7), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (BasicMachineRecipe basicMachineRecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(basicMachineRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (BasicMachineRecipe basicMachineRecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStackOutput)basicMachineRecipe.getOutput()).output, (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(basicMachineRecipe));
        }
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiBasicMachine.png";
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (BasicMachineRecipe basicMachineRecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStackInput)basicMachineRecipe.getInput()).ingredient, (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(basicMachineRecipe));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedIORecipe(ItemStack itemstack, ItemStack itemstack1) {
            super((TemplateRecipeHandler)MachineRecipeHandler.this);
            this.input = new PositionedStack((Object)itemstack, 40, 12);
            this.output = new PositionedStack((Object)itemstack1, 100, 30);
        }

        public CachedIORecipe(BasicMachineRecipe<?> recipe) {
            this(((ItemStackInput)recipe.getInput()).ingredient, ((ItemStackOutput)recipe.getOutput()).output);
        }
    }
}

