/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.ResourceId;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceIdBlock
extends ResourceId {
    public BlockIndex index = new BlockIndex();
    public ForgeDirection side = ForgeDirection.UNKNOWN;

    public ResourceIdBlock() {
    }

    public ResourceIdBlock(int x, int y, int z) {
        this.index = new BlockIndex(x, y, z);
    }

    public ResourceIdBlock(BlockIndex iIndex) {
        this.index = iIndex;
    }

    public ResourceIdBlock(TileEntity tile) {
        this.index = new BlockIndex(tile);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdBlock compareId = (ResourceIdBlock)obj;
        return this.index.equals(compareId.index) && this.side == compareId.side;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.index.hashCode()).append(this.side != null ? this.side.ordinal() : 0).build();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.func_74782_a("index", (NBTBase)indexNBT);
        nbt.func_74774_a("side", (byte)this.side.ordinal());
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.index = new BlockIndex(nbt.func_74775_l("index"));
        this.side = ForgeDirection.values()[nbt.func_74771_c("side")];
    }
}

