/*
 * Decompiled with CFR 0.152.
 */
package compactengine.tileentity;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.engines.TileEngineBase;
import compactengine.CompactEngine;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCompactEngine
extends TileEngineBase {
    public static final float OUTPUT = 0.5f;
    public static final float HEAT_BASE = 0.025f;
    public int power;
    public int no;
    public int level;
    public int limitTime;
    public int time = 0;
    public int alertTime = 0;
    public double stageRed;
    public static final int explosionPower = CompactEngine.CompactEngineExplosionPowerLevel;
    public static final int explosionTime = CompactEngine.CompactEngineExplosionTimeLevel;
    public static final int alert = CompactEngine.CompactEngineExplosionAlertMinute;
    public static final int[] powerLevel = new int[]{8, 32, 128, 512, 2048};
    public static final int[][] explosionRanges = new int[][]{{2, 4, 6, 10, 16}, {3, 6, 10, 16, 32}, {4, 8, 16, 32, 128}, {8, 32, 128, 512, 2048}};
    public static final int[][] explosionTimes = new int[][]{{120, 90, 60, 30, 15}, {30, 30, 30, 10, 5}, {15, 15, 15, 5, 3}, {5, 5, 5, 3, 1}};

    public TileCompactEngine(int meta) {
        this.initCompactEngine(meta);
    }

    public void initCompactEngine(int meta) {
        this.level = powerLevel[meta];
        this.no = meta;
        this.power = MathHelper.func_76123_f((float)((float)this.level * 0.5f));
        this.time = this.limitTime = explosionTimes[explosionTime][meta] * 20 * 60;
        this.alertTime = alert * 60 * 20;
        this.stageRed = 250.0 * (double)this.level;
    }

    public ResourceLocation getBaseTexture() {
        return CompactEngine.RESOURCE_LOCATION_LIST.get(this.no);
    }

    public ResourceLocation getChamberTexture() {
        return super.getChamberTexture();
    }

    public float getExplosionRange() {
        return explosionRanges[explosionPower][this.no];
    }

    public void updateHeat() {
        if (!this.isRedstonePowered) {
            this.heat -= 0.5f;
        }
    }

    protected TileEngineBase.EnergyStage computeEnergyStage() {
        double energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25) {
            return TileEngineBase.EnergyStage.BLUE;
        }
        if (energyLevel < 0.5) {
            return TileEngineBase.EnergyStage.GREEN;
        }
        if (energyLevel < 0.75) {
            return TileEngineBase.EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0 || this.time > 0) {
            return TileEngineBase.EnergyStage.RED;
        }
        CompactEngine.addChat(StatCollector.func_74838_a((String)"engine.explode"), Float.valueOf(this.getExplosionRange()), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return TileEngineBase.EnergyStage.OVERHEAT;
    }

    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.8f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    public void engineUpdate() {
        super.engineUpdate();
        if (!this.isRedstonePowered) {
            this.time += this.time * 20;
            if (this.time > this.limitTime) {
                this.time = this.limitTime;
            }
        }
        if (this.isRedstonePowered) {
            if (this.getHeatLevel() >= 1.0f && !CompactEngine.neverExplosion) {
                --this.time;
                if (alert != 0 && this.time == this.alertTime) {
                    CompactEngine.addChat(StatCollector.func_74838_a((String)"engine.alert"), this.level, alert, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else {
                this.time = this.limitTime;
            }
        }
        this.heat = MathHelper.func_76131_a((float)this.heat, (float)20.0f, (float)250.0f);
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    protected void burn() {
        if (this.isRedstonePowered) {
            int output;
            this.currentOutput = output = this.power;
            this.heat += 0.025f;
            this.addEnergy(output);
        }
    }

    public void overheat() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.getExplosionRange(), true);
    }

    public int getMaxEnergy() {
        return 100 * this.level * 20;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.time = nbttagcompound.func_74762_e("time");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("time", this.time);
    }

    public int getTime() {
        return this.time;
    }

    public int getIdealOutput() {
        return 0;
    }
}

