/*
 * Decompiled with CFR 0.152.
 */
package compactengine;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import compactengine.CommonProxy;
import compactengine.ExtendedShapedRecipe;
import compactengine.block.BlockCompactEngine;
import compactengine.item.ItemCompactEngine;
import compactengine.tileentity.TileCompactEngine128;
import compactengine.tileentity.TileCompactEngine2048;
import compactengine.tileentity.TileCompactEngine32;
import compactengine.tileentity.TileCompactEngine512;
import compactengine.tileentity.TileCompactEngine8;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="CompactEngine", name="CompactEngine", version="1.7.10-7.1.14-2", dependencies="required-after:BuildCraft|Energy", useMetadata=true)
public class CompactEngine {
    public static final String MOD_ID = "CompactEngine";
    public static final String MOD_NAME = "CompactEngine";
    public static final String MOD_VERSION = "1.7.10-7.1.14-2";
    public static final String MOD_DEPENDENCIES = "required-after:BuildCraft|Energy";
    public static final List<String> TEXTURE_STRING_LIST = Arrays.asList("base_wood1", "base_wood2", "base_wood3", "base_wood4", "base_wood5");
    public static final List<ResourceLocation> RESOURCE_LOCATION_LIST = new ArrayList<ResourceLocation>();
    @SidedProxy(clientSide="compactengine.Client.ClientProxy", serverSide="compactengine.CommonProxy")
    public static CommonProxy proxy;
    public static Block engineBlock;
    public static Item engineItem;
    public static Item energyChecker;
    public static boolean isAddCompactEngine512and2048;
    public static int CompactEngineExplosionPowerLevel;
    public static int CompactEngineExplosionTimeLevel;
    public static int CompactEngineExplosionAlertMinute;
    public static boolean neverExplosion;
    public static ItemStack engine1;
    public static ItemStack engine2;
    public static ItemStack engine3;
    public static ItemStack engine4;
    public static ItemStack engine5;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        isAddCompactEngine512and2048 = config.get("general", "Add high compact engine", false, "add Engine is x512 (Note explosion)").getBoolean(false);
        CompactEngineExplosionPowerLevel = config.get("general", "CompactEngineExplosionPowerLevel", 1, "min=0, max=3").getInt();
        CompactEngineExplosionTimeLevel = config.get("general", "CompactEngineExplosionTimeLevel", 1, "min=0, max=3").getInt();
        CompactEngineExplosionAlertMinute = config.get("general", "CompactEngineExplosionAlertMinute", 3, "0 is not alert display, min=0.0D, max=30.0D").getInt();
        neverExplosion = config.get("general", "neverExplosion", false, "Engine No Explosion").getBoolean(false);
        config.save();
        engineBlock = new BlockCompactEngine().func_149752_b(10.0f).func_149663_c("CompactEngine:CompactEngineWood").func_149658_d("buildcraft:engineWoodBottom");
        GameRegistry.registerBlock((Block)engineBlock, ItemCompactEngine.class, (String)"compactengineblock");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        engine1 = new ItemStack(engineBlock, 1, 0);
        engine2 = new ItemStack(engineBlock, 1, 1);
        engine3 = new ItemStack(engineBlock, 1, 2);
        engine4 = new ItemStack(engineBlock, 1, 3);
        engine5 = new ItemStack(engineBlock, 1, 4);
        proxy.registerTileEntitySpecialRenderer();
        GameRegistry.registerTileEntity(TileCompactEngine8.class, (String)"tile.compactengine8");
        GameRegistry.registerTileEntity(TileCompactEngine32.class, (String)"tile.compactengine32");
        GameRegistry.registerTileEntity(TileCompactEngine128.class, (String)"tile.compactengine128");
        GameRegistry.registerTileEntity(TileCompactEngine512.class, (String)"tile.compactengine512");
        GameRegistry.registerTileEntity(TileCompactEngine2048.class, (String)"tile.compactengine2048");
        ItemStack woodEngine = new ItemStack((Block)BuildCraftCore.engineBlock, 1, 0);
        ItemStack ironEngine = new ItemStack((Block)BuildCraftCore.engineBlock, 1, 2);
        ItemStack ironGear = new ItemStack(BuildCraftCore.ironGearItem);
        ItemStack diaGear = new ItemStack(BuildCraftCore.diamondGearItem);
        ItemStack diaChip = new ItemStack((Item)BuildCraftSilicon.redstoneChipset, 1, 3);
        ItemStack goldORGate = ItemGate.makeGateItem((GateDefinition.GateMaterial)GateDefinition.GateMaterial.GOLD, (GateDefinition.GateLogic)GateDefinition.GateLogic.OR);
        ItemStack diaORGate = ItemGate.makeGateItem((GateDefinition.GateMaterial)GateDefinition.GateMaterial.DIAMOND, (GateDefinition.GateLogic)GateDefinition.GateLogic.OR);
        GameRegistry.addRecipe((ItemStack)engine1, (Object[])new Object[]{"www", "wgw", "www", Character.valueOf('w'), woodEngine, Character.valueOf('g'), ironGear});
        GameRegistry.addRecipe((ItemStack)engine2, (Object[])new Object[]{"geg", "eie", "geg", Character.valueOf('e'), engine1, Character.valueOf('g'), diaGear, Character.valueOf('i'), ironEngine});
        GameRegistry.addRecipe((ItemStack)engine3, (Object[])new Object[]{"geg", "eie", "geg", Character.valueOf('e'), engine2, Character.valueOf('g'), diaChip, Character.valueOf('i'), ironEngine});
        if (isAddCompactEngine512and2048) {
            GameRegistry.addRecipe((IRecipe)new ExtendedShapedRecipe(engine4, "geg", "eie", "geg", Character.valueOf('e'), engine3, Character.valueOf('g'), goldORGate, Character.valueOf('i'), ironEngine));
            GameRegistry.addRecipe((IRecipe)new ExtendedShapedRecipe(engine5, "geg", "eie", "geg", Character.valueOf('e'), engine4, Character.valueOf('g'), diaORGate, Character.valueOf('i'), ironEngine));
        }
    }

    public static void addChat(String message) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(message));
        } else if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148544_a((IChatComponent)new ChatComponentText(message), true);
        }
    }

    public static void addChat(String format, Object ... args) {
        CompactEngine.addChat(String.format(format, args));
    }

    static {
        for (String str : TEXTURE_STRING_LIST) {
            RESOURCE_LOCATION_LIST.add(new ResourceLocation("CompactEngine".toLowerCase(), String.format("textures/blocks/%s.png", str)));
        }
    }
}

