/*
 * Decompiled with CFR 0.152.
 */
package hats.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import hats.common.core.CommonProxy;
import hats.common.core.HatInfo;
import hats.common.entity.EntityHat;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class PacketWornHatList
extends AbstractPacket {
    public ArrayList<String> playerNames;

    public PacketWornHatList() {
    }

    public PacketWornHatList(ArrayList<String> names) {
        this.playerNames = names;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        for (String s : this.playerNames) {
            HatInfo hat = CommonProxy.playerWornHats.get(s);
            if (hat == null) {
                hat = new HatInfo();
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)s);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)hat.hatName);
            buffer.writeInt(hat.colourR);
            buffer.writeInt(hat.colourG);
            buffer.writeInt(hat.colourB);
            buffer.writeInt(hat.alpha);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"#endPacket");
    }

    public void readFrom(ByteBuf buffer, Side side) {
        String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        while (!name.equalsIgnoreCase("#endPacket")) {
            String hatName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int r = buffer.readInt();
            int g = buffer.readInt();
            int b = buffer.readInt();
            int a = buffer.readInt();
            CommonProxy.tickHandlerClient.playerWornHats.put(name, new HatInfo(hatName, r, g, b, a));
            EntityHat hat = CommonProxy.tickHandlerClient.hats.get(name);
            if (hat != null) {
                if (hatName.equalsIgnoreCase(hat.hatName)) {
                    hat.reColour = 20;
                }
                hat.hatName = hatName;
                hat.setR(r);
                hat.setG(g);
                hat.setB(b);
                hat.setA(a);
            }
            name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    public void execute(Side side, EntityPlayer player) {
    }
}

