/*
 * Decompiled with CFR 0.152.
 */
package hats.common.packet;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hats.client.gui.GuiHatSelection;
import hats.client.gui.GuiHatUnlocked;
import hats.client.gui.GuiTradeWindow;
import hats.common.Hats;
import hats.common.core.CommonProxy;
import hats.common.trade.TradeInfo;
import hats.common.trade.TradeRequest;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class PacketString
extends AbstractPacket {
    public int pingId;
    public String pingString;

    public PacketString() {
    }

    public PacketString(int id, String str) {
        this.pingId = id;
        this.pingString = str;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.pingId);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.pingString);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.pingId = buffer.readInt();
        this.pingString = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Side side, EntityPlayer player) {
        if (side.isServer()) {
            switch (this.pingId) {
                case 0: {
                    String plyr1 = this.pingString;
                    EntityPlayerMP plyr = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(plyr1);
                    if (plyr != null && plyr.func_70089_S() && (double)plyr.func_70032_d((Entity)player) < 16.0 && plyr.func_70685_l((Entity)player) && plyr.field_71093_bK == player.field_71093_bK) {
                        TradeRequest tr1 = CommonProxy.tickHandlerServer.playerTradeRequests.get(player.func_70005_c_());
                        if (tr1 != null && tr1.traderName.equalsIgnoreCase(plyr.func_70005_c_())) {
                            CommonProxy.tickHandlerServer.initializeTrade((EntityPlayerMP)player, plyr);
                            return;
                        }
                        TradeRequest tr = CommonProxy.tickHandlerServer.playerTradeRequests.get(plyr.func_70005_c_());
                        if (tr != null && tr.traderName.equalsIgnoreCase(player.func_70005_c_())) return;
                        CommonProxy.tickHandlerServer.playerTradeRequests.put(plyr.func_70005_c_(), new TradeRequest(player.func_70005_c_()));
                        PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketString(1, player.func_70005_c_()), (EntityPlayer)plyr);
                        return;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("hats.trade.cannotFindTrader", new Object[]{plyr1}));
                    return;
                }
                case 1: {
                    String plyr1 = this.pingString;
                    TradeRequest tr = CommonProxy.tickHandlerServer.playerTradeRequests.get(player.func_70005_c_());
                    if (tr == null) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("hats.trade.cannotAcceptTrade", new Object[0]));
                        return;
                    }
                    EntityPlayerMP plyr = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(plyr1);
                    if (plyr != null && plyr.func_70089_S() && (double)plyr.func_70032_d((Entity)player) < 16.0 && plyr.func_70685_l((Entity)player) && plyr.field_71093_bK == player.field_71093_bK) {
                        CommonProxy.tickHandlerServer.playerTradeRequests.remove(player.func_70005_c_());
                        CommonProxy.tickHandlerServer.initializeTrade((EntityPlayerMP)player, plyr);
                        return;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("hats.trade.cannotAcceptTrade", new Object[0]));
                    return;
                }
                case 2: {
                    for (TradeInfo ti : CommonProxy.tickHandlerServer.activeTrades) {
                        if (!ti.isPlayerInTrade(player)) continue;
                        Hats.console("[In-Trade] " + this.pingString, false);
                        ti.sendTradeMessage(this.pingString, ti.getOtherPlayer(player));
                        return;
                    }
                    return;
                }
                case 3: {
                    return;
                }
            }
            return;
        }
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        switch (this.pingId) {
            case 0: {
                if (CommonProxy.tickHandlerClient.serverHats.get(this.pingString) == null) {
                    CommonProxy.tickHandlerClient.serverHats.put(this.pingString, 1);
                    if (CommonProxy.tickHandlerClient.guiHatUnlocked == null) {
                        CommonProxy.tickHandlerClient.guiHatUnlocked = new GuiHatUnlocked(Minecraft.func_71410_x());
                    }
                    CommonProxy.tickHandlerClient.guiHatUnlocked.queueHatUnlocked(this.pingString);
                    break;
                }
                CommonProxy.tickHandlerClient.serverHats.put(this.pingString, CommonProxy.tickHandlerClient.serverHats.get(this.pingString) + 1);
                break;
            }
            case 1: {
                CommonProxy.tickHandlerClient.tradeReq = this.pingString;
                CommonProxy.tickHandlerClient.tradeReqTimeout = 1200;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("random.successful_hit"), (float)1.0f));
                CommonProxy.tickHandlerClient.guiNewTradeReq.queueHatUnlocked(CommonProxy.tickHandlerClient.tradeReq);
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiHatSelection)) break;
                ((GuiHatSelection)Minecraft.func_71410_x().field_71462_r).updateButtonList();
                break;
            }
            case 2: {
                if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiTradeWindow)) break;
                GuiTradeWindow trade = (GuiTradeWindow)Minecraft.func_71410_x().field_71462_r;
                trade.chatMessages.add(this.pingString);
                if (trade.chatMessages.size() <= 1 || !trade.chatMessages.get(trade.chatMessages.size() - 2).startsWith(this.pingString) || !this.pingString.contains(StatCollector.func_74838_a((String)"hats.trade.added")) && !this.pingString.contains(StatCollector.func_74838_a((String)"hats.trade.removed")) || this.pingString.contains(":")) break;
                if (trade.chatMessages.get(trade.chatMessages.size() - 2).equals(this.pingString)) {
                    trade.chatMessages.remove(trade.chatMessages.size() - 1);
                    trade.chatMessages.remove(trade.chatMessages.size() - 1);
                    trade.chatMessages.add(this.pingString + " (2)");
                    break;
                }
                String countStr = trade.chatMessages.get(trade.chatMessages.size() - 2).substring(this.pingString.length() + 2, trade.chatMessages.get(trade.chatMessages.size() - 2).length() - 1);
                int count = 2;
                try {
                    count = Integer.parseInt(countStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                trade.chatMessages.remove(trade.chatMessages.size() - 1);
                trade.chatMessages.remove(trade.chatMessages.size() - 1);
                trade.chatMessages.add(this.pingString + " (" + Integer.toString(count + 1) + ")");
                break;
            }
            case 3: {
                FMLClientHandler.instance().displayGuiScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (GuiScreen)new GuiTradeWindow(this.pingString));
                CommonProxy.tickHandlerClient.tradeReq = null;
                CommonProxy.tickHandlerClient.tradeReqTimeout = 0;
                break;
            }
        }
    }
}

