/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.worldgen;

import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.worldgen.WorldGenPolyGravel;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class ShinColleWorldGen
implements IWorldGenerator {
    private WorldGenerator genPolymetal;
    private WorldGenerator genPolyGravel;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                this.generateSea(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                this.generateSea(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void oreGenerator(WorldGenerator genOres, World world, Random rand, int blockX, int blockZ, int spawnNum, int minY, int maxY) {
        int z = 0;
        int spawnN = spawnNum;
        BiomeGenBase biome = world.func_72807_a(blockX, blockZ);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            spawnN *= 3;
        }
        for (int i = 0; i < spawnN; ++i) {
            int x = blockX + rand.nextInt(16);
            z = blockZ + rand.nextInt(16);
            int y = minY + rand.nextInt(maxY - minY);
            genOres.func_76484_a(world, rand, x, y, z);
        }
    }

    private void generateSurface(World world, Random rand, int x, int z) {
        this.genPolymetal = new WorldGenMinable(ModBlocks.BlockPolymetalOre, 4 + rand.nextInt(4));
        this.oreGenerator(this.genPolymetal, world, rand, x, z, ConfigHandler.polyOreBaseRate, 3, 50);
    }

    private void generateSea(World world, Random rand, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            this.genPolyGravel = new WorldGenPolyGravel(2 + rand.nextInt(2));
            int posZ = 0;
            for (int i = 0; i < ConfigHandler.polyGravelBaseRate; ++i) {
                int posX = x + rand.nextInt(16);
                posZ = z + rand.nextInt(16);
                int posY = world.func_72825_h(posX, posZ);
                this.genPolyGravel.func_76484_a(world, rand, posX, posY, posZ);
            }
        }
    }
}

