/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.tileentity.BasicTileInventory;
import com.lulan.shincolle.tileentity.ITileFurnace;
import com.lulan.shincolle.tileentity.ITileLiquidFurnace;
import com.lulan.shincolle.utility.LogHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityHelper {
    public static boolean decrItemFuel(BasicTileInventory tile) {
        ITileFurnace tile2 = (ITileFurnace)((Object)tile);
        ItemStack stack = null;
        boolean sendUpdate = false;
        int fuelx = 0;
        for (int i = tile.getFuelSlotMin(); i <= tile.getFuelSlotMax(); ++i) {
            FluidStack fluid;
            stack = tile.func_70301_a(i);
            if (stack == null) continue;
            fuelx = TileEntityFurnace.func_145952_a((ItemStack)stack);
            if (fuelx <= 0 && TileEntityHelper.checkLiquidIsLava1000(fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack))) {
                if (fluid.amount > 1000) {
                    LogHelper.info("DEBUG : fluid registry: lava amount > 1000 mb");
                } else {
                    fuelx = 20000;
                }
            }
            if (ConfigHandler.easyMode) {
                fuelx *= 10;
            }
            if (fuelx > 0 && fuelx + tile2.getPowerRemained() < tile2.getPowerMax()) {
                --stack.field_77994_a;
                tile2.setPowerRemained(tile2.getPowerRemained() + fuelx);
                if (stack.field_77994_a <= 0) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                }
                tile.func_70299_a(i, stack);
                sendUpdate = true;
                break;
            }
            if (!(stack.func_77973_b() instanceof IFluidContainerItem)) continue;
            IFluidContainerItem container = (IFluidContainerItem)stack.func_77973_b();
            FluidStack fluid2 = container.getFluid(stack);
            if (stack.field_77994_a > 1) {
                LogHelper.info("DEBUG : lava fluid container stackSize > 1, no drain");
                continue;
            }
            if (!TileEntityHelper.checkLiquidIsLava1000(fluid2)) continue;
            fuelx = 20000;
            if (ConfigHandler.easyMode) {
                fuelx *= 10;
            }
            if (fuelx <= 0 || fuelx + tile2.getPowerRemained() >= tile2.getPowerMax()) continue;
            container.drain(stack, 1000, true);
            tile2.setPowerRemained(tile2.getPowerRemained() + fuelx);
            tile.func_70299_a(i, stack);
            sendUpdate = true;
            break;
        }
        return sendUpdate;
    }

    public static boolean decrLiquidFuel(ITileLiquidFurnace tile) {
        if (tile.getPowerMax() - tile.getPowerRemained() >= 800 && tile.getFluidFuelAmount() >= 40) {
            FluidStack getf = tile.drainFluidFuel(40);
            tile.setPowerRemained(tile.getPowerRemained() + getf.amount * 20);
            return true;
        }
        return false;
    }

    public static int getItemFuelValue(ItemStack fuel) {
        FluidStack fluid;
        int fuelx = 0;
        fuelx = TileEntityFurnace.func_145952_a((ItemStack)fuel);
        if (fuelx <= 0 && TileEntityHelper.checkLiquidIsLava1000(fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fuel))) {
            if (fluid.amount > 1000) {
                LogHelper.info("DEBUG : fluid registry: lava amount > 1000 mb");
                return 0;
            }
            fuelx = 20000;
        }
        if (ConfigHandler.easyMode) {
            fuelx *= 10;
        }
        if (fuel.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)fuel.func_77973_b();
            FluidStack fluid2 = container.getFluid(fuel);
            if (fuel.field_77994_a > 1) {
                LogHelper.info("DEBUG : lava fluid container stackSize > 1, no drain");
                return 0;
            }
            if (TileEntityHelper.checkLiquidIsLava1000(fluid2)) {
                fuelx = 20000;
                if (ConfigHandler.easyMode) {
                    fuelx *= 10;
                }
            }
        }
        return fuelx;
    }

    public static boolean checkLiquidIsLava1000(FluidStack fluid) {
        return TileEntityHelper.checkLiquidIsLavaWithAmount(fluid, 1000);
    }

    public static boolean checkLiquidIsLava(FluidStack fluid) {
        return TileEntityHelper.checkLiquidIsLavaWithAmount(fluid, 0);
    }

    public static boolean checkLiquidIsLavaWithAmount(FluidStack fluid, int amount) {
        return fluid != null && TileEntityHelper.checkLiquidIsLava(fluid.getFluid()) && fluid.amount >= amount;
    }

    public static boolean checkLiquidIsLava(Fluid fluid) {
        return fluid != null && fluid.getUnlocalizedName().equals("fluid.tile.lava");
    }
}

