/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipInvisible;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.utility.EntityHelper;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;

public class TargetHelper {
    public static boolean checkUnattackTarget(Entity target) {
        List<String> unatklist = ServerProxy.getUnattackableTargetClassList();
        String tarClass = target.getClass().getSimpleName();
        if (unatklist != null) {
            for (String s : unatklist) {
                if (!s.equals(tarClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAttackTargetClass(Entity host, Entity target) {
        if (target != null && host instanceof IShipAttackBase) {
            int pid = ((IShipAttackBase)host).getPlayerUID();
            List<String> tarList = ServerProxy.getPlayerTargetClassList(pid);
            String tarClass = target.getClass().getSimpleName();
            if (tarList != null) {
                for (String s : tarList) {
                    if (!s.equals(tarClass)) continue;
                    if (target instanceof EntityTameable && !EntityHelper.checkSameOwner(host, target)) {
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void updateTarget(IShipAttackBase host) {
        EntityLivingBase gettar;
        if (host.getEntityTarget() != null) {
            if (!host.getEntityTarget().func_70089_S()) {
                host.setEntityTarget(null);
            } else if (EntityHelper.checkSameOwner((Entity)host, host.getEntityTarget())) {
                host.setEntityTarget(null);
            }
        }
        if (host.getEntityRevengeTarget() != null) {
            if (!host.getEntityRevengeTarget().func_70089_S()) {
                host.setEntityRevengeTarget(null);
            } else if (host.getTickExisted() - host.getEntityRevengeTime() > 200) {
                host.setEntityRevengeTarget(null);
            }
        }
        if (host instanceof BasicEntityShipHostile && (gettar = ((BasicEntityShipHostile)host).func_70638_az()) != null) {
            if (!gettar.func_70089_S()) {
                ((BasicEntityShipHostile)host).func_70624_b(null);
            } else if (EntityHelper.checkSameOwner((Entity)host, (Entity)gettar)) {
                ((BasicEntityShipHostile)host).func_70624_b(null);
            }
        }
        if (host.getTickExisted() % 64 == 0 && host.getEntityTarget() != null && host.getEntityTarget().func_82150_aj() && host.getStateMinor(38) < 1 && host.getStateMinor(39) < 1) {
            host.setEntityTarget(null);
        }
    }

    public static void setRevengeTargetAroundPlayer(EntityPlayer player, double dist, Entity target) {
        int pid = EntityHelper.getPlayerUID((Entity)player);
        if (pid > 0 && target != null) {
            int getpid = 0;
            List list1 = player.field_70170_p.func_72872_a(BasicEntityShip.class, player.field_70121_D.func_72314_b(dist, dist, dist));
            if (list1 != null && !list1.isEmpty()) {
                for (BasicEntityShip ship : list1) {
                    getpid = ship.getPlayerUID();
                    if (ship.equals(target) || getpid != pid) continue;
                    ship.setEntityRevengeTarget(target);
                    ship.setEntityRevengeTime();
                }
            }
        }
    }

    public static void setRevengeTargetAroundHostileShip(BasicEntityShipHostile host, double dist, Entity target) {
        if (host != null && target != null) {
            boolean getpid = false;
            List list1 = host.field_70170_p.func_72872_a(BasicEntityShipHostile.class, host.field_70121_D.func_72314_b(dist, dist, dist));
            if (list1 != null && !list1.isEmpty()) {
                for (BasicEntityShipHostile ship : list1) {
                    ship.setEntityRevengeTarget(target);
                    ship.setEntityRevengeTime();
                }
            }
        }
    }

    public static class RevengeSelectorForHostile
    implements IEntitySelector {
        private final Entity host;

        public RevengeSelectorForHostile(Entity host) {
            this.host = host;
        }

        public boolean func_82704_a(Entity target2) {
            if (TargetHelper.checkUnattackTarget(target2)) {
                return false;
            }
            if (target2.func_70089_S() && !target2.func_82150_aj()) {
                if (target2 instanceof BasicEntityShipHostile) {
                    return false;
                }
                if (target2 instanceof EntityPlayer) {
                    return !((EntityPlayer)target2).field_71075_bZ.field_75098_d;
                }
                if (target2 instanceof BasicEntityShip || target2 instanceof BasicEntityMount) {
                    return true;
                }
                if (target2 instanceof BasicEntityAirplane || target2 instanceof EntityAbyssMissile) {
                    return !EntityHelper.checkSameOwner(this.host, target2);
                }
                if (!EntityHelper.checkSameOwner(this.host, target2)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SelectorForHostile
    implements IEntitySelector {
        private final Entity host;

        public SelectorForHostile(Entity host) {
            this.host = host;
        }

        public boolean func_82704_a(Entity target2) {
            if (TargetHelper.checkUnattackTarget(target2)) {
                return false;
            }
            if (target2.func_70089_S() && !target2.func_82150_aj()) {
                if (target2 instanceof BasicEntityShipHostile) {
                    return false;
                }
                if (target2 instanceof EntityPlayer) {
                    return !((EntityPlayer)target2).field_71075_bZ.field_75098_d;
                }
                if (target2 instanceof BasicEntityShip || target2 instanceof BasicEntityMount) {
                    return true;
                }
                if (target2 instanceof BasicEntityAirplane || target2 instanceof EntityAbyssMissile) {
                    return !EntityHelper.checkSameOwner(this.host, target2);
                }
            }
            return false;
        }
    }

    public static class RevengeSelector
    implements IEntitySelector {
        protected Entity host;

        public RevengeSelector(Entity host) {
            this.host = host;
        }

        public boolean func_82704_a(Entity target2) {
            BasicEntityShip host2;
            if (this.host == null || this.host.equals((Object)target2)) {
                return false;
            }
            if (TargetHelper.checkUnattackTarget(target2)) {
                return false;
            }
            if (target2.func_82150_aj() && (this.host instanceof BasicEntityShip ? ((BasicEntityShip)this.host).getStateMinor(38) < 1 && ((BasicEntityShip)this.host).getStateMinor(39) < 1 : this.host instanceof IShipOwner && ((IShipOwner)this.host).getHostEntity() instanceof BasicEntityShip && (host2 = (BasicEntityShip)((IShipOwner)this.host).getHostEntity()).getStateMinor(38) < 1 && host2.getStateMinor(39) < 1)) {
                return false;
            }
            if (target2.func_70089_S()) {
                if (target2 instanceof BasicEntityShip || target2 instanceof BasicEntityAirplane || target2 instanceof BasicEntityMount || target2 instanceof EntityAbyssMissile) {
                    return !EntityHelper.checkIsAlly(this.host, target2);
                }
                if (target2 instanceof EntityMob || target2 instanceof EntitySlime) {
                    return true;
                }
                if (!EntityHelper.checkSameOwner(this.host, target2)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Selector
    implements IEntitySelector {
        protected Entity host;
        protected boolean isPVP;
        protected boolean isAA;
        protected boolean isASM;

        public Selector(Entity host) {
            this.host = host;
            if (host instanceof BasicEntityShip) {
                this.isPVP = ((BasicEntityShip)host).getStateFlag(18);
                this.isAA = ((BasicEntityShip)host).getStateFlag(19);
                this.isASM = ((BasicEntityShip)host).getStateFlag(20);
            } else {
                this.isPVP = false;
            }
        }

        public boolean func_82704_a(Entity target2) {
            BasicEntityShip host2;
            if (this.host == null || this.host.equals((Object)target2)) {
                return false;
            }
            if (TargetHelper.checkUnattackTarget(target2)) {
                return false;
            }
            if (target2.func_82150_aj() && (this.host instanceof BasicEntityShip ? ((BasicEntityShip)this.host).getStateMinor(38) < 1 && ((BasicEntityShip)this.host).getStateMinor(39) < 1 : this.host instanceof IShipOwner && ((IShipOwner)this.host).getHostEntity() instanceof BasicEntityShip && (host2 = (BasicEntityShip)((IShipOwner)this.host).getHostEntity()).getStateMinor(38) < 1 && host2.getStateMinor(39) < 1)) {
                return false;
            }
            if (this.host instanceof BasicEntityShip ? ((BasicEntityShip)this.host).getStateFlag(12) && !((BasicEntityShip)this.host).func_70635_at().func_75522_a(target2) : this.host instanceof EntityLiving && !((EntityLiving)this.host).func_70635_at().func_75522_a(target2)) {
                return false;
            }
            if (target2.func_70089_S()) {
                if (target2 instanceof BasicEntityAirplane || target2 instanceof EntityAbyssMissile) {
                    return this.isAA && EntityHelper.checkIsBanned(this.host, target2);
                }
                if (target2 instanceof IShipInvisible) {
                    return this.isASM && EntityHelper.checkIsBanned(this.host, target2);
                }
                if (this.isPVP && (target2 instanceof BasicEntityShip || target2 instanceof BasicEntityMount) && EntityHelper.checkIsBanned(this.host, target2)) {
                    return true;
                }
                if (target2 instanceof EntityMob || target2 instanceof EntitySlime) {
                    return true;
                }
                if (TargetHelper.checkAttackTargetClass(this.host, target2)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Sorter
    implements Comparator {
        private final Entity targetEntity;

        public Sorter(Entity entity) {
            this.targetEntity = entity;
        }

        public int compare(Object target1, Object target2) {
            return this.compare((Entity)target1, (Entity)target2);
        }

        public int compare(Entity target1, Entity target2) {
            double d1;
            double d0 = this.targetEntity.func_70068_e(target1);
            return d0 < (d1 = this.targetEntity.func_70068_e(target2)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

