/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.client.particle.EntityFX91Type;
import com.lulan.shincolle.client.particle.EntityFXChi;
import com.lulan.shincolle.client.particle.EntityFXCraning;
import com.lulan.shincolle.client.particle.EntityFXCube;
import com.lulan.shincolle.client.particle.EntityFXEmotion;
import com.lulan.shincolle.client.particle.EntityFXLaser;
import com.lulan.shincolle.client.particle.EntityFXLaserNoTexture;
import com.lulan.shincolle.client.particle.EntityFXLightning;
import com.lulan.shincolle.client.particle.EntityFXSpray;
import com.lulan.shincolle.client.particle.EntityFXStickyLightning;
import com.lulan.shincolle.client.particle.EntityFXTeam;
import com.lulan.shincolle.client.particle.EntityFXTexts;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.utility.CalcHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ParticleHelper {
    private static Random rand = new Random();

    public static double[] rotateParticleByFace(double x, double y, double z, int f, int len) {
        double[] newParm = new double[3];
        newParm[1] = y;
        switch (f) {
            case 1: 
            case 5: {
                newParm[0] = (double)len - z;
                newParm[2] = x;
                break;
            }
            case 2: 
            case 6: {
                newParm[0] = (double)len - x;
                newParm[2] = (double)len - z;
                break;
            }
            case 3: 
            case 7: {
                newParm[0] = z;
                newParm[2] = (double)len - x;
                break;
            }
            default: {
                newParm[0] = x;
                newParm[2] = z;
            }
        }
        return newParm;
    }

    public static float[] rotateXYZByYawPitch(float x, float y, float z, float yaw, float pitch, float scale) {
        float cosYaw = MathHelper.func_76134_b((float)yaw);
        float sinYaw = MathHelper.func_76126_a((float)yaw);
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch));
        float[] newPos = new float[]{x, y, z};
        newPos[2] = z * cosPitch - y * sinPitch;
        newPos[1] = y * cosPitch + z * sinPitch;
        newPos[0] = x * cosYaw - newPos[2] * sinYaw;
        newPos[2] = newPos[2] * cosYaw + x * sinYaw;
        newPos[0] = newPos[0] * scale;
        newPos[1] = newPos[1] * scale;
        newPos[2] = newPos[2] * scale;
        return newPos;
    }

    public static float[] rotateXZByAxis(float z, float x, float rad, float scale) {
        float cosD = MathHelper.func_76134_b((float)rad);
        float sinD = MathHelper.func_76126_a((float)rad);
        float[] newPos = new float[]{0.0f, 0.0f};
        newPos[0] = z * cosD + x * sinD;
        newPos[1] = x * cosD - z * sinD;
        newPos[0] = newPos[0] * scale;
        newPos[1] = newPos[1] * scale;
        return newPos;
    }

    public static float[] rotateXZByLook(float x, float y, float lookX, float lookY, float scale) {
        float[] degree = CalcHelper.getLookDegree(lookX, 0.0, lookY, false);
        float cosZdeg = MathHelper.func_76134_b((float)degree[0]);
        float sinZdeg = MathHelper.func_76126_a((float)degree[0]);
        float[] newPos = new float[]{0.0f, 0.0f};
        newPos[0] = x * cosZdeg + y * sinZdeg;
        newPos[1] = y * cosZdeg - x * sinZdeg;
        newPos[0] = newPos[0] * scale;
        newPos[1] = newPos[1] * scale;
        return newPos;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnAttackParticleCustomVector(Entity target, double posX, double posY, double posZ, double lookX, double lookY, double lookZ, byte type, boolean isShip) {
        if (target != null) {
            if (isShip) {
                ((EntityLivingBase)target).field_70724_aR = 50;
            }
            ParticleHelper.spawnAttackParticleAt(posX, posY, posZ, lookX, lookY, lookZ, type);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnAttackParticle(Entity target, byte type, boolean setAtkTime) {
        if (setAtkTime && target != null) {
            ((EntityLivingBase)target).field_70724_aR = 50;
        }
        if (type == 0) {
            return;
        }
        double lookX = 0.0;
        double lookY = 0.0;
        double lookZ = 0.0;
        if (target != null) {
            if (type > 9) {
                lookY = (double)target.field_70131_O * 1.3;
            } else if (target.func_70040_Z() != null) {
                lookX = target.func_70040_Z().field_72450_a;
                lookY = target.func_70040_Z().field_72448_b;
                lookZ = target.func_70040_Z().field_72449_c;
            }
            ParticleHelper.spawnAttackParticleAt(target.field_70165_t, target.field_70163_u, target.field_70161_v, lookX, lookY, lookZ, type);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnAttackParticleAt(double posX, double posY, double posZ, double lookX, double lookY, double lookZ, byte type) {
        World world = ClientProxy.getClientWorld();
        double ran1 = 0.0;
        double ran2 = 0.0;
        double ran3 = 0.0;
        float degYaw = 0.0f;
        switch (type) {
            case 1: {
                world.func_72869_a("largeexplode", posX, posY + 2.0, posZ, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                world.func_72869_a("hugeexplosion", posX, posY + 1.0, posZ, 0.0, 0.0, 0.0);
                for (int i = 0; i < 20; ++i) {
                    ran1 = rand.nextFloat() * 6.0f - 3.0f;
                    ran2 = rand.nextFloat() * 6.0f - 3.0f;
                    world.func_72869_a("lava", posX + ran1, posY + 1.0, posZ + ran2, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 7; ++i) {
                    double d0 = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    world.func_72869_a("heart", posX + (double)rand.nextFloat() * 2.0 - 1.0, posY + 0.5 + (double)rand.nextFloat() * 2.0, posZ + (double)(rand.nextFloat() * 2.0f) - 1.0, d0, d1, d2);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < 3; ++i) {
                    ran1 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran2 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran3 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    world.func_72869_a("smoke", posX + ran1, posY + ran2, posZ + ran3, 0.0, lookY, 0.0);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < 3; ++i) {
                    ran1 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran2 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran3 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    world.func_72869_a("smoke", posX + ran1, posY + ran2, posZ + ran3, 0.0, lookY, 0.0);
                    world.func_72869_a("flame", posX + ran3, posY + ran2, posZ + ran1, 0.0, lookY, 0.0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i < 20; ++i) {
                    ran1 = rand.nextFloat() - 0.5f;
                    ran2 = rand.nextFloat();
                    ran3 = rand.nextFloat();
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i, posY + 0.6 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i, lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i, posY + 1.0 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i, lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    ran1 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran2 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    ran3 = (double)rand.nextFloat() * lookX - lookX / 2.0;
                    world.func_72869_a("largesmoke", posX + ran1, posY + ran2, posZ + ran3, 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", posX + ran3, posY + ran2, posZ + ran1, 0.0, 0.05, 0.0);
                }
                break;
            }
            case 8: {
                world.func_72869_a("flame", posX, posY - 0.1, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY + 0.1, posZ, 0.0, 0.0, 0.0);
                break;
            }
            case 9: {
                world.func_72869_a("largeexplode", posX, posY + 1.5, posZ, 0.0, 0.0, 0.0);
                for (int i = 0; i < 12; ++i) {
                    ran1 = rand.nextFloat() * 3.0f - 1.5f;
                    ran2 = rand.nextFloat() * 3.0f - 1.5f;
                    world.func_72869_a("lava", posX + ran1, posY + 1.0, posZ + ran2, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 10: {
                EntityFXTexts particleMiss = new EntityFXTexts(world, posX, posY + lookY, posZ, 1.0f, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleMiss);
                break;
            }
            case 11: {
                EntityFXTexts particleCri = new EntityFXTexts(world, posX, posY + lookY, posZ, 1.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleCri);
                break;
            }
            case 12: {
                EntityFXTexts particleDHit = new EntityFXTexts(world, posX, posY + lookY, posZ, 1.0f, 2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleDHit);
                break;
            }
            case 13: {
                EntityFXTexts particleTHit = new EntityFXTexts(world, posX, posY + lookY, posZ, 1.0f, 3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleTHit);
                break;
            }
            case 14: {
                EntityFXLaser particleLaser = new EntityFXLaser(world, posX, posY, posZ, lookX, lookY, lookZ, 1.0f, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleLaser);
                break;
            }
            case 15: {
                EntityFXSpray particleSpray = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray);
                break;
            }
            case 16: {
                EntityFXSpray particleSpray2 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray2);
                break;
            }
            case 17: {
                EntityFXSpray particleSpray3 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray3);
                break;
            }
            case 18: {
                EntityFXSpray particleSpray4 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 4);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray4);
                break;
            }
            case 19: {
                degYaw = CalcHelper.getLookDegree(lookX, 0.0, lookZ, false)[0];
                float[] newPos1 = ParticleHelper.rotateXZByAxis(0.0f, (float)lookY, degYaw, 1.0f);
                float[] newPos2 = ParticleHelper.rotateXZByAxis(0.0f, (float)(-lookY), degYaw, 1.0f);
                for (int i = 0; i < 12; ++i) {
                    ran1 = rand.nextFloat() - 0.5f;
                    ran2 = rand.nextFloat();
                    ran3 = rand.nextFloat();
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i + (double)newPos1[1], posY + 0.6 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i + (double)newPos1[0], lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i + (double)newPos2[1], posY + 0.6 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i + (double)newPos2[0], lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i + (double)newPos1[1], posY + 0.9 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i + (double)newPos1[0], lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                    world.func_72869_a("largesmoke", posX + lookX - 0.5 + 0.05 * (double)i + (double)newPos2[1], posY + 0.9 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i + (double)newPos2[0], lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                }
                break;
            }
            case 20: {
                for (int i = 0; i < 3; ++i) {
                    world.func_72869_a("smoke", posX, posY + (double)i * 0.1, posZ, lookX, lookY, lookZ);
                }
                break;
            }
            case 21: {
                EntityFXLaser particleLaser2 = new EntityFXLaser(world, posX, posY, posZ, lookX, lookY, lookZ, 4.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleLaser2);
                EntityFXLaser particleLaser3 = new EntityFXLaser(world, posX, posY + 0.4, posZ, lookX, lookY + 0.4, lookZ, 4.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleLaser3);
                EntityFXLaser particleLaser4 = new EntityFXLaser(world, posX, posY + 0.8, posZ, lookX, lookY + 0.8, lookZ, 4.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleLaser4);
                for (int i = 0; i < 20; ++i) {
                    float[] newPos1 = ParticleHelper.rotateXZByAxis(1.0f, 0.0f, 0.314f * (float)i, 1.0f);
                    EntityFXSpray particleSpray5 = new EntityFXSpray(world, lookX, lookY + 0.3, lookZ, (double)newPos1[0] * 0.4, 4.0, (double)newPos1[1] * 0.4, 0);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray5);
                }
                EntityFX91Type particleSpray6 = new EntityFX91Type(world, lookX, lookY + 4.0, lookZ, 0.6f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray6);
                break;
            }
            case 22: {
                for (int i = 0; i < 20; ++i) {
                    float[] newPos1 = ParticleHelper.rotateXZByAxis((float)lookX, 0.0f, 0.314f * (float)i, 1.0f);
                    EntityFXSpray particleSpray7 = new EntityFXSpray(world, posX + (double)newPos1[0] * 1.8, posY + 1.2 + lookY, posZ + (double)newPos1[1] * 1.8, (double)(-newPos1[0]) * 0.06, 0.0, (double)(-newPos1[1]) * 0.06, 5);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray7);
                }
                break;
            }
            case 23: {
                for (int i = 0; i < 20; ++i) {
                    float[] newPos1 = ParticleHelper.rotateXZByAxis((float)lookX, 0.0f, 0.314f * (float)i, 1.0f);
                    EntityFXSpray particleSpray8 = new EntityFXSpray(world, posX, posY + 0.3 + lookY, posZ, (double)newPos1[0] * 0.15, 0.0, (double)newPos1[1] * 0.15, 6);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray8);
                }
                break;
            }
            case 24: {
                for (int i = 0; i < 3; ++i) {
                    world.func_72869_a("largesmoke", posX, posY + (double)i * 0.3, posZ, lookX, lookY, lookZ);
                }
                break;
            }
            case 25: {
                EntityFXTeam particleTeam = new EntityFXTeam(world, (float)lookX, (int)lookY, posX, posY, posZ);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleTeam);
                break;
            }
            case 26: {
                EntityFXSpray particleSpray7 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 7);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray7);
                break;
            }
            case 27: {
                EntityFXSpray particleSpray8 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 8);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray8);
                break;
            }
            case 28: {
                ran1 = (double)rand.nextFloat() * 0.7 - 0.35;
                ran2 = (double)rand.nextFloat() * 0.7 - 0.35;
                world.func_72869_a("dripWater", posX + ran1, posY, posZ + ran2, lookX, lookY, lookZ);
                break;
            }
            case 29: {
                EntityFXSpray particleSpray9 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 9);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray9);
                break;
            }
            case 30: {
                for (int i = 0; i < 12; ++i) {
                    ran1 = rand.nextFloat() * 2.0f - 1.0f;
                    ran2 = rand.nextFloat() * 2.0f - 1.0f;
                    ran3 = rand.nextFloat() * 2.0f - 1.0f;
                    world.func_72869_a("snowballpoof", posX + ran1, posY + 0.8 + ran2, posZ + ran3, lookX * 0.2, 0.5, lookZ * 0.2);
                }
                break;
            }
            case 31: {
                for (int i = 0; i < 20; ++i) {
                    ran1 = rand.nextFloat() - 0.5f;
                    ran2 = rand.nextFloat();
                    ran3 = rand.nextFloat();
                    world.func_72869_a("snowshovel", posX + lookX - 0.5 + 0.05 * (double)i, posY + 0.7 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i, lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                    world.func_72869_a("snowshovel", posX + lookX - 0.5 + 0.05 * (double)i, posY + 0.9 + ran1, posZ + lookZ - 0.5 + 0.05 * (double)i, lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                }
                break;
            }
            case 32: {
                EntityFXSpray particleSpray10 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 10);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray10);
                break;
            }
            case 33: {
                EntityFXSpray particleSpray11 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 11);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray11);
                break;
            }
            case 34: {
                EntityFXTexts particleTDodge = new EntityFXTexts(world, posX, posY + lookY, posZ, 1.0f, 4);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleTDodge);
                break;
            }
            case 35: {
                degYaw = CalcHelper.getLookDegree(lookX, 0.0, lookZ, false)[0];
                float[] newPos1 = ParticleHelper.rotateXZByAxis(0.0f, (float)lookY, degYaw, 1.0f);
                float[] newPos2 = ParticleHelper.rotateXZByAxis(0.0f, (float)(-lookY), degYaw, 1.0f);
                for (int i = 0; i < 12; ++i) {
                    ran1 = rand.nextFloat() - 0.5f;
                    ran2 = rand.nextFloat();
                    ran3 = rand.nextFloat();
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos1[1] + ran2, posY + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos1[0] + ran2, lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos2[1] + ran3, posY + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos2[0] + ran3, lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos1[1] + ran3, posY + 0.3 + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos1[0] + ran3, lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos2[1] + ran2, posY + 0.3 + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos2[0] + ran2, lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos1[1] + ran2, posY + 0.6 + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos1[0] + ran2, lookX * 0.3 * ran3, 0.05 * ran3, lookZ * 0.3 * ran3);
                    world.func_72869_a("largesmoke", posX + lookX - 0.6 + 0.1 * (double)i + (double)newPos2[1] + ran3, posY + 0.6 + ran1, posZ + lookZ - 0.6 + 0.1 * (double)i + (double)newPos2[0] + ran3, lookX * 0.3 * ran2, 0.05 * ran2, lookZ * 0.3 * ran2);
                }
                break;
            }
            case 36: {
                EntityFXEmotion partEmo = new EntityFXEmotion(world, null, posX, posY, posZ, (float)lookX, (float)lookY, (int)lookZ);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)partEmo);
                break;
            }
            case 37: {
                EntityFXSpray particleSpray12 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 12);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray12);
                break;
            }
            case 38: {
                EntityFXSpray particleSpray13 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 13);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray13);
                break;
            }
            case 39: {
                EntityFXSpray particleSpray14 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 14);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray14);
                break;
            }
            case 40: {
                EntityFXCraning particleCrane = new EntityFXCraning(world, posX, posY, posZ, lookX, lookY, lookZ, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleCrane);
                break;
            }
            case 41: {
                EntityFXSpray particleSpray15 = new EntityFXSpray(world, posX, posY, posZ, lookX, lookY, lookZ, 15);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particleSpray15);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnAttackParticleAtEntity(Entity ent, double par1, double par2, double par3, byte type) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityLivingBase host = null;
        double ran1 = 0.0;
        double ran2 = 0.0;
        double ran3 = 0.0;
        double ran4 = 0.0;
        float degYaw = 0.0f;
        switch (type) {
            case 1: {
                EntityFXChi fxChi1 = new EntityFXChi((World)world, ent, (float)par1, (int)par2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fxChi1);
                break;
            }
            case 2: {
                EntityFXTeam fxTeam = new EntityFXTeam((World)world, ent, (float)par1, (int)par2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fxTeam);
                break;
            }
            case 3: {
                EntityFXLightning fxLightning = new EntityFXLightning((World)world, ent, (float)par1, (int)par2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fxLightning);
                break;
            }
            case 4: {
                EntityFXStickyLightning light1 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light1);
                EntityFXStickyLightning light2 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light2);
                EntityFXStickyLightning light3 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light3);
                EntityFXStickyLightning light4 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light4);
                break;
            }
            case 5: {
                degYaw = ((EntityLivingBase)ent).field_70761_aq % 360.0f * ((float)Math.PI / 180);
                float[] newPos1 = ParticleHelper.rotateXZByAxis((float)par2, (float)par1, degYaw, 1.0f);
                float[] newPos2 = ParticleHelper.rotateXZByAxis((float)par2, (float)(-par1), degYaw, 1.0f);
                float[] newPos3 = ParticleHelper.rotateXZByAxis(0.25f, 0.0f, degYaw, 1.0f);
                for (int i = 0; i < 25; ++i) {
                    ran1 = (rand.nextFloat() - 0.5f) * 2.0f;
                    ran2 = (rand.nextFloat() - 0.5f) * 2.0f;
                    ran3 = (rand.nextFloat() - 0.5f) * 2.0f;
                    ran4 = rand.nextFloat() * 2.0f;
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos1[1] + ran1, ent.field_70163_u + par3 + ran2, ent.field_70161_v + (double)newPos1[0] + ran3, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos2[1] + ran1, ent.field_70163_u + par3 + ran3, ent.field_70161_v + (double)newPos2[0] + ran2, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos1[1] + ran2, ent.field_70163_u + par3 + ran1, ent.field_70161_v + (double)newPos1[0] + ran3, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos2[1] + ran2, ent.field_70163_u + par3 + ran3, ent.field_70161_v + (double)newPos2[0] + ran1, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos1[1] + ran3, ent.field_70163_u + par3 + ran1, ent.field_70161_v + (double)newPos1[0] + ran2, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                    world.func_72869_a("largesmoke", ent.field_70165_t + (double)newPos2[1] + ran3, ent.field_70163_u + par3 + ran2, ent.field_70161_v + (double)newPos2[0] + ran1, (double)newPos3[1] * ran4, 0.05 * ran4, (double)newPos3[0] * ran4);
                }
                break;
            }
            case 6: {
                int i;
                for (i = 0; i < 4; ++i) {
                    EntityFXStickyLightning light11 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, 2);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light11);
                }
                for (i = 0; i < 4; ++i) {
                    EntityFXStickyLightning light21 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, 3);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light21);
                }
                break;
            }
            case 7: {
                if (!(ent instanceof EntityLivingBase)) {
                    return;
                }
                host = (EntityLivingBase)ent;
                EntityFXCube cube1 = new EntityFXCube((World)world, host, par1, par2, par3, 1.5f, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)cube1);
                for (int i = 0; i < 6; ++i) {
                    EntityFXStickyLightning light21 = new EntityFXStickyLightning((World)world, ent, (float)par1, 40, 3);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light21);
                }
                break;
            }
            case 8: {
                if (!(ent instanceof EntityLivingBase)) {
                    return;
                }
                host = (EntityLivingBase)ent;
                EntityFXLaserNoTexture laser1 = new EntityFXLaserNoTexture((World)world, host, par1, par2, par3, 0.1f, 3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser1);
                break;
            }
            case 9: {
                EntityFXStickyLightning light5 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light5);
                EntityFXStickyLightning light6 = new EntityFXStickyLightning((World)world, ent, (float)par1, (int)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)light6);
                break;
            }
            case 36: {
                if (ent == null) {
                    return;
                }
                EntityFXEmotion partEmo = new EntityFXEmotion((World)world, ent, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, (float)par1, (float)par2, (int)par3);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)partEmo);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnAttackParticleAtEntity(Entity host, Entity target, double par1, double par2, double par3, byte type, boolean setAtkTime) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityLivingBase host2 = null;
        if (host == null || target == null) {
            return;
        }
        if (setAtkTime) {
            ((EntityLivingBase)host).field_70724_aR = 50;
        }
        double ran1 = 0.0;
        double ran2 = 0.0;
        double ran3 = 0.0;
        float degYaw = 0.0f;
        switch (type) {
            case 0: {
                if (!(host instanceof EntityLivingBase)) {
                    return;
                }
                host2 = (EntityLivingBase)host;
                EntityFXLaserNoTexture laser1 = new EntityFXLaserNoTexture((World)world, host2, target, 0.78f, par1, 0.0, 0.05f, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser1);
                EntityFXLaserNoTexture laser2 = new EntityFXLaserNoTexture((World)world, host2, target, -0.78f, par1, 0.0, 0.05f, 0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser2);
                break;
            }
            case 1: {
                if (!(host instanceof EntityLivingBase)) {
                    return;
                }
                host2 = (EntityLivingBase)host;
                EntityFXCube cube1 = new EntityFXCube((World)world, host2, par1, par2, par3, 2.5f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)cube1);
                EntityFXLaserNoTexture laser3 = new EntityFXLaserNoTexture((World)world, host2, target, par1, par2, par3, 2.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser3);
                break;
            }
            case 2: {
                if (!(host instanceof EntityLivingBase)) {
                    return;
                }
                host2 = (EntityLivingBase)host;
                EntityFXCube cube2 = new EntityFXCube((World)world, host2, par1, par2, par3, 5.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)cube2);
                EntityFXLaserNoTexture laser4 = new EntityFXLaserNoTexture((World)world, host2, target, par1, par2, par3, 4.0f, 1);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser4);
                break;
            }
            case 3: {
                if (!(host instanceof EntityLivingBase)) {
                    return;
                }
                host2 = (EntityLivingBase)host;
                EntityFXLaserNoTexture laser5 = new EntityFXLaserNoTexture((World)world, host2, target, 0.0, 0.0, 0.0, 0.1f, 2);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser5);
                break;
            }
            case 4: {
                if (!(host instanceof EntityLivingBase)) {
                    return;
                }
                host2 = (EntityLivingBase)host;
                EntityFXLaserNoTexture laser6 = new EntityFXLaserNoTexture((World)world, host2, target, 0.0, 0.0, 0.0, 0.1f, 4);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)laser6);
                break;
            }
        }
    }
}

