/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.ExtendPlayerProps;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.reference.Values;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class FormationHelper {
    public static void setFormationID(ExtendPlayerProps props, int formatID) {
        if (props != null) {
            FormationHelper.setFormationID(props, props.getPointerTeamID(), formatID);
        }
    }

    public static void setFormationID(ExtendPlayerProps props, int teamID, int formatID) {
        if (props != null) {
            int num = props.getNumberOfShip(teamID);
            if (num > 4 && formatID > 0) {
                FormationHelper.setFormationForShip(props, teamID, formatID);
                props.setFormatID(teamID, formatID);
                BasicEntityShip[] ships = props.getShipEntityByMode(2);
                FormationHelper.applyFormationMoving(ships, formatID);
            } else {
                LogHelper.info("DEBUG : reset formation ID");
                FormationHelper.setFormationForShip(props, teamID, 0);
                props.setFormatID(teamID, 0);
            }
            props.sendSyncPacket(1);
        }
    }

    public static void setFormationForShip(ExtendPlayerProps props, int teamID, int formatID) {
        BasicEntityShip ship = null;
        float buffMOV = FormationHelper.getFormationBuffValue(formatID, 0)[5];
        float minMOV = 1000.0f;
        float temp = 0.0f;
        for (int i = 0; i < 6; ++i) {
            ship = props.getShipEntity(teamID, i);
            if (ship == null) continue;
            ship.setUpdateFlag(0, true);
            temp = ship.getStateFinalBU(4);
            if (!(temp < minMOV)) continue;
            minMOV = temp;
        }
        minMOV += buffMOV;
        for (int j = 0; j < 6; ++j) {
            ship = props.getShipEntity(teamID, j);
            if (ship == null) continue;
            ship.setEffectFormationFixed(0, minMOV);
            int sid = ship.getShipUID();
            for (int k = 0; k < 9; ++k) {
                int[] temp2;
                if (k == teamID || (temp2 = props.checkIsInTeam(sid, k))[1] <= 0) continue;
                props.setFormatID(k, 0);
                for (int m = 0; m < 6; ++m) {
                    ship = props.getShipEntity(k, m);
                    if (ship == null) continue;
                    ship.setUpdateFlag(0, true);
                }
            }
        }
    }

    public static float getFormationMOV(ExtendPlayerProps props, int teamID) {
        float val = 0.0f;
        if (props != null && teamID >= 0 && teamID < 9) {
            val = props.getMinMOVInTeam(teamID) + FormationHelper.getFormationBuffValue(props.getFormatID(teamID), 0)[5];
        }
        return val;
    }

    public static float[] getFormationBuffValue(int formationID, int slotID) {
        float[] fvalue = Values.FormationBuffsMap.get(formationID * 10 + slotID);
        if (fvalue != null) {
            return fvalue;
        }
        return Values.zeros13;
    }

    public static void applyFormationMoving(BasicEntityShip[] ships, int formatID) {
        if (ships != null) {
            for (BasicEntityShip s : ships) {
                if (s == null || s.getStateMinor(24) == 2 || s.getStateFlag(11)) continue;
                FormationHelper.applyFormationMoving(ships, formatID, (int)s.field_70165_t, (int)s.field_70163_u, (int)s.field_70161_v);
                break;
            }
        }
    }

    public static void applyFormationMoving(BasicEntityShip[] ships, int formatID, int x, int y, int z) {
        BasicEntityShip flagShip = null;
        EntityPlayer owner = null;
        for (BasicEntityShip s : ships) {
            if (s == null) continue;
            flagShip = s;
            owner = EntityHelper.getEntityPlayerByUID(flagShip.getPlayerUID());
            if (owner.field_71093_bK == s.field_71093_bK) break;
            owner = null;
        }
        if (flagShip != null && owner != null) {
            boolean[] faceXP = FormationHelper.getFormationDirection(x, z, flagShip.field_70165_t, flagShip.field_70161_v);
            int[] newPos = new int[]{x, y, z};
            for (BasicEntityShip s : ships) {
                if (s == null) continue;
                switch (formatID) {
                    case 1: 
                    case 4: {
                        newPos = FormationHelper.setFormationPosAndApplyGuardPos1(s, formatID, faceXP[0], faceXP[1], newPos[0], newPos[1], newPos[2]);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        FormationHelper.setFormationPosAndApplyGuardPos2(s, formatID, faceXP[0], faceXP[1], newPos[0], newPos[1], newPos[2]);
                        break;
                    }
                    default: {
                        EntityHelper.applyShipGuard(s, x, y, z);
                    }
                }
                s.applyEmotesReaction(5);
                CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(s, 3), (EntityPlayerMP)owner);
            }
        }
    }

    public static int[] setFormationPosAndApplyGuardPos1(BasicEntityShip ship, int formatType, boolean alongX, boolean faceP, int x, int y, int z) {
        int[] pos = BlockHelper.getSafeBlockWithin5x5(ship.field_70170_p, x, y, z);
        if (pos != null) {
            EntityHelper.applyShipGuard(ship, pos[0], pos[1], pos[2]);
            LogHelper.info("DEBUG : apply formation move: safe: " + pos[0] + " " + pos[1] + " " + pos[2]);
            switch (formatType) {
                case 4: {
                    return FormationHelper.nextEchelonPos(faceP, pos[0], pos[1], pos[2]);
                }
            }
            return FormationHelper.nextLineAheadPos(alongX, faceP, pos[0], pos[1], pos[2]);
        }
        EntityHelper.applyShipGuard(ship, x, y, z);
        LogHelper.info("DEBUG : apply formation move: not safe: " + x + " " + y + " " + z);
        return new int[]{x, y, z};
    }

    public static void setFormationPosAndApplyGuardPos2(BasicEntityShip ship, int formatType, boolean alongX, boolean faceP, int x, int y, int z) {
        int formatPos = ship.getStateMinor(27);
        int[] pos = new int[]{x, y, z};
        if (formatPos < 0 || formatPos > 5) {
            formatPos = 0;
        }
        switch (formatType) {
            case 2: {
                pos = FormationHelper.nextDoubleLinePos(alongX, faceP, formatPos, pos[0], pos[1], pos[2]);
                break;
            }
            case 3: {
                pos = FormationHelper.nextDiamondPos(alongX, faceP, formatPos, pos[0], pos[1], pos[2]);
                break;
            }
            case 5: {
                pos = FormationHelper.nextLineAbreastPos(alongX, formatPos, pos[0], pos[1], pos[2]);
            }
        }
        pos = BlockHelper.getSafeBlockWithin5x5(ship.field_70170_p, pos[0], pos[1], pos[2]);
        if (pos != null) {
            EntityHelper.applyShipGuard(ship, pos[0], pos[1], pos[2]);
            LogHelper.info("DEBUG : apply formation move: safe: " + pos[0] + " " + pos[1] + " " + pos[2]);
        } else {
            EntityHelper.applyShipGuard(ship, x, y, z);
            LogHelper.info("DEBUG : apply formation move: not safe: " + x + " " + y + " " + z);
        }
    }

    public static int[] nextLineAheadPos(boolean alongX, boolean faceP, int x, int y, int z) {
        int[] pos = new int[]{x, y, z};
        if (alongX) {
            pos[0] = faceP ? pos[0] - 3 : pos[0] + 3;
        } else {
            pos[2] = faceP ? pos[2] - 3 : pos[2] + 3;
        }
        return pos;
    }

    public static int[] nextDoubleLinePos(boolean alongX, boolean faceP, int formatPos, int x, int y, int z) {
        int[] pos = new int[]{x, y, z};
        switch (formatPos) {
            case 1: {
                if (alongX) {
                    pos[2] = pos[2] + 3;
                    break;
                }
                pos[0] = pos[0] + 3;
                break;
            }
            case 2: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 3;
                        break;
                    }
                    pos[0] = pos[0] - 3;
                    break;
                }
                if (faceP) {
                    pos[2] = pos[2] + 3;
                    break;
                }
                pos[2] = pos[2] - 3;
                break;
            }
            case 3: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 3;
                        pos[2] = pos[2] + 3;
                        break;
                    }
                    pos[0] = pos[0] - 3;
                    pos[2] = pos[2] + 3;
                    break;
                }
                if (faceP) {
                    pos[0] = pos[0] + 3;
                    pos[2] = pos[2] + 3;
                    break;
                }
                pos[0] = pos[0] + 3;
                pos[2] = pos[2] - 3;
                break;
            }
            case 4: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] - 3;
                        break;
                    }
                    pos[0] = pos[0] + 3;
                    break;
                }
                if (faceP) {
                    pos[2] = pos[2] - 3;
                    break;
                }
                pos[2] = pos[2] + 3;
                break;
            }
            case 5: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] - 3;
                        pos[2] = pos[2] + 3;
                        break;
                    }
                    pos[0] = pos[0] + 3;
                    pos[2] = pos[2] + 3;
                    break;
                }
                if (faceP) {
                    pos[0] = pos[0] + 3;
                    pos[2] = pos[2] - 3;
                    break;
                }
                pos[0] = pos[0] + 3;
                pos[2] = pos[2] + 3;
            }
        }
        return pos;
    }

    public static int[] nextDiamondPos(boolean alongX, boolean faceP, int formatPos, int x, int y, int z) {
        int[] pos = new int[]{x, y, z};
        switch (formatPos) {
            case 1: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 5;
                        break;
                    }
                    pos[0] = pos[0] - 5;
                    break;
                }
                if (faceP) {
                    pos[2] = pos[2] + 5;
                    break;
                }
                pos[2] = pos[2] - 5;
                break;
            }
            case 2: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 1;
                        pos[2] = pos[2] - 4;
                        break;
                    }
                    pos[0] = pos[0] - 1;
                    pos[2] = pos[2] - 4;
                    break;
                }
                if (faceP) {
                    pos[0] = pos[0] - 4;
                    pos[2] = pos[2] + 1;
                    break;
                }
                pos[0] = pos[0] - 4;
                pos[2] = pos[2] - 1;
                break;
            }
            case 3: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 1;
                        pos[2] = pos[2] + 4;
                        break;
                    }
                    pos[0] = pos[0] - 1;
                    pos[2] = pos[2] + 4;
                    break;
                }
                if (faceP) {
                    pos[0] = pos[0] + 4;
                    pos[2] = pos[2] + 1;
                    break;
                }
                pos[0] = pos[0] + 4;
                pos[2] = pos[2] - 1;
                break;
            }
            case 4: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] - 3;
                        break;
                    }
                    pos[0] = pos[0] + 3;
                    break;
                }
                if (faceP) {
                    pos[2] = pos[2] - 3;
                    break;
                }
                pos[2] = pos[2] + 3;
                break;
            }
            case 5: {
                if (alongX) {
                    if (faceP) {
                        pos[0] = pos[0] + 2;
                        break;
                    }
                    pos[0] = pos[0] - 2;
                    break;
                }
                pos[2] = faceP ? pos[2] + 2 : pos[2] - 2;
            }
        }
        return pos;
    }

    public static int[] nextEchelonPos(boolean faceP, int x, int y, int z) {
        int[] pos = new int[]{x, y, z};
        if (faceP) {
            pos[0] = pos[0] - 2;
            pos[2] = pos[2] - 2;
        } else {
            pos[0] = pos[0] + 2;
            pos[2] = pos[2] + 2;
        }
        return pos;
    }

    public static int[] nextLineAbreastPos(boolean alongX, int formatPos, int x, int y, int z) {
        int[] pos = new int[]{x, y, z};
        switch (formatPos) {
            case 1: {
                if (alongX) {
                    pos[2] = pos[2] + 3;
                    break;
                }
                pos[0] = pos[0] + 3;
                break;
            }
            case 2: {
                if (alongX) {
                    pos[2] = pos[2] - 3;
                    break;
                }
                pos[0] = pos[0] - 3;
                break;
            }
            case 3: {
                if (alongX) {
                    pos[2] = pos[2] + 6;
                    break;
                }
                pos[0] = pos[0] + 6;
                break;
            }
            case 4: {
                if (alongX) {
                    pos[2] = pos[2] - 6;
                    break;
                }
                pos[0] = pos[0] - 6;
                break;
            }
            case 5: {
                if (alongX) {
                    pos[2] = pos[2] + 9;
                    break;
                }
                pos[0] = pos[0] + 9;
            }
        }
        return pos;
    }

    public static boolean[] getFormationDirection(double toX, double toZ, double fromX, double fromZ) {
        boolean[] face;
        double dx = toX - fromX;
        double dz = toZ - fromZ;
        face = new boolean[]{CalcHelper.isAbsGreater(dx, dz), face[0] ? dx >= 0.0 : dz >= 0.0};
        return face;
    }

    public static double[] getFormationGuardingPos(IShipAttackBase host, Entity target, double oldX, double oldZ) {
        boolean[] faceXP;
        int formatID = host.getStateMinor(26);
        int formatPos = host.getStateMinor(27);
        double[] pos = new double[]{target.field_70165_t, target.field_70163_u, target.field_70161_v};
        int[] tempPos = null;
        if (formatID <= 0) {
            return pos;
        }
        if (formatPos < 0 || formatPos > 5) {
            formatPos = 0;
        }
        if ((tempPos = FormationHelper.calcFormationPos(formatID, formatPos, pos, faceXP = FormationHelper.getFormationDirection(target.field_70165_t, target.field_70161_v, oldX, oldZ))) != null && (tempPos = BlockHelper.getSafeBlockWithin5x5(target.field_70170_p, tempPos[0], tempPos[1], tempPos[2])) != null) {
            pos[0] = tempPos[0];
            pos[1] = tempPos[1];
            pos[2] = tempPos[2];
        }
        return pos;
    }

    public static int[] calcFormationPos(int formatID, int formatPos, double[] flagshipPos, boolean[] faceXP) {
        int[] newPos = new int[]{(int)flagshipPos[0], (int)(flagshipPos[1] + 0.5), (int)flagshipPos[2]};
        if (formatPos == 0) {
            return newPos;
        }
        switch (formatID) {
            case 1: {
                for (int i = 0; i < formatPos; ++i) {
                    newPos = FormationHelper.nextLineAheadPos(faceXP[0], faceXP[1], newPos[0], newPos[1], newPos[2]);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < formatPos; ++i) {
                    newPos = FormationHelper.nextEchelonPos(faceXP[1], newPos[0], newPos[1], newPos[2]);
                }
                break;
            }
            case 2: {
                newPos = FormationHelper.nextDoubleLinePos(faceXP[0], faceXP[1], formatPos, newPos[0], newPos[1], newPos[2]);
                break;
            }
            case 3: {
                newPos = FormationHelper.nextDiamondPos(faceXP[0], faceXP[1], formatPos, newPos[0], newPos[1], newPos[2]);
                break;
            }
            case 5: {
                newPos = FormationHelper.nextLineAbreastPos(faceXP[0], formatPos, newPos[0], newPos[1], newPos[2]);
            }
        }
        return newPos;
    }
}

