/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.ai.path.ShipMoveHelper;
import com.lulan.shincolle.ai.path.ShipPathEntity;
import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.ai.path.ShipPathPoint;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.entity.ExtendPlayerProps;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipAttributes;
import com.lulan.shincolle.entity.IShipFloating;
import com.lulan.shincolle.entity.IShipGuardian;
import com.lulan.shincolle.entity.IShipInvisible;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.item.PointerItem;
import com.lulan.shincolle.network.C2SInputPackets;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.team.TeamData;
import com.lulan.shincolle.tileentity.ITileWaypoint;
import com.lulan.shincolle.tileentity.TileEntityCrane;
import com.lulan.shincolle.tileentity.TileEntityDesk;
import com.lulan.shincolle.tileentity.TileEntitySmallShipyard;
import com.lulan.shincolle.tileentity.TileEntityWaypoint;
import com.lulan.shincolle.tileentity.TileMultiGrudgeHeavy;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.FormationHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EntityHelper {
    private static Random rand = new Random();

    public static boolean checkEntityIsInLiquid(Entity entity) {
        Block block = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.field_70121_D.field_72338_b, MathHelper.func_76128_c((double)entity.field_70161_v));
        return BlockHelper.checkBlockIsLiquid(block);
    }

    public static boolean checkEntityIsFree(Entity entity) {
        Block block = entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), (int)(entity.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)entity.field_70161_v));
        return BlockHelper.checkBlockSafe(block);
    }

    public static int checkEntityTypeForEquipEffect(Entity entity) {
        if (entity instanceof IShipAttackBase) {
            switch (((IShipAttackBase)entity).getDamageType()) {
                case 7: {
                    return 1;
                }
                case 6: {
                    return 2;
                }
            }
            return 0;
        }
        if (entity instanceof EntityWaterMob) {
            return 2;
        }
        if (entity instanceof EntityBlaze || entity instanceof EntityWither || entity instanceof EntityBat || entity instanceof EntityFlying) {
            return 1;
        }
        return 0;
    }

    public static boolean checkSameOwner(Entity enta, Entity entb) {
        int ida = EntityHelper.getPlayerUID(enta);
        int idb = EntityHelper.getPlayerUID(entb);
        if (!(ida <= 0 && ida >= -1 || idb <= 0 && idb >= -1)) {
            return ida == idb;
        }
        return false;
    }

    public static void checkDepth(IShipFloating entity) {
        Entity entityCD = (Entity)entity;
        Block BlockCheck = EntityHelper.checkBlockWithOffset(entityCD, 0);
        double depth = 0.0;
        if (BlockHelper.checkBlockIsLiquid(BlockCheck)) {
            depth = 1.0;
            int i = 1;
            while (entityCD.field_70163_u + (double)i < 255.0) {
                BlockCheck = EntityHelper.checkBlockWithOffset(entityCD, i);
                if (BlockHelper.checkBlockIsLiquid(BlockCheck)) {
                    depth += 1.0;
                } else {
                    if (BlockCheck.func_149688_o() == Material.field_151579_a) {
                        entity.setStateFlag(0, true);
                        break;
                    }
                    entity.setStateFlag(0, false);
                    break;
                }
                ++i;
            }
            depth -= entityCD.field_70163_u - (double)((int)entityCD.field_70163_u);
        } else {
            depth = 0.0;
            entity.setStateFlag(0, false);
        }
        entity.setShipDepth(depth);
    }

    public static Block checkBlockWithOffset(Entity entity, int par1) {
        int blockX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
        int blockZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        return entity.field_70170_p.func_147439_a(blockX, blockY + par1, blockZ);
    }

    public static boolean checkNotSameEntityID(Entity enta, Entity entb) {
        if (enta != null && entb != null) {
            return enta.func_145782_y() - entb.func_145782_y() != 0;
        }
        return true;
    }

    public static boolean checkOwnerIsPlayer(EntityLivingBase ent) {
        EntityLivingBase getOwner = null;
        if (ent != null) {
            if (EntityHelper.getPlayerUID((Entity)ent) > 0) {
                return true;
            }
            if (ent instanceof EntityTameable) {
                getOwner = ((EntityTameable)ent).func_70902_q();
                return getOwner instanceof EntityPlayer;
            }
        }
        return false;
    }

    public static boolean checkIsAlly(Entity host, Entity target) {
        if (host != null && target != null) {
            int hostID = EntityHelper.getPlayerUID(host);
            int tarID = EntityHelper.getPlayerUID(target);
            return EntityHelper.checkIsAlly(hostID, tarID);
        }
        return false;
    }

    public static boolean checkIsAlly(int hostPID, int tarPID) {
        if (hostPID < -1 && tarPID < -1) {
            return true;
        }
        if (hostPID < -1 && tarPID > 0 || hostPID > 0 && tarPID < -1) {
            return false;
        }
        if (hostPID > 0 && tarPID > 0) {
            if (hostPID == tarPID) {
                return true;
            }
            TeamData hostTeam = EntityHelper.getTeamDataByUID(hostPID);
            TeamData tarTeam = EntityHelper.getTeamDataByUID(tarPID);
            if (hostTeam != null && tarTeam != null) {
                List<Integer> alist = hostTeam.getTeamAllyList();
                return alist.contains(tarTeam.getTeamID());
            }
        }
        return false;
    }

    public static boolean checkIsBanned(Entity host, Entity target) {
        if (host != null && target != null) {
            int hostID = EntityHelper.getPlayerUID(host);
            int tarID = EntityHelper.getPlayerUID(target);
            return EntityHelper.checkIsBanned(hostID, tarID);
        }
        return false;
    }

    public static boolean checkIsBanned(int hostPID, int tarPID) {
        if (hostPID < -1 && tarPID < -1) {
            return false;
        }
        if (hostPID < -1 && tarPID > 0 || hostPID > 0 && tarPID < -1) {
            return true;
        }
        if (hostPID > 0 && tarPID > 0) {
            TeamData hostTeam = EntityHelper.getTeamDataByUID(hostPID);
            TeamData tarTeam = EntityHelper.getTeamDataByUID(tarPID);
            if (hostTeam != null && tarTeam != null) {
                List<Integer> alist = hostTeam.getTeamBannedList();
                return alist.contains(tarTeam.getTeamID());
            }
        }
        return false;
    }

    public static boolean checkShipOutOfCombat(BasicEntityShip ship) {
        return ship != null && ship.field_70173_aa - ship.getCombatTick() > 128;
    }

    public static boolean checkShipColled(int classID, ExtendPlayerProps props) {
        return props != null && props.getColleShipList() != null && props.getColleShipList().contains(classID);
    }

    public static boolean checkEquipColled(int equipID, ExtendPlayerProps props) {
        return props != null && props.getColleEquipList() != null && props.getColleEquipList().contains(equipID);
    }

    public static boolean checkOP(EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            MinecraftServer server = ServerProxy.getServer();
            return server.func_71203_ab().func_152596_g(player.func_146103_bH());
        }
        return false;
    }

    public static boolean checkInUsePointer(EntityPlayer player) {
        return player != null && player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof PointerItem;
    }

    public static boolean checkAttackable(Entity target) {
        if (target != null) {
            List<String> unatklist = ServerProxy.getUnattackableTargetClassList();
            String tarClass = target.getClass().getSimpleName();
            if (unatklist != null) {
                for (String s : unatklist) {
                    if (!s.equals(tarClass)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean doFriendlyFire(IShipOwner attacker, Entity target) {
        if (attacker != null && target != null) {
            int ida = attacker.getPlayerUID();
            int idb = EntityHelper.getPlayerUID(target);
            if (ConfigHandler.friendlyFire) {
                if (ida > 0 && ida == idb) {
                    return false;
                }
            } else {
                if (ida < 0 && idb < 0) {
                    return false;
                }
                if (ida >= -1 && target instanceof EntityPlayer) {
                    return false;
                }
                if (EntityHelper.checkIsAlly(ida, idb)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Entity getEntityByID(int entityID, int worldID, boolean isClient) {
        Object world = isClient ? ClientProxy.getClientWorld() : DimensionManager.getWorld((int)worldID);
        if (world != null && entityID > 0) {
            for (Object obj : world.field_72996_f) {
                if (((Entity)obj).func_145782_y() != entityID) continue;
                return (Entity)obj;
            }
        }
        return null;
    }

    public static BasicEntityShip getShipBySID(int sid) {
        if (sid > 0) {
            Entity getEnt;
            int[] data = ServerProxy.getShipWorldData(sid);
            if (data != null && (getEnt = EntityHelper.getEntityByID(data[0], data[1], false)) instanceof BasicEntityShip) {
                return (BasicEntityShip)getEnt;
            }
        } else {
            return null;
        }
        return null;
    }

    public static EntityPlayer getEntityPlayerByID(int entityID, int worldID, boolean isClient) {
        Object world = isClient ? ClientProxy.getClientWorld() : DimensionManager.getWorld((int)worldID);
        if (world != null && entityID > 0) {
            for (Object obj : world.field_73010_i) {
                if (((Entity)obj).func_145782_y() != entityID) continue;
                return (EntityPlayer)obj;
            }
        }
        return null;
    }

    public static EntityPlayer getEntityPlayerByName(String name) {
        if (name != null) {
            WorldServer[] worlds = ServerProxy.getServerWorld();
            try {
                for (WorldServer w : worlds) {
                    for (Object obj : w.field_73010_i) {
                        if (!(obj instanceof EntityPlayer) || !((EntityPlayer)obj).getDisplayName().equals(name)) continue;
                        return (EntityPlayer)obj;
                    }
                }
            }
            catch (Exception e) {
                LogHelper.info("DEBUG : get EntityPlayer by name fail: " + e);
            }
        }
        return null;
    }

    public static EntityPlayer getEntityPlayerByUID(int uid) {
        if (uid > 0) {
            WorldServer[] worlds = ServerProxy.getServerWorld();
            int peid = EntityHelper.getPlayerEID(uid);
            try {
                for (WorldServer w : worlds) {
                    for (Object obj : w.field_73010_i) {
                        if (!(obj instanceof EntityPlayer) || ((EntityPlayer)obj).func_145782_y() != peid) continue;
                        return (EntityPlayer)obj;
                    }
                }
            }
            catch (Exception e) {
                LogHelper.info("DEBUG : get EntityPlayer by name fail: " + e);
            }
        }
        return null;
    }

    public static int getPlayerEID(int uid) {
        int[] pdata;
        if (uid > 0 && (pdata = ServerProxy.getPlayerWorldData(uid)) != null) {
            return pdata[0];
        }
        return -1;
    }

    public static int getPlayerUID(Entity ent) {
        ExtendPlayerProps extProps;
        Entity owner;
        ExtendPlayerProps extProps2;
        if (ent instanceof EntityPlayer && (extProps2 = (ExtendPlayerProps)ent.getExtendedProperties("TeitokuExtProps")) != null) {
            return extProps2.getPlayerUID();
        }
        if (ent instanceof IShipOwner) {
            return ((IShipOwner)ent).getPlayerUID();
        }
        if (ent instanceof IEntityOwnable && (owner = ((IEntityOwnable)ent).func_70902_q()) instanceof EntityPlayer && (extProps = (ExtendPlayerProps)owner.getExtendedProperties("TeitokuExtProps")) != null) {
            return extProps.getPlayerUID();
        }
        return -1;
    }

    public static List<EntityPlayer> getEntityPlayerUsingGUI() {
        WorldServer[] worlds = ServerProxy.getServerWorld();
        ArrayList<EntityPlayer> plist = new ArrayList<EntityPlayer>();
        for (WorldServer w : worlds) {
            if (w == null) continue;
            for (Object p : w.field_73010_i) {
                ExtendPlayerProps props = EntityHelper.getExtendPlayerProps((EntityPlayer)p);
                if (props == null || !props.isOpeningGUI()) continue;
                plist.add((EntityPlayer)p);
            }
        }
        return plist;
    }

    public static String getPetPlayerUUID(EntityTameable pet) {
        if (pet != null) {
            return pet.func_152113_b();
        }
        return null;
    }

    public static TeamData getTeamDataByUID(int uid) {
        if (uid > 0) {
            return ServerProxy.getTeamData(uid);
        }
        return null;
    }

    public static void setPetPlayerUID(EntityPlayer player, IShipOwner pet) {
        EntityHelper.setPetPlayerUID(EntityHelper.getPlayerUID((Entity)player), pet);
    }

    public static void setPetPlayerUID(int pid, IShipOwner pet) {
        if (pet != null && pid > 0) {
            pet.setPlayerUID(pid);
        }
    }

    public static void setPetPlayerUUID(int pid, EntityTameable pet) {
        if (pet != null) {
            EntityPlayer owner = EntityHelper.getEntityPlayerByUID(pid);
            EntityHelper.setPetPlayerUUID(owner, pet);
        }
    }

    public static void setPetPlayerUUID(EntityPlayer player, EntityTameable pet) {
        if (player != null) {
            EntityHelper.setPetPlayerUUID(player.func_110124_au().toString(), pet);
        }
    }

    public static void setPetPlayerUUID(String uuid, EntityTameable pet) {
        if (pet != null) {
            pet.func_152115_b(uuid);
        }
    }

    public static ExtendPlayerProps getExtendPlayerProps(int entityID, int worldID, boolean isClient) {
        EntityPlayer player = EntityHelper.getEntityPlayerByID(entityID, worldID, isClient);
        if (player != null) {
            return EntityHelper.getExtendPlayerProps(player);
        }
        return null;
    }

    public static ExtendPlayerProps getExtendPlayerProps(int pid) {
        EntityPlayer player = EntityHelper.getEntityPlayerByUID(pid);
        return EntityHelper.getExtendPlayerProps(player);
    }

    public static ExtendPlayerProps getExtendPlayerProps(EntityPlayer player) {
        if (player != null) {
            return (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        }
        return null;
    }

    public static void addPlayerColledShip(int classID, EntityPlayer player) {
        ExtendPlayerProps extProps = EntityHelper.getExtendPlayerProps(player);
        if (extProps != null) {
            extProps.setColleShip(classID);
        }
    }

    public static void addPlayerColledEquip(int equipID, EntityPlayer player) {
        ExtendPlayerProps extProps = EntityHelper.getExtendPlayerProps(player);
        if (extProps != null) {
            extProps.setColleEquip(equipID);
        }
    }

    public static void setPlayerExtProps(int[] value) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        ExtendPlayerProps extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        if (extProps != null) {
            extProps.setRingActiveI(value[0]);
            extProps.setMarriageNum(value[1]);
            extProps.setPlayerUID(value[2]);
            if (!extProps.isRingActive() && !player.field_71075_bZ.field_75098_d && extProps.isRingFlying()) {
                LogHelper.info("DEBUG : cancel fly by right click");
                player.field_71075_bZ.field_75100_b = false;
                extProps.setRingFlying(false);
            }
        }
    }

    public static void setPlayerExtProps(int teamid, int[] formatID, int[] teamlist, boolean[] selstate) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        ExtendPlayerProps extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        if (extProps != null) {
            extProps.setPointerTeamID(teamid);
            extProps.setFormatID(formatID);
            for (int i = 0; i < 6; ++i) {
                extProps.setSelectStateCurrentTeam(i, selstate[i]);
                if (teamlist[i * 2] <= 0) {
                    extProps.addShipEntity(i, null, true);
                } else {
                    Entity getEnt = EntityHelper.getEntityByID(teamlist[i * 2], 0, true);
                    if (getEnt instanceof BasicEntityShip) {
                        extProps.addShipEntity(i, (BasicEntityShip)getEnt, true);
                    } else {
                        extProps.addShipEntity(i, null, true);
                    }
                }
                extProps.setSIDCurrentTeam(i, teamlist[i * 2 + 1]);
            }
        }
    }

    public static void setPlayerByGUI(int value, int value2) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        ExtendPlayerProps extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        if (extProps != null) {
            switch (value) {
                case 0: {
                    extProps.setRingActiveI(value2);
                    break;
                }
                case 1: {
                    extProps.setMarriageNum(value2);
                }
            }
        }
    }

    public static void setEntityByGUI(BasicEntityShip entity, int button, int value) {
        if (entity != null) {
            switch (button) {
                case 0: {
                    entity.setEntityFlagI(3, value);
                    break;
                }
                case 1: {
                    entity.setEntityFlagI(4, value);
                    break;
                }
                case 2: {
                    entity.setEntityFlagI(5, value);
                    break;
                }
                case 3: {
                    entity.setEntityFlagI(6, value);
                    break;
                }
                case 4: {
                    entity.setEntityFlagI(7, value);
                    break;
                }
                case 5: {
                    entity.setStateMinor(10, value);
                    if (entity.getStateMinor(10) < entity.getStateMinor(11)) break;
                    entity.setStateMinor(11, value + 1);
                    break;
                }
                case 6: {
                    entity.setStateMinor(11, value);
                    if (entity.getStateMinor(11) > entity.getStateMinor(10)) break;
                    entity.setStateMinor(10, value - 1);
                    break;
                }
                case 7: {
                    entity.setStateMinor(12, value);
                    break;
                }
                case 8: {
                    entity.setEntityFlagI(21, value);
                    break;
                }
                case 9: {
                    entity.setEntityFlagI(9, value);
                    break;
                }
                case 10: {
                    entity.setEntityFlagI(12, value);
                    break;
                }
                case 11: {
                    entity.setEntityFlagI(18, value);
                    break;
                }
                case 12: {
                    entity.setEntityFlagI(19, value);
                    break;
                }
                case 13: {
                    entity.setEntityFlagI(20, value);
                    break;
                }
                case 14: {
                    entity.setEntityFlagI(22, value);
                    break;
                }
                case 15: {
                    entity.getExtProps().setInventoryPage(value);
                    break;
                }
                case 16: {
                    entity.setEntityFlagI(23, value);
                    break;
                }
                case 17: {
                    entity.setStateMinor(44, value);
                }
            }
        } else {
            LogHelper.info("DEBUG : set entity by GUI fail, entity null");
        }
    }

    public static void setTileEntityByGUI(TileEntity tile, int button, int value, int value2) {
        if (tile instanceof TileEntitySmallShipyard) {
            TileEntitySmallShipyard smalltile = (TileEntitySmallShipyard)tile;
            smalltile.setBuildType(value);
            if (value == 4 || value == 3) {
                int[] getMat = new int[]{0, 0, 0, 0};
                for (int i = 0; i < 4; ++i) {
                    if (smalltile.func_70301_a(i) == null) continue;
                    getMat[i] = smalltile.func_70301_a((int)i).field_77994_a;
                }
                smalltile.setBuildRecord(getMat);
            }
            return;
        }
        if (tile instanceof TileMultiGrudgeHeavy) {
            switch (button) {
                case 0: {
                    ((TileMultiGrudgeHeavy)tile).setBuildType(value);
                    break;
                }
                case 1: {
                    ((TileMultiGrudgeHeavy)tile).setInvMode(value);
                    break;
                }
                case 2: {
                    ((TileMultiGrudgeHeavy)tile).setSelectMat(value);
                    break;
                }
                case 3: {
                    EntityHelper.setLargeShipyardBuildMats((TileMultiGrudgeHeavy)tile, button, value, value2);
                }
            }
        } else if (tile instanceof TileEntityCrane) {
            switch (button) {
                case 4: {
                    ((TileEntityCrane)tile).enabLoad = value != 0;
                    break;
                }
                case 5: {
                    ((TileEntityCrane)tile).enabUnload = value != 0;
                    break;
                }
                case 0: {
                    boolean bl = ((TileEntityCrane)tile).isActive = value != 0;
                    if (((TileEntityCrane)tile).isActive) break;
                    ((TileEntityCrane)tile).ship = null;
                    break;
                }
                case 2: {
                    ((TileEntityCrane)tile).checkMetadata = value != 0;
                    break;
                }
                case 3: {
                    ((TileEntityCrane)tile).checkOredict = value != 0;
                    break;
                }
                case 1: {
                    ((TileEntityCrane)tile).craneMode = value;
                    break;
                }
                case 6: {
                    ((TileEntityCrane)tile).checkNbt = value != 0;
                    break;
                }
                case 7: {
                    if (value > 2) {
                        value = 0;
                    }
                    ((TileEntityCrane)tile).redMode = value;
                }
            }
        } else {
            LogHelper.info("DEBUG : set tile entity by GUI fail: tile: " + tile);
        }
    }

    public static void setTileEntityByGUI(TileEntity tile, int value1, int[] value3) {
        if (tile instanceof TileEntityDesk) {
            if (value1 == 0) {
                ((TileEntityDesk)tile).setSyncData(value3);
            }
        } else {
            LogHelper.info("DEBUG : set tile entity by GUI fail: tile: " + tile);
        }
    }

    private static void setLargeShipyardBuildMats(TileMultiGrudgeHeavy tile, int button, int matType, int value) {
        if (tile == null) {
            return;
        }
        int num = 0;
        boolean num2 = false;
        boolean stockToBuild = true;
        switch (value) {
            case 0: 
            case 4: {
                num = 1000;
                break;
            }
            case 1: 
            case 5: {
                num = 100;
                break;
            }
            case 2: 
            case 6: {
                num = 10;
                break;
            }
            case 3: 
            case 7: {
                num = 1;
            }
        }
        if (value > 3) {
            stockToBuild = false;
        }
        if (stockToBuild) {
            if (num > tile.getMatStock(matType)) {
                num = tile.getMatStock(matType);
            }
            if (num + tile.getMatBuild(matType) > 1000) {
                num = 1000 - tile.getMatBuild(matType);
            }
            tile.addMatStock(matType, -num);
            tile.addMatBuild(matType, num);
        } else {
            if (num > tile.getMatBuild(matType)) {
                num = tile.getMatBuild(matType);
            }
            tile.addMatBuild(matType, -num);
            tile.addMatStock(matType, num);
        }
    }

    public static void updateShipNavigator(IShipAttackBase entity) {
        NetworkRegistry.TargetPoint point;
        int i;
        if (entity == null) {
            return;
        }
        EntityLiving entity2 = (EntityLiving)entity;
        ShipPathNavigate pathNavi = entity.getShipNavigate();
        ShipMoveHelper moveHelper = entity.getShipMoveHelper();
        if (pathNavi != null && moveHelper != null && !pathNavi.noPath()) {
            if (!entity2.func_70661_as().func_75500_f()) {
                entity2.func_70661_as().func_75499_g();
            }
            if (entity.getIsSitting() || entity.getIsLeashed()) {
                entity.getShipNavigate().clearPathEntity();
            } else if (ConfigHandler.debugMode && entity2.field_70173_aa % 20 == 0) {
                ShipPathEntity pathtemp = pathNavi.getPath();
                for (i = 0; i < pathtemp.getCurrentPathLength(); ++i) {
                    ShipPathPoint pointtemp = pathtemp.getPathPointFromIndex(i);
                    point = new NetworkRegistry.TargetPoint(entity2.field_71093_bK, entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v, 48.0);
                    if (i == pathtemp.getCurrentPathIndex()) {
                        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)entity2, 32, (double)pointtemp.xCoord + 0.5, (double)pointtemp.yCoord + 0.5, (double)pointtemp.zCoord + 0.5, 0.0, 0.0, 0.0, false), point);
                        continue;
                    }
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)entity2, 33, (double)pointtemp.xCoord + 0.5, (double)pointtemp.yCoord + 0.5, (double)pointtemp.zCoord + 0.5, 0.0, 0.0, 0.0, false), point);
                }
            }
            entity2.field_70170_p.field_72984_F.func_76320_a("ship navi");
            pathNavi.onUpdateNavigation();
            entity2.field_70170_p.field_72984_F.func_76319_b();
            entity2.field_70170_p.field_72984_F.func_76320_a("ship move");
            moveHelper.onUpdateMoveHelper();
            entity2.field_70170_p.field_72984_F.func_76319_b();
        }
        if (!entity2.func_70661_as().func_75500_f() && ConfigHandler.debugMode && entity2.field_70173_aa % 20 == 0) {
            PathEntity pathtemp2 = entity2.func_70661_as().func_75505_d();
            for (i = 0; i < pathtemp2.func_75874_d(); ++i) {
                PathPoint pointtemp2 = pathtemp2.func_75877_a(i);
                point = new NetworkRegistry.TargetPoint(entity2.field_71093_bK, entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v, 48.0);
                if (i == pathtemp2.func_75873_e()) {
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)entity2, 16, (double)pointtemp2.field_75839_a + 0.5, (double)pointtemp2.field_75837_b + 0.5, (double)pointtemp2.field_75838_c + 0.5, 0.0, 0.0, 0.0, false), point);
                    continue;
                }
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)entity2, 17, (double)pointtemp2.field_75839_a + 0.5, (double)pointtemp2.field_75837_b + 0.5, (double)pointtemp2.field_75838_c + 0.5, 0.0, 0.0, 0.0, false), point);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition getPlayerMouseOverEntity(double dist, float duringTicks) {
        return EntityHelper.getMouseOverEntity(ClientProxy.getMineraft().field_71451_h, dist, duringTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition getMouseOverEntity(EntityLivingBase viewer, double dist, float duringTicks) {
        MovingObjectPosition lookBlock = null;
        if (viewer != null && viewer.field_70170_p != null) {
            lookBlock = viewer.func_70614_a(dist, duringTicks);
            Vec3 vec3 = viewer.func_70666_h(duringTicks);
            double d1 = dist;
            if (lookBlock != null) {
                d1 = lookBlock.field_72307_f.func_72438_d(vec3);
            }
            Vec3 vec31 = viewer.func_70676_i(duringTicks);
            double vec3x = vec31.field_72450_a * dist;
            double vec3y = vec31.field_72448_b * dist;
            double vec3z = vec31.field_72449_c * dist;
            Vec3 vec32 = vec3.func_72441_c(vec3x, vec3y, vec3z);
            Vec3 vec33 = null;
            Object lookEntity = null;
            Entity pointedEntity = null;
            double f1 = 1.0;
            List list = viewer.field_70170_p.func_72839_b((Entity)viewer, viewer.field_70121_D.func_72321_a(vec3x, vec3y, vec3z).func_72314_b(f1, f1, f1));
            double d2 = d1;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70067_L()) continue;
                double f2 = entity.func_70111_Y();
                AxisAlignedBB targetBox = entity.field_70121_D.func_72314_b(f2, f2, f2);
                MovingObjectPosition getObj = targetBox.func_72327_a(vec3, vec32);
                if (targetBox.func_72318_a(vec3)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity;
                    vec33 = getObj == null ? vec3 : getObj.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (getObj == null || !((d3 = vec3.func_72438_d(getObj.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity == viewer.field_70154_o && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity;
                    vec33 = getObj.field_72307_f;
                    continue;
                }
                pointedEntity = entity;
                vec33 = getObj.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < d1 || lookBlock == null)) {
                lookBlock = new MovingObjectPosition(pointedEntity, vec33);
            }
        }
        return lookBlock;
    }

    public static MovingObjectPosition getMouseoverTarget(World world, EntityPlayer player, double dist, boolean par1, boolean par2, boolean par3) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        Vec3 vec31 = vec3.func_72441_c((double)f7 * dist, (double)f6 * dist, (double)f8 * dist);
        return world.func_147447_a(vec3, vec31, par1, par2, par3);
    }

    public static void applyShipGuard(BasicEntityShip ship, int x, int y, int z) {
        if (ship != null) {
            int gx = ship.getStateMinor(14);
            int gy = ship.getStateMinor(15);
            int gz = ship.getStateMinor(16);
            int gd = ship.getStateMinor(17);
            ship.func_70624_b(null);
            ship.setEntityTarget(null);
            if (gx == x && gy == y && gz == z && gd == ship.field_70170_p.field_73011_w.field_76574_g) {
                ship.setGuardedPos(-1, -1, -1, 0, 0);
                ship.setGuardedEntity(null);
                ship.setStateFlag(11, true);
            } else {
                ship.func_70904_g(false);
                ship.setGuardedEntity(null);
                ship.setGuardedPos(x, y, z, ship.field_70170_p.field_73011_w.field_76574_g, 1);
                ship.setStateFlag(11, false);
                if (!ship.getStateFlag(2)) {
                    ship.applyEmotesReaction(5);
                    if (ship.field_70154_o != null && ship.field_70154_o instanceof BasicEntityMount) {
                        ((BasicEntityMount)ship.field_70154_o).getShipNavigate().tryMoveToXYZ(x, y, z, 1.0);
                        ((BasicEntityMount)ship.field_70154_o).func_70671_ap().func_75650_a((double)x, (double)y, (double)z, 30.0f, 40.0f);
                    } else {
                        ship.getShipNavigate().tryMoveToXYZ(x, y, z, 1.0);
                        ship.func_70671_ap().func_75650_a((double)x, (double)y, (double)z, 30.0f, 40.0f);
                    }
                }
            }
        }
    }

    public static void applyShipGuardEntity(BasicEntityShip ship, Entity guarded) {
        if (ship != null) {
            Entity getEnt = ship.getGuardedEntity();
            if (getEnt != null && getEnt.func_145782_y() == guarded.func_145782_y()) {
                ship.setGuardedPos(-1, -1, -1, 0, 0);
                ship.setGuardedEntity(null);
                ship.setStateFlag(11, true);
            } else {
                ship.func_70904_g(false);
                ship.setGuardedPos(-1, -1, -1, guarded.field_70170_p.field_73011_w.field_76574_g, 2);
                ship.setGuardedEntity(guarded);
                ship.setStateFlag(11, false);
                if (!ship.getStateFlag(2)) {
                    ship.applyEmotesReaction(5);
                    if (ship.field_70154_o != null && ship.field_70154_o instanceof BasicEntityMount) {
                        ((BasicEntityMount)ship.field_70154_o).getShipNavigate().tryMoveToEntityLiving(guarded, 1.0);
                    } else {
                        ship.getShipNavigate().tryMoveToEntityLiving(guarded, 1.0);
                    }
                }
            }
        }
    }

    public static void applyTeamAttack(EntityPlayer player, int meta, Entity target) {
        if (target instanceof EntityLivingBase) {
            ExtendPlayerProps props = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
            BasicEntityShip[] ships = props.getShipEntityByMode(meta);
            Object mounts = null;
            int worldID = player.field_70170_p.field_73011_w.field_76574_g;
            if (props != null) {
                switch (meta) {
                    case 0: {
                        if (ships[0] == null || ships[0].field_70170_p.field_73011_w.field_76574_g != worldID || !(player.func_70032_d((Entity)ships[0]) < 64.0f)) break;
                        ships[0].func_70904_g(false);
                        ships[0].setEntityTarget(target);
                        if (!(ships[0].field_70154_o instanceof BasicEntityMount)) break;
                        ((BasicEntityMount)ships[0].field_70154_o).setEntityTarget(target);
                        ships[0].applyEmotesReaction(5);
                        break;
                    }
                    case 1: 
                    case 2: {
                        for (int i = 0; i < ships.length; ++i) {
                            if (ships[i] == null || ships[i].field_70170_p.field_73011_w.field_76574_g != worldID || !(player.func_70032_d((Entity)ships[i]) < 64.0f)) continue;
                            ships[i].func_70904_g(false);
                            ships[i].setEntityTarget(target);
                            ships[i].applyEmotesReaction(5);
                            if (!(ships[i].field_70154_o instanceof BasicEntityMount)) continue;
                            ((BasicEntityMount)ships[i].field_70154_o).setEntityTarget(target);
                        }
                        break;
                    }
                }
            }
        }
    }

    public static void applyTeamGuard(EntityPlayer player, Entity guarded, int meta, int type) {
        ExtendPlayerProps props = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        BasicEntityShip[] ships = props.getShipEntityByMode(meta);
        int worldID = player.field_70170_p.field_73011_w.field_76574_g;
        if (props != null) {
            int formatID = props.getFormatIDCurrentTeam();
            switch (meta) {
                case 0: {
                    if (ships[0] == null || ships[0].field_70170_p.field_73011_w.field_76574_g != worldID || formatID > 0 || !(player.func_70032_d((Entity)ships[0]) < 64.0f)) break;
                    EntityHelper.applyShipGuardEntity(ships[0], guarded);
                    CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(ships[0], 3), (EntityPlayerMP)player);
                    break;
                }
                case 1: {
                    for (int i = 0; i < ships.length; ++i) {
                        if (ships[i] == null || ships[i].field_70170_p.field_73011_w.field_76574_g != worldID || formatID > 0 || !(player.func_70032_d((Entity)ships[i]) < 64.0f)) continue;
                        EntityHelper.applyShipGuardEntity(ships[i], guarded);
                        CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(ships[i], 3), (EntityPlayerMP)player);
                    }
                    break;
                }
                case 2: {
                    if (props.getNumberOfShip(props.getPointerTeamID()) <= 4) break;
                    for (int i = 0; i < ships.length; ++i) {
                        if (ships[i] == null || ships[i].field_70170_p.field_73011_w.field_76574_g != worldID || !(player.func_70032_d((Entity)ships[i]) < 64.0f)) continue;
                        EntityHelper.applyShipGuardEntity(ships[i], guarded);
                        CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(ships[i], 3), (EntityPlayerMP)player);
                    }
                    break;
                }
            }
        }
    }

    public static void applyTeamMove(EntityPlayer player, int[] parms) {
        ExtendPlayerProps props = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        BasicEntityShip[] ships = props.getShipEntityByMode(parms[0]);
        int worldID = player.field_70170_p.field_73011_w.field_76574_g;
        if (props != null && ships != null && ships.length > 0) {
            int formatID = props.getFormatIDCurrentTeam();
            switch (parms[0]) {
                case 0: {
                    if (ships[0] == null || ships[0].field_70170_p.field_73011_w.field_76574_g != worldID || formatID > 0 || !(player.func_70032_d((Entity)ships[0]) < 64.0f)) break;
                    EntityHelper.applyShipGuard(ships[0], parms[2], parms[3], parms[4]);
                    CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(ships[0], 3), (EntityPlayerMP)player);
                    break;
                }
                case 1: {
                    for (int i = 0; i < ships.length; ++i) {
                        if (ships[i] == null || ships[i].field_70170_p.field_73011_w.field_76574_g != worldID || formatID > 0 || !(player.func_70032_d((Entity)ships[i]) < 64.0f)) continue;
                        EntityHelper.applyShipGuard(ships[i], parms[2], parms[3], parms[4]);
                        CommonProxy.channelE.sendTo((IMessage)new S2CEntitySync(ships[i], 3), (EntityPlayerMP)player);
                    }
                    break;
                }
                case 2: {
                    if (props.getNumberOfShip(props.getPointerTeamID()) <= 4 && formatID != 0) break;
                    boolean canMove = true;
                    for (BasicEntityShip s : ships) {
                        if (s == null || s.getStateMinor(26) == formatID && !(player.func_70032_d((Entity)s) > 64.0f) && player.field_71093_bK == s.field_71093_bK) continue;
                        canMove = false;
                        break;
                    }
                    if (!canMove) break;
                    FormationHelper.applyFormationMoving(ships, formatID, parms[2], parms[3], parms[4]);
                }
            }
        }
    }

    public static void applyTeamSit(EntityPlayer player, int meta, int shipUID) {
        ExtendPlayerProps props = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        BasicEntityShip[] ships = props.getShipEntityByMode(meta);
        int worldID = player.field_70170_p.field_73011_w.field_76574_g;
        if (props != null) {
            if (props.checkIsInCurrentTeam(shipUID) < 0 && meta < 3) {
                BasicEntityShip target = EntityHelper.getShipBySID(shipUID);
                target.setEntitySit();
            } else {
                switch (meta) {
                    case 0: {
                        if (ships[0] == null || ships[0].field_70170_p.field_73011_w.field_76574_g != worldID) break;
                        ships[0].setEntitySit();
                        break;
                    }
                    case 1: 
                    case 2: {
                        for (int i = 0; i < ships.length; ++i) {
                            if (ships[i] == null || ships[i].field_70170_p.field_73011_w.field_76574_g != worldID) continue;
                            ships[i].setEntitySit();
                        }
                        break;
                    }
                }
            }
        }
    }

    public static void applyTeamSelect(EntityPlayer player, int meta, int shipUID) {
        ExtendPlayerProps props = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        if (props != null) {
            int i = props.checkIsInCurrentTeam(shipUID);
            if (i >= 0) {
                switch (meta) {
                    case 0: {
                        props.clearSelectStateCurrentTeam();
                        props.setSelectStateCurrentTeam(i, true);
                        break;
                    }
                    case 1: {
                        props.setSelectStateCurrentTeam(i, !props.getSelectStateCurrentTeam(i));
                    }
                }
            }
            props.sendSyncPacket(0);
        }
    }

    public static void applyShipEmotesAOEHostile(World world, double x, double y, double z, double range, int emotesType) {
        AxisAlignedBB box;
        List slist;
        if (!world.field_72995_K && (slist = world.func_72872_a(BasicEntityShipHostile.class, box = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range)))) != null) {
            for (BasicEntityShipHostile s : slist) {
                if (!s.func_70089_S()) continue;
                s.applyEmotesReaction(emotesType);
            }
        }
    }

    public static void applyShipEmotesAOE(World world, double x, double y, double z, double range, int emotesType) {
        AxisAlignedBB box;
        List slist;
        if (!world.field_72995_K && (slist = world.func_72872_a(BasicEntityShip.class, box = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range)))) != null) {
            for (BasicEntityShip s : slist) {
                if (!s.func_70089_S()) continue;
                s.applyEmotesReaction(emotesType);
            }
        }
    }

    public static void applyShipEmotesAOECheckOwner(World world, double x, double y, double z, double range, int emotesType, int ownerUID) {
        AxisAlignedBB box;
        List slist;
        if (!world.field_72995_K && (slist = world.func_72872_a(BasicEntityShip.class, box = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + range), (double)(y + range), (double)(z + range)))) != null) {
            for (BasicEntityShip s : slist) {
                if (!s.func_70089_S() || s.getPlayerUID() != ownerUID) continue;
                s.applyEmotesReaction(emotesType);
            }
        }
    }

    public static void applyEmotesAOE(List entlist, int emotes) {
        if (entlist != null && !entlist.isEmpty()) {
            Entity s = (Entity)entlist.get(0);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(s.field_71093_bK, s.field_70165_t, s.field_70163_u, s.field_70161_v, 48.0);
            for (Object o : entlist) {
                if (!(s instanceof Entity)) continue;
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)o, 36, ((Entity)o).field_70131_O * 0.6f, 0.0, emotes), point);
            }
        }
    }

    public static boolean updateWaypointMove(IShipGuardian entity) {
        boolean updatePos = false;
        if (!(entity.getStateFlag(11) || entity.getGuardedPos(1) <= 0 || entity.getIsSitting() || entity.getIsLeashed() || entity.getIsRiding())) {
            float dx = (float)((double)entity.getGuardedPos(0) + 0.5 - ((Entity)entity).field_70165_t);
            float dy = (float)((double)entity.getGuardedPos(1) - ((Entity)entity).field_70163_u);
            float dz = (float)((double)entity.getGuardedPos(2) + 0.5 - ((Entity)entity).field_70161_v);
            dx *= dx;
            dy *= dy;
            dz *= dz;
            double distsq = dx + dy + dz;
            TileEntity tile = ((Entity)entity).field_70170_p.func_147438_o(entity.getGuardedPos(0), entity.getGuardedPos(1), entity.getGuardedPos(2));
            if (tile instanceof TileEntityCrane) {
                if (distsq < 25.0) {
                    if (entity.getStateMinor(43) == 0) {
                        entity.setStateMinor(43, 1);
                        if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                            ((IShipGuardian)((Entity)entity).field_70153_n).setStateMinor(43, 1);
                            ((Entity)entity).field_70153_n.func_70078_a(null);
                        }
                    }
                } else {
                    entity.getShipNavigate().tryMoveToXYZ((double)entity.getGuardedPos(0) + 0.5, (double)entity.getGuardedPos(1) - 2.0, (double)entity.getGuardedPos(2) + 0.5, 1.0);
                }
            } else {
                entity.setStateMinor(43, 0);
                if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                    ((IShipGuardian)((Entity)entity).field_70153_n).setStateMinor(43, 0);
                }
            }
            if (tile instanceof TileEntityWaypoint) {
                if (distsq < 9.0) {
                    try {
                        updatePos = EntityHelper.applyNextWaypoint((TileEntityWaypoint)tile, entity, true, 16);
                        if (updatePos) {
                            entity.setStateMinor(10, 2);
                            entity.getShipNavigate().tryMoveToXYZ((double)entity.getGuardedPos(0) + 0.5, entity.getGuardedPos(1), (double)entity.getGuardedPos(2) + 0.5, 1.0);
                        }
                        return updatePos;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (entity.getTickExisted() % 128 == 0) {
                    entity.getShipNavigate().tryMoveToXYZ((double)entity.getGuardedPos(0) + 0.5, entity.getGuardedPos(1), (double)entity.getGuardedPos(2) + 0.5, 1.0);
                }
            }
        }
        return updatePos;
    }

    public static boolean applyNextWaypoint(ITileWaypoint tile, IShipGuardian entity, boolean checkWpStay, int checkDelay) {
        boolean changed = false;
        boolean timeout = !checkWpStay;
        int[] next = tile.getNextWaypoint();
        int[] last = tile.getLastWaypoint();
        int[] shiplast = entity.getLastWaypoint();
        int wpstay = entity.getWpStayTime();
        if (checkWpStay) {
            int staytimemax = Math.max(entity.getWpStayTimeMax(), tile.getWpStayTime());
            if (wpstay < staytimemax) {
                entity.setWpStayTime(wpstay + checkDelay);
            } else {
                timeout = true;
            }
        }
        if (timeout) {
            entity.setWpStayTime(0);
            if (next[1] > 0 && next[0] == shiplast[0] && next[1] == shiplast[1] && next[2] == shiplast[2]) {
                if (last[1] <= 0) {
                    if (next[1] > 0) {
                        entity.setGuardedPos(next[0], next[1], next[2], ((Entity)entity).field_71093_bK, 1);
                        changed = true;
                        if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                            ((IShipGuardian)((Entity)entity).field_70153_n).setGuardedPos(next[0], next[1], next[2], ((Entity)entity).field_71093_bK, 1);
                        }
                    }
                } else {
                    entity.setGuardedPos(last[0], last[1], last[2], ((Entity)entity).field_71093_bK, 1);
                    changed = true;
                    if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                        ((IShipGuardian)((Entity)entity).field_70153_n).setGuardedPos(last[0], last[1], last[2], ((Entity)entity).field_71093_bK, 1);
                    }
                }
            } else if (next[1] > 0) {
                entity.setGuardedPos(next[0], next[1], next[2], ((Entity)entity).field_71093_bK, 1);
                changed = true;
                if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                    ((IShipGuardian)((Entity)entity).field_70153_n).setGuardedPos(next[0], next[1], next[2], ((Entity)entity).field_71093_bK, 1);
                }
            }
            entity.setLastWaypoint(new int[]{((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e});
            if (((Entity)entity).field_70153_n instanceof IShipGuardian) {
                ((IShipGuardian)((Entity)entity).field_70153_n).setLastWaypoint(new int[]{((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e});
            }
        }
        return changed;
    }

    public static boolean canDodge(IShipAttributes ent, float dist) {
        if (ent != null && !((Entity)ent).field_70170_p.field_72995_K) {
            int dodge = (int)ent.getEffectEquip(6);
            Entity ent2 = (Entity)ent;
            if (ent instanceof IShipInvisible && dist > 36.0f && (dodge += (int)((IShipInvisible)((Object)ent)).getInvisibleLevel()) > (int)ConfigHandler.limitShipEffect[6]) {
                dodge = (int)ConfigHandler.limitShipEffect[6];
            }
            if (rand.nextInt(101) <= dodge) {
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(ent2.field_71093_bK, ent2.field_70165_t, ent2.field_70163_u, ent2.field_70161_v, 32.0);
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(ent2, 34, false), point);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void processShipChangeOwner(int senderEID, int ownerEID) {
        EntityPlayer sender = EntityHelper.getEntityPlayerByID(senderEID, 0, true);
        if (sender != null) {
            MovingObjectPosition hitObj = EntityHelper.getPlayerMouseOverEntity(32.0, 1.0f);
            if (hitObj != null && hitObj.field_72308_g instanceof BasicEntityShip) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipChangeOwner: ship: " + EnumChatFormatting.AQUA + hitObj.field_72308_g));
                CommonProxy.channelG.sendToServer((IMessage)new C2SInputPackets(3, ownerEID, hitObj.field_72308_g.func_145782_y(), hitObj.field_72308_g.field_70170_p.field_73011_w.field_76574_g));
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipChangeOwner: entity is not ship!"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void processShowShipInfo(int senderEID) {
        MovingObjectPosition hitObj;
        EntityPlayer sender = EntityHelper.getEntityPlayerByID(senderEID, 0, true);
        if (sender != null && (hitObj = EntityHelper.getPlayerMouseOverEntity(32.0, 1.0f)) != null && hitObj.field_72308_g instanceof BasicEntityShip) {
            BasicEntityShip ship = (BasicEntityShip)hitObj.field_72308_g;
            sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipInfo: User: " + EnumChatFormatting.LIGHT_PURPLE + sender.getDisplayName() + EnumChatFormatting.RESET + " UID: " + EnumChatFormatting.AQUA + EntityHelper.getPlayerUID((Entity)sender) + EnumChatFormatting.RESET + " UUID: " + EnumChatFormatting.GOLD + sender.func_110124_au()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Ship Name: " + EnumChatFormatting.AQUA + ship.func_94057_bL()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Ship EntityID: " + EnumChatFormatting.GOLD + ship.func_145782_y()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Ship UID: " + EnumChatFormatting.GREEN + ship.getShipUID()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Ship Owner UID: " + EnumChatFormatting.RED + ship.getPlayerUID()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Ship Owner UUID: " + EnumChatFormatting.YELLOW + EntityHelper.getPetPlayerUUID(ship)));
            sender.func_145747_a((IChatComponent)new ChatComponentText("Morale: " + EnumChatFormatting.YELLOW + ship.getStateMinor(30)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void processSetShipAttrs(int[] cmdData) {
        MovingObjectPosition hitObj;
        EntityPlayer sender = EntityHelper.getEntityPlayerByID(cmdData[0], 0, true);
        if (sender != null && (hitObj = EntityHelper.getPlayerMouseOverEntity(16.0, 1.0f)) != null && hitObj.field_72308_g instanceof BasicEntityShip) {
            BasicEntityShip ship = (BasicEntityShip)hitObj.field_72308_g;
            if (cmdData.length == 8) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipAttrs: Set ship value: LV: " + EnumChatFormatting.LIGHT_PURPLE + cmdData[1] + EnumChatFormatting.RESET + " BonusValue: " + EnumChatFormatting.RED + cmdData[2] + " " + cmdData[3] + " " + cmdData[4] + " " + cmdData[5] + " " + cmdData[6] + " " + cmdData[7]));
                sender.func_145747_a((IChatComponent)new ChatComponentText("Target Ship: " + EnumChatFormatting.AQUA + ship));
                CommonProxy.channelG.sendToServer((IMessage)new C2SInputPackets(4, ship.func_145782_y(), ship.field_70170_p.field_73011_w.field_76574_g, cmdData[1], cmdData[2], cmdData[3], cmdData[4], cmdData[5], cmdData[6], cmdData[7]));
            } else if (cmdData.length == 2) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Command: ShipAttrs: Set ship value: LV: " + EnumChatFormatting.LIGHT_PURPLE + cmdData[1]));
                sender.func_145747_a((IChatComponent)new ChatComponentText("Target Ship: " + EnumChatFormatting.AQUA + ship));
                CommonProxy.channelG.sendToServer((IMessage)new C2SInputPackets(4, ship.func_145782_y(), ship.field_70170_p.field_73011_w.field_76574_g, cmdData[1]));
            }
        }
    }

    public static int getEntityNumber(int type, World world) {
        int count = 0;
        if (world != null) {
            block4: for (Object obj : world.field_72996_f) {
                switch (type) {
                    case 1: {
                        if (!(obj instanceof IBossDisplayData)) continue block4;
                        ++count;
                        continue block4;
                    }
                    case 2: {
                        if (!(obj instanceof BasicEntityShipHostile)) continue block4;
                        ++count;
                        continue block4;
                    }
                }
                if (!(obj instanceof BasicEntityShipHostile) || obj instanceof IBossDisplayData) continue;
                ++count;
            }
        }
        return count;
    }

    public static void clearMountSeat(EntityLiving host) {
        if (host.field_70154_o != null) {
            if (host.field_70154_o instanceof BasicEntityMount) {
                BasicEntityMount mount = (BasicEntityMount)host.field_70154_o;
                if (mount.seat2 != null) {
                    mount.seat2.setRiderNull();
                }
            }
            host.field_70154_o.field_70153_n = null;
            host.field_70154_o = null;
        }
        if (host.field_70153_n != null) {
            if (host.field_70153_n instanceof BasicEntityShip) {
                host.field_70153_n.func_70107_b(host.field_70165_t, host.field_70163_u, host.field_70161_v);
            }
            host.field_70153_n.field_70154_o = null;
            host.field_70153_n = null;
        }
    }
}

