/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.entity.IShipAttributes;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.reference.Values;
import com.lulan.shincolle.utility.EntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

public class CalcHelper {
    public static float[] NORM_TABLE = new float[2000];
    private static float NORM_MIN = 0.2f;

    public static String tick2SecOrMin(int ticks) {
        int t = (int)((float)ticks * 0.05f);
        if (t >= 60) {
            t = (int)((float)t * 0.016666668f);
            return String.valueOf(t) + "m";
        }
        return String.valueOf(t) + "s";
    }

    public static String getTimeFormated(int sec) {
        int timeSec = 0;
        int timeMin = 0;
        int timeHr = 0;
        timeSec = sec % 60;
        timeMin = sec % 3600 / 60;
        timeHr = sec / 3600;
        return CalcHelper.get2Digit(timeHr) + ":" + CalcHelper.get2Digit(timeMin) + ":" + CalcHelper.get2Digit(timeSec);
    }

    public static String get2Digit(int num) {
        if (num == 0) {
            return "00";
        }
        if (num < 10) {
            return "0" + num;
        }
        return String.valueOf(num);
    }

    public static int boolean2int(boolean par1) {
        return par1 ? 0 : 1;
    }

    public static int min(double a, double b, double c) {
        if (a <= b) {
            if (a <= c) {
                return 1;
            }
            return 3;
        }
        if (b <= c) {
            return 2;
        }
        return 3;
    }

    public static float calcDamageByType(float dmg, int typeAtk, int typeDef, int modSet) {
        if (typeAtk <= 0 || typeDef <= 0) {
            return dmg;
        }
        float mod = 1.0f;
        mod = modSet > 0 ? Values.ModDmgNight[typeAtk - 1][typeDef - 1] : Values.ModDmgDay[typeAtk - 1][typeDef - 1];
        return dmg * mod;
    }

    public static float calcDamageBySpecialEffect(IShipAttributes host, Entity target, float dmg, int type) {
        float newDmg = dmg;
        float modEffect = 1.0f;
        switch (type) {
            case 2: {
                modEffect = 4.0f;
                break;
            }
            case 3: {
                modEffect = 1.5f;
                break;
            }
            default: {
                modEffect = 1.0f;
            }
        }
        int targettype = EntityHelper.checkEntityTypeForEquipEffect(target);
        if (targettype == 1) {
            newDmg += host.getEffectEquip(4) * modEffect;
        } else if (targettype == 2) {
            newDmg += host.getEffectEquip(5) * modEffect;
        }
        return newDmg;
    }

    public static float calcNormalDist(float x, float mean, float sd) {
        float s1 = 2.5066283f;
        float s2 = 1.0f / (sd * s1);
        float s3 = x - mean;
        float s4 = -(s3 * s3);
        float s5 = 2.0f * sd * sd;
        float s6 = (float)Math.exp(s4 / s5);
        return s2 * s6;
    }

    public static float getNormDist(int x) {
        if (x > -1 && x < 2000) {
            return NORM_TABLE[x];
        }
        return NORM_MIN;
    }

    public static String[] stringConvNewlineToArray(String str) {
        String[] strSplit = str.split("<BR>|<BR/>|<br>|<br/>");
        return strSplit;
    }

    public static List<String> stringConvNewlineToList(String str) {
        String[] strSplit;
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strSplit = CalcHelper.stringConvNewlineToArray(str)) {
            result.add(s);
        }
        return result;
    }

    public static List<Integer> intArrayToList(int[] iarray) {
        if (iarray != null && iarray.length > 0) {
            ArrayList<Integer> ilist = new ArrayList<Integer>();
            for (int i = 0; i < iarray.length; ++i) {
                ilist.add(iarray[i]);
            }
            return ilist;
        }
        return new ArrayList<Integer>();
    }

    public static int[] intListToArray(List<Integer> ilist) {
        if (ilist != null && !ilist.isEmpty()) {
            int[] iarray = new int[ilist.size()];
            for (int i = 0; i < ilist.size(); ++i) {
                iarray[i] = ilist.get(i);
            }
            return iarray;
        }
        return new int[0];
    }

    public static <T> List<T> listUnion(List<T> list1, List<T> list2) {
        HashSet<T> set1 = new HashSet<T>();
        set1.addAll(list1);
        set1.addAll(list2);
        ArrayList retlist = new ArrayList(set1);
        return retlist;
    }

    public static boolean isAbsGreater(double a, double b) {
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        return a > b;
    }

    public static float[] getLookDegree(double motX, double motY, double motZ, boolean getDegree) {
        double f1 = MathHelper.func_76133_a((double)(motX * motX + motZ * motZ));
        float[] degree = new float[2];
        degree[1] = -((float)Math.atan2(motY, f1));
        degree[0] = -((float)Math.atan2(motX, motZ));
        if (getDegree) {
            degree[0] = degree[0] * 57.29578f;
            degree[1] = degree[1] * 57.29578f;
        }
        return degree;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getEntityHitHeightByClientPlayer(Entity target) {
        int result = 0;
        if (target != null) {
            float eyeH = 1.62f;
            EntityPlayer player = ClientProxy.getClientPlayer();
            if (player.func_70047_e() != 0.12f) {
                eyeH = (float)(player.field_70121_D.field_72337_e - player.field_70121_D.field_72338_b + (double)player.func_70047_e());
            }
            float dx = (float)(player.field_70165_t - target.field_70165_t);
            float dz = (float)(player.field_70161_v - target.field_70161_v);
            float rayLen = MathHelper.func_76129_c((float)(dx * dx + dz * dz + eyeH * eyeH));
            rayLen -= target.field_70130_N;
            float hitHeight = (float)(player.field_70121_D.field_72338_b + (double)eyeH - target.field_70121_D.field_72338_b - (double)(rayLen *= MathHelper.func_76126_a((float)(player.field_70125_A * ((float)Math.PI / 180)))));
            result = hitHeight > 0.0f && hitHeight <= target.field_70131_O * 1.5f ? (int)(hitHeight / target.field_70131_O * 100.0f) : 0;
        }
        return result;
    }

    public static int getEntityHitHeight(Entity host, Entity target) {
        int result = 0;
        if (host != null && target != null) {
            float eyeH = host.field_70131_O * (host.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f);
            float dx = (float)(host.field_70165_t - target.field_70165_t);
            float dz = (float)(host.field_70161_v - target.field_70161_v);
            float rayLen = MathHelper.func_76129_c((float)(dx * dx + dz * dz + eyeH * eyeH));
            rayLen -= target.field_70130_N;
            float hitHeight = (float)(host.field_70121_D.field_72338_b + (double)eyeH - target.field_70121_D.field_72338_b - (double)(rayLen *= MathHelper.func_76126_a((float)(host.field_70125_A * ((float)Math.PI / 180)))));
            result = hitHeight > 0.0f && hitHeight <= target.field_70131_O * 1.5f ? (int)(hitHeight / target.field_70131_O * 100.0f) : 0;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getEntityHitSideByClientPlayer(Entity target) {
        int result = 0;
        if (target != null) {
            float angHost = ClientProxy.getClientPlayer().field_70759_as;
            float angTarget = 0.0f;
            angTarget = target instanceof EntityLivingBase ? ((EntityLivingBase)target).field_70761_aq : target.field_70177_z;
            result = (int)((angHost % 360.0f - angTarget % 360.0f) % 360.0f);
            if (result < 0) {
                result += 360;
            }
        }
        return result;
    }

    public static int getEntityHitSide(Entity host, Entity target) {
        int result = 0;
        if (host != null && target != null && (result = (int)((host.field_70177_z % 360.0f - target.field_70177_z % 360.0f) % 360.0f)) < 0) {
            result += 360;
        }
        return result;
    }

    public static int[] concIntArray(int[] a, int[] b) {
        int[] i = new int[a.length + b.length];
        System.arraycopy(a, 0, i, 0, a.length);
        System.arraycopy(b, 0, i, a.length, b.length);
        return i;
    }

    static {
        for (int i = 0; i < 2000; ++i) {
            CalcHelper.NORM_TABLE[i] = CalcHelper.calcNormalDist(0.5f - (float)i * 2.5E-4f, 0.5f, 0.2f) * 0.50132567f;
            if (!(NORM_TABLE[i] < NORM_MIN)) continue;
            CalcHelper.NORM_TABLE[i] = NORM_MIN;
        }
    }
}

