/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.tileentity;

import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.tileentity.BasicTileInventory;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class TileEntityVolCore
extends BasicTileInventory {
    private Random rand = new Random();
    public boolean isActive;
    private int remainedPower = 0;
    private static int consumeSpeed = 16;
    private static final int MAXPOWER = 9600;
    private static final int[] ALLSLOTS = new int[]{0, 1, 2, 3, 4, 5};

    public TileEntityVolCore() {
        this.slots = new ItemStack[9];
        this.isActive = false;
        this.syncTime = 0;
        if (ConfigHandler.easyMode) {
            consumeSpeed = 2;
        }
    }

    @Override
    public int[] func_94128_d(int i) {
        return ALLSLOTS;
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.shincolle:VolCore";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte sid = item.func_74771_c("Slot");
            if (sid < 0 || sid >= this.slots.length) continue;
            this.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.remainedPower = compound.func_74762_e("power");
        this.isActive = compound.func_74767_n("active");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList list = new NBTTagList();
        compound.func_74782_a("Items", (NBTBase)list);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74768_a("power", this.remainedPower);
        compound.func_74757_a("active", this.isActive);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item item;
        return itemstack != null && ((item = itemstack.func_77973_b()) == ModItems.Grudge || item == Item.func_150898_a((Block)ModBlocks.BlockGrudge));
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return true;
    }

    public boolean decrItemFuel() {
        ItemStack stack = null;
        Item item = null;
        boolean sendUpdate = false;
        int fuelx = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            stack = this.func_70301_a(i);
            if (stack == null) continue;
            item = stack.func_77973_b();
            if (item == ModItems.Grudge) {
                fuelx = ConfigHandler.volcoreGrudgeValue;
            } else if (item == Item.func_150898_a((Block)ModBlocks.BlockGrudge)) {
                fuelx = ConfigHandler.volcoreGrudgeValue * 9;
            }
            if (fuelx <= 0) continue;
            if (fuelx + this.remainedPower >= 9600) continue;
            --stack.field_77994_a;
            this.remainedPower += fuelx;
            if (stack.field_77994_a <= 0) {
                stack = stack.func_77973_b().getContainerItem(stack);
            }
            this.func_70299_a(i, stack);
            sendUpdate = true;
            break;
        }
        return sendUpdate;
    }

    public void func_145845_h() {
        ++this.syncTime;
        if (!this.field_145850_b.field_72995_K) {
            boolean checkActive = this.isActive;
            if (this.syncTime % 16 == 0) {
                if (this.remainedPower >= consumeSpeed) {
                    this.remainedPower -= consumeSpeed;
                    this.isActive = true;
                } else {
                    this.isActive = false;
                }
                if (this.syncTime % 32 == 0) {
                    this.decrItemFuel();
                    if (this.isActive) {
                        this.volcoreFunction();
                    }
                    if (this.syncTime % 256 == 0 && this.isActive) {
                        int emotes;
                        double dx = (double)this.field_145851_c + 0.5;
                        double dy = (double)this.field_145848_d + 2.5;
                        double dz = (double)this.field_145849_e + 0.5;
                        switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                            case 0: {
                                emotes = 2;
                                break;
                            }
                            case 1: {
                                emotes = 30;
                                break;
                            }
                            case 2: {
                                emotes = 10;
                                break;
                            }
                            default: {
                                emotes = 27;
                            }
                        }
                        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(dx - 4.0), (double)(dy - 2.0), (double)(dz - 4.0), (double)(dx + 4.0), (double)(dy + 6.0), (double)(dz + 4.0));
                        List slist = this.field_145850_b.func_72872_a(BasicEntityShip.class, box);
                        EntityHelper.applyEmotesAOE(slist, emotes);
                    }
                }
            }
            if (checkActive != this.isActive) {
                this.sendSyncPacket();
            }
        } else if (this.isActive && this.syncTime % 32 == 0) {
            for (int i = 0; i < 20; ++i) {
                double dx = (double)this.field_145851_c + 0.5 + (double)(this.rand.nextFloat() * 8.0f) - 4.0;
                double dy = (double)this.field_145848_d + 2.5 + (double)(this.rand.nextFloat() * 8.0f) - 4.0;
                double dz = (double)this.field_145849_e + 0.5 + (double)(this.rand.nextFloat() * 8.0f) - 4.0;
                ParticleHelper.spawnAttackParticleAt(dx, dy, dz, 0.0, 0.05, 0.0, (byte)37);
            }
        }
    }

    private void volcoreFunction() {
        block10: {
            block9: {
                if (!BlockHelper.checkBlockNearbyHasLiquid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1)) break block9;
                double dx = (double)this.field_145851_c + 0.5;
                double dy = (double)this.field_145848_d + 0.5;
                double dz = (double)this.field_145849_e + 0.5;
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(dx - 4.0), (double)(dy - 2.0), (double)(dz - 4.0), (double)(dx + 4.0), (double)(dy + 6.0), (double)(dz + 4.0));
                List slist = this.field_145850_b.func_72872_a(BasicEntityShip.class, box);
                if (slist == null) break block10;
                for (BasicEntityShip s : slist) {
                    int m;
                    if (!EntityHelper.checkShipOutOfCombat(s) || !EntityHelper.checkEntityIsInLiquid((Entity)s)) continue;
                    if (s.func_110143_aJ() < s.func_110138_aP()) {
                        s.func_70691_i(s.func_110138_aP() * 0.01f + 4.0f);
                    }
                    if ((m = s.getStateMinor(30)) >= 8100) continue;
                    s.setStateMinor(30, m + 65);
                }
                break block10;
            }
            double dx = (double)this.field_145851_c + 0.5;
            double dy = (double)this.field_145848_d + 0.5;
            double dz = (double)this.field_145849_e + 0.5;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(dx - 4.0), (double)(dy - 2.0), (double)(dz - 4.0), (double)(dx + 4.0), (double)(dy + 6.0), (double)(dz + 4.0));
            List slist = this.field_145850_b.func_72872_a(EntityLivingBase.class, box);
            if (slist != null) {
                for (EntityLivingBase ent : slist) {
                    int emotes;
                    if (ent instanceof BasicEntityShip || ent instanceof BasicEntityMount || ent instanceof BasicEntityAirplane || ent instanceof BasicEntityShipHostile) continue;
                    ent.func_70015_d(2);
                    ent.func_70097_a(DamageSource.field_76372_a, 4.0f);
                    switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                        case 0: {
                            emotes = 12;
                            break;
                        }
                        case 1: {
                            emotes = 28;
                            break;
                        }
                        case 2: {
                            emotes = 0;
                            break;
                        }
                        default: {
                            emotes = 2;
                        }
                    }
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(ent.field_71093_bK, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 48.0);
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)ent, 36, ent.field_70131_O * 0.75f, 0.0, emotes), point);
                }
            }
        }
    }

    public int getPowerRemainingScaled(int i) {
        return this.remainedPower * i / 9600;
    }

    public int getPowerRemained() {
        return this.remainedPower;
    }

    public void setPowerRemained(int par1) {
        this.remainedPower = par1;
    }

    @Override
    public int getFuelSlotMin() {
        return 0;
    }

    @Override
    public int getFuelSlotMax() {
        return 8;
    }

    public int getPowerMax() {
        return 9600;
    }
}

