/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.tileentity;

import com.lulan.shincolle.block.BlockSmallShipyard;
import com.lulan.shincolle.crafting.SmallRecipes;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.tileentity.BasicTileInventory;
import com.lulan.shincolle.tileentity.ITileLiquidFurnace;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.TileEntityHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySmallShipyard
extends BasicTileInventory
implements ITileLiquidFurnace,
IFluidHandler {
    private static final int TANKCAPA = 1000;
    private static final Fluid F_LAVA = FluidRegistry.LAVA;
    private FluidTank tank = new FluidTank(new FluidStack(F_LAVA, 0), 1000);
    private int consumedPower = 0;
    private int remainedPower = 0;
    private int goalPower = 0;
    private int buildType = 0;
    private int[] buildRecord = new int[]{0, 0, 0, 0};
    private boolean isActive;
    private static int buildSpeed = 48;
    private static final int MAXPOWER = 460800;
    private static final int[] ALLSLOTS = new int[]{0, 1, 2, 3, 4, 5};

    public TileEntitySmallShipyard() {
        this.slots = new ItemStack[6];
        this.isActive = false;
        this.syncTime = 0;
        if (ConfigHandler.easyMode) {
            buildSpeed = 480;
        }
    }

    @Override
    public int[] func_94128_d(int i) {
        return ALLSLOTS;
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "tile.shincolle:BlockSmallShipyard";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte sid = item.func_74771_c("Slot");
            if (sid < 0 || sid >= this.slots.length) continue;
            this.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.consumedPower = compound.func_74762_e("consumedPower");
        this.remainedPower = compound.func_74762_e("remainedPower");
        this.goalPower = compound.func_74762_e("goalPower");
        this.buildType = compound.func_74762_e("buildType");
        this.buildRecord = compound.func_74759_k("buildRecord");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList list = new NBTTagList();
        compound.func_74782_a("Items", (NBTBase)list);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74768_a("consumedPower", this.consumedPower);
        compound.func_74768_a("remainedPower", this.remainedPower);
        compound.func_74768_a("goalPower", this.goalPower);
        compound.func_74768_a("buildType", this.buildType);
        compound.func_74783_a("buildRecord", this.buildRecord);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            int meta = itemstack.func_77960_j();
            switch (slot) {
                case 0: {
                    return item == ModItems.Grudge;
                }
                case 1: {
                    return item == ModItems.AbyssMetal && meta == 0;
                }
                case 2: {
                    return item == ModItems.Ammo && meta == 0;
                }
                case 3: {
                    return item == ModItems.AbyssMetal && meta == 1;
                }
                case 4: {
                    return TileEntityHelper.getItemFuelValue(itemstack) > 0 || item == ModItems.InstantConMat;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot == 5 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public void buildComplete() {
        if (this.buildType == 4 || this.buildType == 3) {
            for (int i = 0; i < 4; ++i) {
                if (this.slots[i] == null || this.slots[i].field_77994_a < this.buildRecord[i]) {
                    return;
                }
                this.slots[i].field_77994_a -= this.buildRecord[i];
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
            switch (this.buildType) {
                default: {
                    this.slots[5] = SmallRecipes.getBuildResultShip(this.buildRecord);
                    break;
                }
                case 4: {
                    this.slots[5] = SmallRecipes.getBuildResultEquip(this.buildRecord);
                    break;
                }
            }
        } else {
            int[] matAmount = new int[4];
            matAmount = SmallRecipes.getMaterialAmount(this.slots);
            this.slots[0] = null;
            this.slots[1] = null;
            this.slots[2] = null;
            this.slots[3] = null;
            switch (this.buildType) {
                default: {
                    this.slots[5] = SmallRecipes.getBuildResultShip(matAmount);
                    break;
                }
                case 2: 
                case 4: {
                    this.slots[5] = SmallRecipes.getBuildResultEquip(matAmount);
                }
            }
        }
    }

    public boolean isBuilding() {
        return this.hasRemainedPower() && this.canBuild();
    }

    public boolean hasRemainedPower() {
        return this.remainedPower > buildSpeed;
    }

    public boolean canBuild() {
        if (this.buildType == 4 || this.buildType == 3) {
            if (SmallRecipes.canRecipeBuild(this.buildRecord)) {
                for (int i = 0; i < 4; ++i) {
                    if (this.slots[i] != null && this.slots[i].field_77994_a >= this.buildRecord[i]) continue;
                    return false;
                }
                return this.goalPower > 0 && this.slots[5] == null;
            }
        } else {
            return this.goalPower > 0 && this.slots[5] == null;
        }
        return false;
    }

    public void getGoalPower() {
        if (this.buildType == 4 || this.buildType == 3) {
            this.goalPower = SmallRecipes.canRecipeBuild(this.buildRecord) ? SmallRecipes.calcGoalPower(this.buildRecord) : 0;
        } else {
            int[] itemAmount = new int[4];
            itemAmount = SmallRecipes.getMaterialAmount(this.slots);
            this.goalPower = SmallRecipes.calcGoalPower(itemAmount);
        }
    }

    public void func_145845_h() {
        boolean sendUpdate = false;
        if (this.buildRecord == null || this.buildRecord.length < 1) {
            this.buildRecord = new int[]{0, 0, 0, 0};
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.buildType != 0) {
                this.getGoalPower();
            } else {
                this.goalPower = 0;
            }
            if (TileEntityHelper.decrItemFuel(this)) {
                sendUpdate = true;
            }
            TileEntityHelper.decrLiquidFuel(this);
            if (this.isBuilding()) {
                if (this.slots[4] != null && this.slots[4].func_77973_b() == ModItems.InstantConMat) {
                    --this.slots[4].field_77994_a;
                    this.consumedPower += 115200;
                    if (this.slots[4].field_77994_a == 0) {
                        this.slots[4] = null;
                    }
                    sendUpdate = true;
                }
                this.remainedPower -= buildSpeed;
                this.consumedPower += buildSpeed;
                if (this.consumedPower >= this.goalPower) {
                    this.buildComplete();
                    this.consumedPower = 0;
                    this.goalPower = 0;
                    switch (this.buildType) {
                        default: {
                            this.buildType = 0;
                        }
                        case 3: 
                        case 4: 
                    }
                    sendUpdate = true;
                }
            }
            if (!this.canBuild()) {
                this.consumedPower = 0;
            }
            if (this.isActive != this.isBuilding()) {
                this.isActive = this.isBuilding();
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            BlockSmallShipyard.updateBlockState(this.isBuilding(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public int getPowerRemainingScaled(int i) {
        return this.remainedPower * i / 460800;
    }

    public String getBuildTimeString() {
        int timeSec = (this.goalPower - this.consumedPower) / buildSpeed / 20;
        return CalcHelper.getTimeFormated(timeSec);
    }

    @Override
    public int getPowerConsumed() {
        return this.consumedPower;
    }

    @Override
    public int getPowerRemained() {
        return this.remainedPower;
    }

    @Override
    public int getPowerGoal() {
        return this.goalPower;
    }

    public int getBuildType() {
        return this.buildType;
    }

    @Override
    public void setPowerConsumed(int par1) {
        this.consumedPower = par1;
    }

    @Override
    public void setPowerRemained(int par1) {
        this.remainedPower = par1;
    }

    @Override
    public void setPowerGoal(int par1) {
        this.goalPower = par1;
    }

    public void setBuildType(int par1) {
        this.buildType = par1;
    }

    public void setBuildRecord(int[] par1) {
        for (int i = 0; i < 4; ++i) {
            this.buildRecord[i] = par1[i];
        }
    }

    @Override
    public int getFuelSlotMin() {
        return 4;
    }

    @Override
    public int getFuelSlotMax() {
        return 4;
    }

    @Override
    public int getPowerMax() {
        return 460800;
    }

    @Override
    public void setPowerMax(int par1) {
    }

    public int fill(ForgeDirection from, FluidStack fluid, boolean doFill) {
        if (TileEntityHelper.checkLiquidIsLava(fluid)) {
            return this.tank.fill(fluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack fluid, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return TileEntityHelper.checkLiquidIsLava(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getFluidFuelAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public FluidStack drainFluidFuel(int amount) {
        return this.tank.drain(amount, true);
    }
}

