/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.proxy;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.ExtendPlayerProps;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CGUIPackets;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.server.ShinWorldData;
import com.lulan.shincolle.team.TeamData;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;

public class ServerProxy
extends CommonProxy {
    private static Map<String, NBTTagCompound> extendedPlayerData = null;
    private static Map<Integer, List<String>> customTagetClassList = null;
    private static List<String> unattackableTargetClassList = null;
    private static Map<Integer, TeamData> mapTeamID = null;
    private static Map<Integer, int[]> mapPlayerID = null;
    private static Map<Integer, int[]> mapShipID = null;
    private static int nextPlayerID = -1;
    private static int nextShipID = -1;
    public static World world0;
    public static MapStorage serverFile;
    public static ShinWorldData serverData;
    public static boolean initServerFile;
    public static boolean savedServerFile;
    public static final String CUSTOM_TARGET_CLASS = "CustomTargetClass";
    public static final String UNATK_TARGET_CLASS = "UnatkTargetClass";
    public static int serverTicks;
    public static int updateRadarTicks;

    /*
     * Unable to fully structure code
     */
    public static void initServerProxy(World world) {
        LogHelper.info("DEBUG : init server proxy");
        ServerProxy.serverFile = null;
        ServerProxy.serverData = null;
        ServerProxy.extendedPlayerData = null;
        ServerProxy.mapPlayerID = null;
        ServerProxy.mapShipID = null;
        ServerProxy.extendedPlayerData = new HashMap<String, NBTTagCompound>();
        ServerProxy.customTagetClassList = new HashMap<Integer, List<String>>();
        ServerProxy.unattackableTargetClassList = new ArrayList<String>();
        ServerProxy.mapPlayerID = new HashMap<Integer, int[]>();
        ServerProxy.mapShipID = new HashMap<Integer, int[]>();
        ServerProxy.mapTeamID = new HashMap<Integer, TeamData>();
        ServerProxy.nextPlayerID = -1;
        ServerProxy.nextShipID = -1;
        ServerProxy.world0 = world;
        ServerProxy.serverFile = world.field_72988_C;
        ServerProxy.serverData = (ShinWorldData)ServerProxy.serverFile.func_75742_a(ShinWorldData.class, "shincolle");
        if (ServerProxy.serverData == null) ** GOTO lbl-1000
        if (ShinWorldData.nbtData != null) {
            LogHelper.info("DEBUG : init server proxy: get data from .dat file");
            ServerProxy.setNextPlayerID(ShinWorldData.nbtData.func_74762_e("nextPlayerID"));
            ServerProxy.setNextShipID(ShinWorldData.nbtData.func_74762_e("nextShipID"));
            unatktag = ShinWorldData.nbtData.func_150295_c("UnatkTargetClass", 8);
            LogHelper.info("DEBUG : init server proxy: get unattackable target list: count: " + unatktag.func_74745_c());
            unatklist = new ArrayList<String>();
            for (j = 0; j < unatktag.func_74745_c(); ++j) {
                str = unatktag.func_150307_f(j);
                if (str == null || str.length() <= 1) continue;
                unatklist.add(str);
            }
            ServerProxy.setUnattackableTargetClassList(unatklist);
            list = ShinWorldData.nbtData.func_150295_c("playerData", 10);
            LogHelper.info("DEBUG : init server proxy: get player data count: " + list.func_74745_c());
            for (i = 0; i < list.func_74745_c(); ++i) {
                getlist = list.func_150305_b(i);
                uid = getlist.func_74762_e("pUID");
                strListTag = getlist.func_150295_c("CustomTargetClass", 8);
                strList = new ArrayList<String>();
                for (j = 0; j < strListTag.func_74745_c(); ++j) {
                    str = strListTag.func_150307_f(j);
                    if (str == null || str.length() <= 1) continue;
                    strList.add(str);
                }
                LogHelper.info("DEBUG : init server proxy: get player data: UID " + uid + " target list size: " + strList.size());
                ServerProxy.setPlayerTargetClassList(uid, strList);
            }
            list2 = ShinWorldData.nbtData.func_150295_c("teamData", 10);
            LogHelper.info("DEBUG : init server proxy: get team data count: " + list2.func_74745_c());
            for (i = 0; i < list2.func_74745_c(); ++i) {
                getlist = list2.func_150305_b(i);
                tUID = getlist.func_74762_e("tUID");
                tName = getlist.func_74779_i("tName");
                tLName = getlist.func_74779_i("tLName");
                tBan = getlist.func_74759_k("tBan");
                tList1 = CalcHelper.intArrayToList(tBan);
                tAlly = getlist.func_74759_k("tAlly");
                tList2 = CalcHelper.intArrayToList(tAlly);
                tData = new TeamData();
                tData.setTeamID(tUID);
                tData.setTeamName(tName);
                tData.setTeamLeaderName(tLName);
                tData.setTeamBannedList(tList1);
                tData.setTeamAllyList(tList2);
                LogHelper.info("DEBUG : init server proxy: get team data: UID " + tUID + " NAME " + tName);
                ServerProxy.setTeamData(tData);
            }
            ServerProxy.initServerFile = true;
        } else if (ServerProxy.serverData == null) {
            LogHelper.info("DEBUG : init server proxy: create .dat file");
            ServerProxy.serverData = new ShinWorldData();
            ServerProxy.serverFile.func_75745_a("shincolle", (WorldSavedData)ServerProxy.serverData);
            ServerProxy.initServerFile = true;
        }
    }

    public static void saveServerDataToFile() {
        if (serverData != null) {
            serverData.func_76185_a();
        }
        if (serverFile != null) {
            serverFile.func_75744_a();
        }
        savedServerFile = true;
    }

    public static MinecraftServer getServer() {
        return MinecraftServer.func_71276_C();
    }

    public static WorldServer[] getServerWorld() {
        return MinecraftServer.func_71276_C().field_71305_c;
    }

    public static WorldServer getServerWorldByWorldID(int worldID) {
        WorldServer[] worlds;
        for (WorldServer getw : worlds = ServerProxy.getServerWorld()) {
            if (getw.field_73011_w.field_76574_g != worldID) continue;
            return getw;
        }
        return null;
    }

    @Override
    public void registerKeyBindings() {
    }

    @Override
    public void registerRender() {
    }

    public static void setPlayerData(String uuid, NBTTagCompound nbt) {
        extendedPlayerData.put(uuid, nbt);
        serverData.func_76185_a();
    }

    public static NBTTagCompound getPlayerData(String name) {
        return extendedPlayerData.get(name);
    }

    public static boolean setPlayerTargetClassList(int pid, String str) {
        boolean result = true;
        if (str != null && str.length() > 1 && pid > 0) {
            List<String> tarList = ServerProxy.getPlayerTargetClassList(pid);
            if (tarList != null) {
                for (String s : tarList) {
                    if (!str.equals(s)) continue;
                    tarList.remove(s);
                    ServerProxy.setPlayerTargetClassList(pid, tarList);
                    return false;
                }
                tarList.add(str);
                ServerProxy.setPlayerTargetClassList(pid, tarList);
                serverData.func_76185_a();
            } else {
                tarList = new ArrayList<String>();
                tarList.add(str);
                ServerProxy.setPlayerTargetClassList(pid, tarList);
                serverData.func_76185_a();
            }
        }
        return result;
    }

    public static boolean addUnattackableTargetClassList(String target) {
        boolean result = false;
        if (target != null) {
            if (unattackableTargetClassList.contains(target)) {
                unattackableTargetClassList.remove(target);
            } else {
                unattackableTargetClassList.add(target);
                result = true;
            }
            serverData.func_76185_a();
        }
        return result;
    }

    public static void setUnattackableTargetClassList(List<String> list) {
        if (list != null) {
            unattackableTargetClassList = list;
        }
    }

    public static List<String> getUnattackableTargetClassList() {
        return unattackableTargetClassList;
    }

    public static void setPlayerTargetClassList(int pid, List<String> list) {
        if (pid > 0) {
            customTagetClassList.put(pid, list);
            serverData.func_76185_a();
        }
    }

    public static List<String> getPlayerTargetClassList(int pid) {
        if (pid > 0) {
            return customTagetClassList.get(pid);
        }
        return null;
    }

    public static int[] getPlayerWorldData(int par1) {
        if (par1 != -1) {
            return mapPlayerID.get(par1);
        }
        return null;
    }

    public static void setPlayerWorldData(int pid, int[] pdata) {
        if (pid > 0 && pdata != null) {
            mapPlayerID.put(pid, pdata);
        }
    }

    public static int[] getShipWorldData(int par1) {
        if (par1 != -1) {
            return mapShipID.get(par1);
        }
        return null;
    }

    public static void setShipWorldData(int pid, int[] pdata) {
        if (pid > 0 && pdata != null) {
            mapShipID.put(pid, pdata);
        }
    }

    public static TeamData getTeamData(int tid) {
        if (tid > 0) {
            return mapTeamID.get(tid);
        }
        return null;
    }

    public static void setTeamData(TeamData data) {
        if (data != null && data.getTeamID() > 0) {
            mapTeamID.put(data.getTeamID(), data);
            serverData.func_76185_a();
        }
    }

    public static void removeTeamData(int tid) {
        if (tid > 0 && mapTeamID.containsKey(tid)) {
            mapTeamID.remove(tid);
            serverData.func_76185_a();
        }
    }

    private static void cleanTeamData(TeamData tdata) {
        if (tdata != null) {
            try {
                String owner1 = tdata.getTeamLeaderName();
                String owner2 = null;
                for (Map.Entry<Integer, TeamData> entry : mapTeamID.entrySet()) {
                    int pid = entry.getKey();
                    TeamData getdata = entry.getValue();
                    owner2 = getdata.getTeamLeaderName();
                    if (!owner1.equals(owner2)) continue;
                    mapTeamID.remove(pid);
                    serverData.func_76185_a();
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static int getNextPlayerID() {
        return nextPlayerID;
    }

    public static void setNextPlayerID(int par1) {
        if (serverData != null) {
            LogHelper.info("DEBUG : server proxy: set next player id " + par1);
            nextPlayerID = par1;
            serverData.func_76185_a();
        }
    }

    public static int getNextShipID() {
        return nextShipID;
    }

    public static void setNextShipID(int par1) {
        if (serverData != null) {
            LogHelper.info("DEBUG : server proxy: set next ship id " + par1);
            nextShipID = par1;
            serverData.func_76185_a();
        }
    }

    public static Map<Integer, List<String>> getAllPlayerTargetClassList() {
        return customTagetClassList;
    }

    public static Map<Integer, int[]> getAllPlayerWorldData() {
        return mapPlayerID;
    }

    public static Map<Integer, int[]> getAllShipWorldData() {
        return mapShipID;
    }

    public static Map<Integer, TeamData> getAllTeamWorldData() {
        return mapTeamID;
    }

    public static void updatePlayerID(EntityPlayer player) {
        LogHelper.info("DEBUG : update player: " + player.getDisplayName() + " " + player.func_110124_au() + " " + player.func_145782_y());
        ExtendPlayerProps extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps");
        if (extProps != null) {
            int pid = extProps.getPlayerUID();
            int[] pdata = new int[]{player.func_145782_y()};
            if (pid > 0) {
                LogHelper.info("DEBUG : update player: update player id " + pid + " eid: " + pdata[0]);
                ServerProxy.setPlayerWorldData(pid, pdata);
                if (ServerProxy.getNextPlayerID() <= 0 || ServerProxy.getNextPlayerID() <= pid) {
                    LogHelper.info("DEBUG : update player: find next player UID fail, shift id 100000");
                    int newNextID = pid + 100000;
                    ServerProxy.setNextPlayerID(newNextID);
                }
            } else {
                boolean createNew = true;
                NBTTagCompound nbt = ServerProxy.getPlayerData(player.func_110124_au().toString());
                if (nbt != null) {
                    extProps.loadNBTData(nbt);
                    pid = extProps.getPlayerUID();
                    if (pid > 0) {
                        ServerProxy.setPlayerWorldData(pid, pdata);
                        LogHelper.info("DEBUG : update player: update player id " + pid + " eid: " + pdata[0]);
                        createNew = false;
                    }
                }
                if (createNew) {
                    pid = ServerProxy.getNextPlayerID();
                    if (pid <= 0) {
                        pid = 100;
                    }
                    LogHelper.info("DEBUG : update player: create pid: " + pid + " eid: " + pdata[0]);
                    extProps.setPlayerUID(pid);
                    ServerProxy.setPlayerWorldData(pid, pdata);
                    ServerProxy.setNextPlayerID(++pid);
                }
            }
        } else {
            LogHelper.info("DEBUG : update player: fail: player extProps = null");
        }
    }

    public static void updateShipID(BasicEntityShip ship) {
        LogHelper.info("DEBUG : update ship: " + ship);
        int sid = ship.getShipUID();
        int[] sdata = new int[]{ship.func_145782_y(), ship.field_70170_p.field_73011_w.field_76574_g};
        if (sid > 0) {
            LogHelper.info("DEBUG : update ship: update ship id " + sid + " eid: " + sdata[0] + " world: " + sdata[1]);
            ServerProxy.setShipWorldData(sid, sdata);
            if (ServerProxy.getNextShipID() <= 0 || ServerProxy.getNextShipID() <= sid) {
                LogHelper.info("DEBUG : update ship: find next ship id error");
                int newNextID = sid + 100000;
                ServerProxy.setNextShipID(newNextID);
            }
        } else {
            sid = ServerProxy.getNextShipID();
            if (sid <= 0) {
                sid = 100;
            }
            LogHelper.info("DEBUG : update ship: create sid: " + sid + " eid: " + sdata[0] + " world: " + sdata[1]);
            ship.setShipUID(sid);
            ServerProxy.setShipWorldData(sid, sdata);
            ServerProxy.setNextShipID(++sid);
            ship.setStateFlag(12, true);
        }
    }

    public static void updateShipOwnerID(BasicEntityShip ship) {
        EntityLivingBase owner = ship.func_70902_q();
        if (owner instanceof EntityPlayer) {
            ExtendPlayerProps extProps = (ExtendPlayerProps)owner.getExtendedProperties("TeitokuExtProps");
            if (extProps != null) {
                int pid = extProps.getPlayerUID();
                LogHelper.info("DEBUG : update ship: set owner id: " + pid + " on " + ship);
                ship.setPlayerUID(pid);
            }
        } else {
            LogHelper.info("DEBUG : update ship: get owner id: fail, owner offline or no owner data: " + ship);
        }
    }

    public static void updateServerTick() {
        if (++serverTicks > 23999) {
            serverTicks = 0;
        }
        if (serverTicks > 100) {
            if (serverTicks % 64 == 0) {
                // empty if block
            }
            if (serverTicks % updateRadarTicks == 0) {
                WorldServer[] allWorld;
                boolean needUpdate = false;
                for (WorldServer worldServer : allWorld = ServerProxy.getServerWorld()) {
                    if (worldServer.field_73010_i.size() <= 0) continue;
                    needUpdate = true;
                    break;
                }
                if (needUpdate) {
                    List value;
                    int pid;
                    HashMap<Integer, List> allShipMapByPUID = new HashMap<Integer, List>();
                    HashMap<Integer, EntityPlayer> allPlayerMapByPUID = new HashMap<Integer, EntityPlayer>();
                    for (Map.Entry<Integer, int[]> entry : mapPlayerID.entrySet()) {
                        pid = entry.getKey();
                        value = new ArrayList();
                        EntityPlayer pe = EntityHelper.getEntityPlayerByUID(pid);
                        allShipMapByPUID.put(pid, value);
                        if (pe == null) continue;
                        allPlayerMapByPUID.put(pid, pe);
                    }
                    for (Map.Entry<Integer, int[]> entry : mapShipID.entrySet()) {
                        List shipList;
                        int sid = entry.getKey();
                        int[] sdata = entry.getValue();
                        int pid2 = -1;
                        BasicEntityShip ship = null;
                        Entity getEnt = EntityHelper.getEntityByID(sdata[0], sdata[1], false);
                        if (getEnt instanceof BasicEntityShip) {
                            ship = (BasicEntityShip)getEnt;
                            pid2 = ship.getPlayerUID();
                        }
                        EntityPlayer pe = (EntityPlayer)allPlayerMapByPUID.get(pid2);
                        if (ship == null || pe == null || ship.field_71093_bK != pe.field_71093_bK || (shipList = (List)allShipMapByPUID.get(pid2)) == null) continue;
                        shipList.add(sdata[0]);
                        allShipMapByPUID.put(pid2, shipList);
                    }
                    for (Map.Entry<Integer, Object> entry : allShipMapByPUID.entrySet()) {
                        pid = entry.getKey();
                        value = (List)entry.getValue();
                        EntityPlayerMP player = (EntityPlayerMP)allPlayerMapByPUID.get(pid);
                        if (player == null) continue;
                        CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(6, value), player);
                    }
                }
            }
        }
    }

    public static void teamRename(int tid, String tname) {
        if (tid > 0 && tname != null && tname.length() > 1 && ServerProxy.getAllTeamWorldData().containsKey(tid)) {
            TeamData tdata = ServerProxy.getTeamData(tid);
            tdata.setTeamName(tname);
        }
    }

    public static void teamCreate(EntityPlayer player, String tname) {
        int pUID;
        ExtendPlayerProps extProps;
        if (player != null && (extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps")) != null && (pUID = extProps.getPlayerUID()) > 0 && tname != null && tname.length() > 1 && ServerProxy.getAllTeamWorldData() != null) {
            TeamData tdata = new TeamData();
            tdata.setTeamID(pUID);
            tdata.setTeamName(tname);
            tdata.setTeamLeaderName(player.getDisplayName());
            LogHelper.info("DEBUG : server proxy: create team: " + pUID + " " + tname);
            ServerProxy.cleanTeamData(tdata);
            ServerProxy.setTeamData(tdata);
            extProps.setPlayerTeamID(pUID);
            extProps.setPlayerTeamCooldown(ConfigHandler.teamCooldown);
            ServerProxy.updatePlayerID(player);
        }
    }

    public static void teamDisband(EntityPlayer player) {
        ExtendPlayerProps extProps;
        if (player != null && (extProps = (ExtendPlayerProps)player.getExtendedProperties("TeitokuExtProps")) != null) {
            int pUID = extProps.getPlayerUID();
            if (ServerProxy.getAllTeamWorldData() != null && ServerProxy.getAllTeamWorldData().containsKey(pUID)) {
                LogHelper.info("DEBUG : server proxy: remove team: " + pUID);
                ServerProxy.removeTeamData(pUID);
                extProps.setPlayerTeamID(0);
                extProps.setPlayerTeamCooldown(ConfigHandler.teamCooldown);
                ServerProxy.updatePlayerID(player);
            }
        }
    }

    public static void teamAddAlly(int tid1, int tid2) {
        if (tid1 > 0 && tid2 > 0 && tid1 != tid2 && ServerProxy.getAllTeamWorldData().containsKey(tid1) && ServerProxy.getAllTeamWorldData().containsKey(tid2)) {
            LogHelper.info("DEBUG : server proxy: add ally: " + tid1 + " add " + tid2);
            TeamData tdata = ServerProxy.getTeamData(tid1);
            tdata.addTeamAlly(tid2);
        }
    }

    public static void teamRemoveAlly(int tid1, int tid2) {
        if (tid1 > 0 && tid2 > 0 && ServerProxy.getAllTeamWorldData().containsKey(tid1) && ServerProxy.getAllTeamWorldData().containsKey(tid2)) {
            LogHelper.info("DEBUG : server proxy: remove ally: " + tid1 + " and " + tid2);
            TeamData tdata1 = ServerProxy.getTeamData(tid1);
            tdata1.removeTeamAlly(tid2);
            TeamData tdata2 = ServerProxy.getTeamData(tid2);
            tdata2.removeTeamAlly(tid1);
        }
    }

    public static void teamAddBan(int tid1, int tid2) {
        if (tid1 > 0 && tid2 > 0 && tid1 != tid2 && ServerProxy.getAllTeamWorldData().containsKey(tid1) && ServerProxy.getAllTeamWorldData().containsKey(tid2)) {
            LogHelper.info("DEBUG : server proxy: ban team: " + tid1 + " ban " + tid2);
            TeamData tdata1 = ServerProxy.getTeamData(tid1);
            tdata1.addTeamBanned(tid2);
            TeamData tdata2 = ServerProxy.getTeamData(tid2);
            tdata2.addTeamBanned(tid1);
        }
    }

    public static void teamRemoveBan(int tid1, int tid2) {
        if (tid1 > 0 && tid2 > 0 && ServerProxy.getAllTeamWorldData().containsKey(tid1) && ServerProxy.getAllTeamWorldData().containsKey(tid2)) {
            LogHelper.info("DEBUG : server proxy: unban team: " + tid1 + " unban " + tid2);
            TeamData tdata1 = ServerProxy.getTeamData(tid1);
            tdata1.removeTeamBanned(tid2);
        }
    }

    static {
        serverFile = null;
        serverData = null;
        initServerFile = false;
        savedServerFile = false;
        serverTicks = 0;
        updateRadarTicks = ConfigHandler.radarUpdate;
    }
}

