/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.network;

import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;

public class S2CSpawnParticle
implements IMessage {
    private Entity entity;
    private Entity entity2;
    private int entityID;
    private int entityID2;
    private int type;
    private byte particleType;
    private boolean isShip;
    private float posX;
    private float posY;
    private float posZ;
    private float lookX;
    private float lookY;
    private float lookZ;

    public S2CSpawnParticle() {
    }

    public S2CSpawnParticle(Entity entity, int type, boolean isShip) {
        this.entity = entity;
        this.type = 0;
        this.isShip = isShip;
        this.particleType = (byte)type;
    }

    public S2CSpawnParticle(Entity entity, int type, double posX, double posY, double posZ, double lookX, double lookY, double lookZ, boolean isShip) {
        this.entity = entity;
        this.type = 1;
        this.isShip = isShip;
        this.particleType = (byte)type;
        this.posX = (float)posX;
        this.posY = (float)posY;
        this.posZ = (float)posZ;
        this.lookX = (float)lookX;
        this.lookY = (float)lookY;
        this.lookZ = (float)lookZ;
    }

    public S2CSpawnParticle(int type, double posX, double posY, double posZ, double lookX, double lookY, double lookZ) {
        this.type = 2;
        this.particleType = (byte)type;
        this.posX = (float)posX;
        this.posY = (float)posY;
        this.posZ = (float)posZ;
        this.lookX = (float)lookX;
        this.lookY = (float)lookY;
        this.lookZ = (float)lookZ;
    }

    public S2CSpawnParticle(Entity host, Entity target, double par1, double par2, double par3, int type, boolean isShip) {
        this.type = 3;
        this.isShip = isShip;
        this.particleType = (byte)type;
        this.entityID = host.func_145782_y();
        this.entityID2 = target.func_145782_y();
        this.posX = (float)par1;
        this.posY = (float)par2;
        this.posZ = (float)par3;
    }

    public S2CSpawnParticle(Entity entity, int type, double par1, double par2, double par3) {
        this.entity = entity;
        this.type = 4;
        this.particleType = (byte)type;
        this.posX = (float)par1;
        this.posY = (float)par2;
        this.posZ = (float)par3;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        switch (this.type) {
            case 0: {
                this.entityID = buf.readInt();
                this.entity = EntityHelper.getEntityByID(this.entityID, 0, true);
                this.particleType = buf.readByte();
                this.isShip = buf.readBoolean();
                ParticleHelper.spawnAttackParticle(this.entity, this.particleType, this.isShip);
                break;
            }
            case 1: {
                this.entityID = buf.readInt();
                this.entity = EntityHelper.getEntityByID(this.entityID, 0, true);
                this.particleType = buf.readByte();
                this.isShip = buf.readBoolean();
                this.posX = buf.readFloat();
                this.posY = buf.readFloat();
                this.posZ = buf.readFloat();
                this.lookX = buf.readFloat();
                this.lookY = buf.readFloat();
                this.lookZ = buf.readFloat();
                ParticleHelper.spawnAttackParticleCustomVector(this.entity, this.posX, this.posY, this.posZ, this.lookX, this.lookY, this.lookZ, this.particleType, this.isShip);
                break;
            }
            case 2: {
                this.particleType = buf.readByte();
                this.posX = buf.readFloat();
                this.posY = buf.readFloat();
                this.posZ = buf.readFloat();
                this.lookX = buf.readFloat();
                this.lookY = buf.readFloat();
                this.lookZ = buf.readFloat();
                ParticleHelper.spawnAttackParticleAt(this.posX, this.posY, this.posZ, this.lookX, this.lookY, this.lookZ, this.particleType);
                break;
            }
            case 3: {
                this.particleType = buf.readByte();
                this.isShip = buf.readBoolean();
                this.entityID = buf.readInt();
                this.entityID2 = buf.readInt();
                this.posX = buf.readFloat();
                this.posY = buf.readFloat();
                this.posZ = buf.readFloat();
                this.entity = EntityHelper.getEntityByID(this.entityID, 0, true);
                this.entity2 = EntityHelper.getEntityByID(this.entityID2, 0, true);
                ParticleHelper.spawnAttackParticleAtEntity(this.entity, this.entity2, this.posX, this.posY, this.posZ, this.particleType, this.isShip);
                break;
            }
            case 4: {
                this.entityID = buf.readInt();
                this.entity = EntityHelper.getEntityByID(this.entityID, 0, true);
                this.particleType = buf.readByte();
                this.posX = buf.readFloat();
                this.posY = buf.readFloat();
                this.posZ = buf.readFloat();
                ParticleHelper.spawnAttackParticleAtEntity(this.entity, this.posX, this.posY, this.posZ, this.particleType);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        switch (this.type) {
            case 0: {
                if (this.entity == null) {
                    return;
                }
                buf.writeByte(0);
                buf.writeInt(this.entity.func_145782_y());
                buf.writeByte((int)this.particleType);
                buf.writeBoolean(this.isShip);
                break;
            }
            case 1: {
                if (this.entity == null) {
                    return;
                }
                buf.writeByte(1);
                buf.writeInt(this.entity.func_145782_y());
                buf.writeByte((int)this.particleType);
                buf.writeBoolean(this.isShip);
                buf.writeFloat(this.posX);
                buf.writeFloat(this.posY);
                buf.writeFloat(this.posZ);
                buf.writeFloat(this.lookX);
                buf.writeFloat(this.lookY);
                buf.writeFloat(this.lookZ);
                break;
            }
            case 2: {
                buf.writeByte(2);
                buf.writeByte((int)this.particleType);
                buf.writeFloat(this.posX);
                buf.writeFloat(this.posY);
                buf.writeFloat(this.posZ);
                buf.writeFloat(this.lookX);
                buf.writeFloat(this.lookY);
                buf.writeFloat(this.lookZ);
                break;
            }
            case 3: {
                buf.writeByte(3);
                buf.writeByte((int)this.particleType);
                buf.writeBoolean(this.isShip);
                buf.writeInt(this.entityID);
                buf.writeInt(this.entityID2);
                buf.writeFloat(this.posX);
                buf.writeFloat(this.posY);
                buf.writeFloat(this.posZ);
                break;
            }
            case 4: {
                if (this.entity == null) {
                    return;
                }
                buf.writeByte(4);
                buf.writeInt(this.entity.func_145782_y());
                buf.writeByte((int)this.particleType);
                buf.writeFloat(this.posX);
                buf.writeFloat(this.posY);
                buf.writeFloat(this.posZ);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<S2CSpawnParticle, IMessage> {
        public IMessage onMessage(S2CSpawnParticle message, MessageContext ctx) {
            return null;
        }
    }
}

