/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.network;

import com.lulan.shincolle.ShinColle;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.entity.mounts.EntityMountSeat;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class C2SInputPackets
implements IMessage {
    private World world;
    private EntityPlayer player;
    private int type;
    private int worldID;
    private int entityID;
    private int value;
    private int[] value3;

    public C2SInputPackets() {
    }

    public C2SInputPackets(int type, int ... parms) {
        this.type = type;
        if (parms != null && parms.length > 0) {
            this.value3 = (int[])parms.clone();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                try {
                    this.value = buf.readInt();
                    if (this.value <= 0) break;
                    this.value3 = new int[this.value];
                    for (int i = 0; i < this.value; ++i) {
                        this.value3[i] = buf.readInt();
                    }
                    break;
                }
                catch (Exception e) {
                    LogHelper.info("DEBUG : C2S input packet: change owner fail: " + e);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                buf.writeByte((int)((byte)this.type));
                if (this.value3 != null) {
                    buf.writeInt(this.value3.length);
                    for (int geti : this.value3) {
                        buf.writeInt(geti);
                    }
                    break;
                }
                buf.writeInt(0);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<C2SInputPackets, IMessage> {
        public IMessage onMessage(C2SInputPackets message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            try {
                switch (message.type) {
                    case 0: {
                        BasicEntityShip ship;
                        if (!player.func_70115_ae() || !(player.field_70154_o instanceof EntityMountSeat)) break;
                        BasicEntityMount mount = ((EntityMountSeat)player.field_70154_o).host;
                        if (mount != null && (ship = (BasicEntityShip)mount.getHostEntity()) != null && EntityHelper.checkSameOwner((Entity)player, ship.getHostEntity())) {
                            mount.keyPressed = message.value3[0];
                        }
                        break;
                    }
                    case 1: {
                        BasicEntityShip ship;
                        if (!player.func_70115_ae() || !(player.field_70154_o instanceof EntityMountSeat)) break;
                        BasicEntityMount mount = ((EntityMountSeat)player.field_70154_o).host;
                        if (mount != null && (ship = (BasicEntityShip)mount.getHostEntity()) != null && EntityHelper.checkSameOwner((Entity)player, ship.getHostEntity()) && mount.getHostEntity() != null) {
                            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ShinColle.instance, (int)0, (World)player.field_70170_p, (int)mount.getHostEntity().func_145782_y(), (int)0, (int)0);
                        }
                        break;
                    }
                    case 2: {
                        player.field_71071_by.field_70461_c = message.value3[0];
                        break;
                    }
                    case 3: {
                        EntityPlayer owner = EntityHelper.getEntityPlayerByID(message.value3[0], message.value3[2], false);
                        Entity ent = EntityHelper.getEntityByID(message.value3[1], message.value3[2], false);
                        if (owner != null && ent instanceof BasicEntityShip) {
                            EntityHelper.setPetPlayerUUID(owner.func_110124_au().toString(), (EntityTameable)((BasicEntityShip)ent));
                            EntityHelper.setPetPlayerUID(owner, (IShipOwner)((BasicEntityShip)ent));
                            LogHelper.info("DEBUG : C2S input packet: command: change owner " + owner + " " + ent);
                            ((BasicEntityShip)ent).sendSyncPacketAllValue();
                        }
                        break;
                    }
                    case 4: {
                        Entity ent = EntityHelper.getEntityByID(message.value3[0], message.value3[1], false);
                        if (ent instanceof BasicEntityShip) {
                            if (message.value3.length == 9) {
                                ((BasicEntityShip)ent).setBonusPoint(0, (byte)message.value3[3]);
                                ((BasicEntityShip)ent).setBonusPoint(1, (byte)message.value3[4]);
                                ((BasicEntityShip)ent).setBonusPoint(2, (byte)message.value3[5]);
                                ((BasicEntityShip)ent).setBonusPoint(3, (byte)message.value3[6]);
                                ((BasicEntityShip)ent).setBonusPoint(4, (byte)message.value3[7]);
                                ((BasicEntityShip)ent).setBonusPoint(5, (byte)message.value3[8]);
                                ((BasicEntityShip)ent).setShipLevel(message.value3[2], true);
                                break;
                            }
                            if (message.value3.length == 3) {
                                ((BasicEntityShip)ent).setShipLevel(message.value3[2], true);
                            }
                        }
                        break;
                    }
                    case 5: {
                        Entity ent = EntityHelper.getEntityByID(message.value3[0], message.value3[1], false);
                        if (!(ent instanceof BasicEntityShip)) break;
                        ((BasicEntityShip)ent).sendSyncPacketEmotion();
                    }
                }
            }
            catch (Exception e) {
                LogHelper.info("DEBUG : C2S input packet: handler: " + e);
            }
            return null;
        }
    }

    public static final class PID {
        public static final byte MountMove = 0;
        public static final byte MountGUI = 1;
        public static final byte SyncHandheld = 2;
        public static final byte CmdChOwner = 3;
        public static final byte CmdShipAttr = 4;
        public static final byte RequestSync_Model = 5;
    }
}

