/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.handler;

import com.lulan.shincolle.crafting.ShipCalc;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.entity.ExtendPlayerProps;
import com.lulan.shincolle.entity.mounts.EntityMountSeat;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.item.PointerItem;
import com.lulan.shincolle.network.C2SGUIPackets;
import com.lulan.shincolle.network.C2SInputPackets;
import com.lulan.shincolle.network.S2CGUIPackets;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class FML_COMMON_EventHandler {
    private GameSettings keySet;
    public int rideKeys = 0;
    public int openGUI = 0;
    public int keyCooldown = 0;
    private boolean isViewChanged = false;
    private boolean isViewPlayer = false;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ExtendPlayerProps extProps = (ExtendPlayerProps)event.player.getExtendedProperties("TeitokuExtProps");
            if (extProps != null && !event.player.field_70170_p.field_72995_K) {
                boolean syncTeamList = false;
                if (event.player.field_70173_aa > 0 && event.player.field_70173_aa % 32 == 0) {
                    if (extProps.getPlayerUID() < 100) {
                        NBTTagCompound nbt = ServerProxy.getPlayerData(event.player.func_110124_au().toString());
                        if (nbt != null) {
                            extProps.loadNBTData(nbt);
                            LogHelper.info("DEBUG : player tick: restore player data: eid: " + event.player.func_145782_y() + " pid: " + extProps.getPlayerUID() + " uuid: " + event.player.func_110124_au().toString());
                        }
                        if (extProps.getPlayerUID() < 100) {
                            ServerProxy.updatePlayerID(event.player);
                            LogHelper.info("DEBUG : player tick: generate new player UID, save player extProps in ServerProxy");
                            nbt = new NBTTagCompound();
                            extProps.saveNBTData(nbt);
                            ServerProxy.setPlayerData(event.player.func_110124_au().toString(), nbt);
                        }
                        extProps.sendSyncPacket(0);
                    }
                    if (event.player.field_70173_aa == 64) {
                        this.updateTeamList(event.player, extProps);
                        syncTeamList = true;
                    }
                    if (event.player.field_70173_aa % 128 == 0) {
                        this.spawnMobShip(event.player, extProps);
                        int peid = EntityHelper.getPlayerEID(extProps.getPlayerUID());
                        if (peid != event.player.func_145782_y()) {
                            LogHelper.info("DEBUG : player tick: player entity id changed, update new eid: " + peid + " to " + event.player.func_145782_y());
                            ServerProxy.updatePlayerID(event.player);
                        }
                        if (event.player.field_70173_aa % 256 == 0) {
                            this.updateTeamList(event.player, extProps);
                            syncTeamList = true;
                        }
                    }
                }
                this.spawnBossShip(event.player, extProps);
                if (!extProps.getInitSID() && event.player.field_70173_aa % 16 == 0) {
                    extProps.updateShipEntityBySID();
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(5, 0, true), (EntityPlayerMP)event.player);
                    LogHelper.info("DEBUG : player tick: update team entity");
                    syncTeamList = true;
                }
                if (syncTeamList) {
                    extProps.sendSyncPacket(0);
                }
            }
            if (event.player.field_70170_p.field_72995_K && this.keyCooldown > 0) {
                --this.keyCooldown;
            }
            if (event.player.field_70173_aa % 32 == 0) {
                boolean hasRing = false;
                ItemStack itemRing = null;
                for (int i = 0; i < event.player.field_71071_by.func_70302_i_(); ++i) {
                    if (event.player.field_71071_by.func_70301_a(i) == null || event.player.field_71071_by.func_70301_a(i).func_77973_b() != ModItems.MarriageRing) continue;
                    hasRing = true;
                    itemRing = event.player.field_71071_by.func_70301_a(i);
                    break;
                }
                if (extProps != null) {
                    if (extProps.hasRing() && !hasRing) {
                        event.player.field_71075_bZ.field_75100_b = false;
                    }
                    extProps.setHasRing(hasRing);
                    if (itemRing != null && itemRing.func_77942_o() && itemRing.func_77978_p().func_74767_n("isActive")) {
                        extProps.setRingActive(true);
                    }
                }
            }
        }
    }

    private void updateTeamList(EntityPlayer player, ExtendPlayerProps extProps) {
        BasicEntityShip getent = null;
        for (int i = 0; i < 6; ++i) {
            getent = EntityHelper.getShipBySID(extProps.getSIDCurrentTeam(i));
            if (getent != null) {
                if (EntityHelper.checkSameOwner((Entity)getent, (Entity)player)) {
                    extProps.addShipEntityToCurrentTeam(i, getent);
                    continue;
                }
                extProps.addShipEntityToCurrentTeam(i, null);
                continue;
            }
            if (extProps.getSIDCurrentTeam(i) > 0) continue;
            extProps.addShipEntityToCurrentTeam(i, null);
        }
    }

    private void spawnMobShip(EntityPlayer player, ExtendPlayerProps props) {
        int entNum;
        if (player == null || props == null || player.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return;
        }
        boolean canSpawn = false;
        int blockX = (int)player.field_70165_t;
        int blockZ = (int)player.field_70161_v;
        int spawnZ = 0;
        BiomeGenBase biome = player.field_70170_p.func_72807_a(blockX, blockZ);
        World w = player.field_70170_p;
        Random rng = player.func_70681_au();
        if (ConfigHandler.checkRing) {
            if (props.hasRing()) {
                canSpawn = true;
            }
        } else {
            canSpawn = true;
        }
        if (canSpawn && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            canSpawn = false;
        }
        if (canSpawn && (entNum = EntityHelper.getEntityNumber(0, w)) <= ConfigHandler.mobSpawn[0] && rng.nextInt(100) <= ConfigHandler.mobSpawn[1]) {
            int groups = ConfigHandler.mobSpawn[2];
            for (int loop = 30 + groups * 10; groups > 0 && loop > 0; --loop) {
                int spawnX;
                int offX = rng.nextInt(30) + 20;
                int offZ = rng.nextInt(30) + 20;
                switch (rng.nextInt(4)) {
                    case 1: {
                        spawnX = blockX - offX;
                        spawnZ = blockZ - offZ;
                        break;
                    }
                    case 2: {
                        spawnX = blockX + offX;
                        spawnZ = blockZ - offZ;
                        break;
                    }
                    case 3: {
                        spawnX = blockX - offX;
                        spawnZ = blockZ + offZ;
                        break;
                    }
                    default: {
                        spawnX = blockX + offX;
                        spawnZ = blockZ + offZ;
                    }
                }
                Block blockY = w.func_147439_a(spawnX, w.field_73011_w.func_76557_i() - 2, spawnZ);
                LogHelper.info("DEBUG : spawn mob ship: group: " + groups + " get block: " + blockY.func_149732_F() + " " + spawnX + " 62 " + spawnZ);
                if (blockY.func_149688_o() != Material.field_151586_h) continue;
                --groups;
                int spawnY = BlockHelper.getToppestWaterHeight(w, spawnX, 62, spawnZ);
                int shipNum = Math.max(1, ConfigHandler.mobSpawn[3]);
                int ranMax = ConfigHandler.mobSpawn[4] - ConfigHandler.mobSpawn[3];
                if (ranMax > 0) {
                    shipNum = ConfigHandler.mobSpawn[3] + rng.nextInt(ranMax + 1);
                }
                for (int i = 0; i < shipNum; ++i) {
                    String shipname = ShipCalc.getRandomMobToSpawnName(0);
                    EntityLiving entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)shipname, (World)w);
                    if (entityToSpawn != null) {
                        entityToSpawn.func_70107_b((double)spawnX + rng.nextDouble(), (double)spawnY + 0.5, (double)spawnZ + rng.nextDouble());
                        w.func_72838_d((Entity)entityToSpawn);
                    }
                    LogHelper.info("DEBUG : spawn mob ship: #total: " + entNum++ + " group: " + groups + " #ship: " + i + " " + spawnY + " " + shipname);
                }
            }
        }
    }

    private void spawnBossShip(EntityPlayer player, ExtendPlayerProps extProps) {
        if (player == null || extProps == null || player.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return;
        }
        int blockX = (int)player.field_70165_t;
        int blockZ = (int)player.field_70161_v;
        int spawnZ = 0;
        BiomeGenBase biome = player.field_70170_p.func_72807_a(blockX, blockZ);
        World w = player.field_70170_p;
        Random rng = player.func_70681_au();
        int allycd = extProps.getPlayerTeamCooldown();
        if (allycd > 0) {
            extProps.setPlayerTeamCooldown(--allycd);
        }
        if ((BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) && extProps.hasRing()) {
            extProps.setBossCooldown(extProps.getBossCooldown() - 1);
        }
        if (extProps.getBossCooldown() <= 0) {
            extProps.setBossCooldown(ConfigHandler.bossCooldown);
            int rolli = rng.nextInt(4);
            LogHelper.info("DEBUG : spawn boss: roll spawn " + rolli);
            if (rolli == 0) {
                for (int i = 0; i < 20; ++i) {
                    int spawnX;
                    int offX = rng.nextInt(32) + 32;
                    int offZ = rng.nextInt(32) + 32;
                    switch (rng.nextInt(4)) {
                        case 1: {
                            spawnX = blockX - offX;
                            spawnZ = blockZ - offZ;
                            break;
                        }
                        case 2: {
                            spawnX = blockX + offX;
                            spawnZ = blockZ - offZ;
                            break;
                        }
                        case 3: {
                            spawnX = blockX - offX;
                            spawnZ = blockZ + offZ;
                            break;
                        }
                        default: {
                            spawnX = blockX + offX;
                            spawnZ = blockZ + offZ;
                        }
                    }
                    Block blockY = w.func_147439_a(spawnX, w.field_73011_w.func_76557_i() - 2, spawnZ);
                    LogHelper.info("DEBUG : spawn boss: check block: " + blockY.func_149732_F() + " " + spawnX + " 63 " + spawnZ);
                    if (blockY.func_149688_o() != Material.field_151586_h) continue;
                    int spawnY = BlockHelper.getToppestWaterHeight(w, spawnX, 63, spawnZ);
                    AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)spawnX - 48.0), (double)((double)spawnY - 48.0), (double)((double)spawnZ - 48.0), (double)((double)spawnX + 48.0), (double)((double)spawnY + 48.0), (double)((double)spawnZ + 48.0));
                    List listBoss = w.func_72872_a(BasicEntityShipHostile.class, aabb);
                    int bossNum = 0;
                    if (listBoss.size() > 0) {
                        for (BasicEntityShipHostile mob : listBoss) {
                            if (!(mob instanceof IBossDisplayData)) continue;
                            ++bossNum;
                        }
                    }
                    LogHelper.info("DEBUG : spawn boss: check existed boss: " + bossNum + " all mob: " + listBoss.size());
                    if (bossNum >= 2) continue;
                    int maxShipNum = ConfigHandler.spawnBossNum + ConfigHandler.spawnMobNum;
                    String[] spawnName = new String[maxShipNum];
                    for (i = 0; i < ConfigHandler.spawnBossNum; ++i) {
                        spawnName[i] = ShipCalc.getRandomMobToSpawnName(rng.nextInt(2) + 2);
                    }
                    for (i = ConfigHandler.spawnBossNum; i < maxShipNum; ++i) {
                        spawnName[i] = ShipCalc.getRandomMobToSpawnName(rng.nextInt(2));
                    }
                    for (String name : spawnName) {
                        EntityLiving entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)name, (World)w);
                        if (entityToSpawn == null) continue;
                        entityToSpawn.func_70107_b((double)(spawnX + rng.nextInt(3)), (double)spawnY + 0.5, (double)(spawnZ + rng.nextInt(3)));
                        w.func_72838_d((Entity)entityToSpawn);
                    }
                    String spawnText = null;
                    spawnText = rng.nextInt(2) == 0 ? StatCollector.func_74838_a((String)"chat.shincolle:bossspawn1") : StatCollector.func_74838_a((String)"chat.shincolle:bossspawn2");
                    ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + spawnText + EnumChatFormatting.AQUA + " " + spawnX + " " + spawnY + " " + spawnZ));
                    LogHelper.info("DEBUG : spawn fleet " + spawnX + " " + spawnY + " " + spawnZ);
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LogHelper.info("DEBUG : get player respawn event " + event.player.getDisplayName() + " " + event.player.func_110124_au());
        NBTTagCompound nbt = ServerProxy.getPlayerData(event.player.func_110124_au().toString());
        if (nbt != null) {
            ExtendPlayerProps extProps = (ExtendPlayerProps)event.player.getExtendedProperties("TeitokuExtProps");
            extProps.loadNBTData(nbt);
            LogHelper.info("DEBUG : player respawn: restore player data: eid: " + event.player.func_145782_y() + " pid: " + extProps.getPlayerUID());
            extProps.sendSyncPacket(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onKeyInput(InputEvent event) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        this.keySet = ClientProxy.getGameSetting();
        if (event instanceof InputEvent.KeyInputEvent && player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof PointerItem) {
            ItemStack pointer = player.field_71071_by.func_70448_g();
            int meta = pointer.func_77960_j();
            int getKey = -1;
            int orgCurrentItem = player.field_71071_by.field_70461_c;
            if (this.keySet.field_151444_V.func_151470_d()) {
                for (int i = 0; i < this.keySet.field_151456_ac.length; ++i) {
                    if (!this.keySet.field_151456_ac[i].func_151470_d()) continue;
                    getKey = i;
                    if (!pointer.func_77942_o()) {
                        pointer.func_77982_d(new NBTTagCompound());
                    }
                    pointer.func_77978_p().func_74757_a("chgHB", true);
                    pointer.func_77978_p().func_74768_a("orgHB", orgCurrentItem);
                    break;
                }
                LogHelper.info("DEBUG : key input: pointer set team: " + getKey + " currItem: " + orgCurrentItem);
                if (getKey >= 0) {
                    CommonProxy.channelG.sendToServer((IMessage)new C2SGUIPackets(player, -8, getKey, orgCurrentItem));
                }
            } else if (this.keySet.field_74321_H.func_151470_d()) {
                switch (meta) {
                    case 1: {
                        meta = 4;
                        break;
                    }
                    case 2: {
                        meta = 5;
                        break;
                    }
                    case 3: {
                        meta = 0;
                        break;
                    }
                    case 4: {
                        meta = 1;
                        break;
                    }
                    case 5: {
                        meta = 2;
                        break;
                    }
                    default: {
                        meta = 3;
                    }
                }
                player.field_71071_by.func_70448_g().func_77964_b(meta);
                CommonProxy.channelG.sendToServer((IMessage)new C2SGUIPackets(player, -5, meta));
            }
        }
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityMountSeat) {
            int newKeys = 0;
            if (this.keySet.field_74322_I.func_151470_d() && this.keyCooldown <= 0) {
                LogHelper.info("DEBUG : key event: player view " + this.isViewPlayer);
                this.keyCooldown = 5;
                boolean bl = this.isViewPlayer = !this.isViewPlayer;
            }
            if (event instanceof InputEvent.KeyInputEvent) {
                BasicEntityMount mount;
                if (this.keySet.field_74351_w.func_151470_d()) {
                    LogHelper.info("DEBUG : key event: press W");
                    newKeys |= 1;
                }
                if (this.keySet.field_74368_y.func_151470_d()) {
                    LogHelper.info("DEBUG : key event: press S");
                    newKeys |= 2;
                }
                if (this.keySet.field_74370_x.func_151470_d()) {
                    LogHelper.info("DEBUG : key event: press A");
                    newKeys |= 4;
                }
                if (this.keySet.field_74366_z.func_151470_d()) {
                    LogHelper.info("DEBUG : key event: press D");
                    newKeys |= 8;
                }
                if (this.keySet.field_74314_A.func_151468_f()) {
                    LogHelper.info("DEBUG : key event: jump");
                    newKeys |= 0x10;
                }
                if ((mount = ((EntityMountSeat)player.field_70154_o).host) != null) {
                    this.rideKeys = newKeys;
                    ((EntityMountSeat)player.field_70154_o).host.keyPressed = newKeys;
                    if (this.keySet.field_151445_Q.func_151468_f()) {
                        CommonProxy.channelG.sendToServer((IMessage)new C2SInputPackets(1, this.openGUI));
                    } else {
                        CommonProxy.channelG.sendToServer((IMessage)new C2SInputPackets(0, this.rideKeys));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        LogHelper.info("DEBUG : player login: " + event.player.getDisplayName() + " " + event.player.func_110124_au());
        ExtendPlayerProps extProps = (ExtendPlayerProps)event.player.getExtendedProperties("TeitokuExtProps");
        if (extProps != null && !event.player.field_70170_p.field_72995_K) {
            ServerProxy.updatePlayerID(event.player);
            LogHelper.info("DEBUG : player login: save player extProps in ServerProxy");
            NBTTagCompound nbt = new NBTTagCompound();
            extProps.saveNBTData(nbt);
            ServerProxy.setPlayerData(event.player.func_110124_au().toString(), nbt);
            extProps.sendSyncPacket(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ExtendPlayerProps extProps = (ExtendPlayerProps)event.player.getExtendedProperties("TeitokuExtProps");
        LogHelper.info("DEBUG : player logout: " + event.player.getDisplayName() + " " + event.player.func_110124_au());
        if (extProps != null) {
            LogHelper.info("DEBUG : player logout: save player extProps in ServerProxy");
            NBTTagCompound nbt = new NBTTagCompound();
            extProps.saveNBTData(nbt);
            ServerProxy.setPlayerData(event.player.func_110124_au().toString(), nbt);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        LogHelper.info("DEBUG : player change dim: " + event.player.getDisplayName() + " " + event.player.func_110124_au());
        if (event.player != null && !event.player.field_70170_p.field_72995_K) {
            ServerProxy.updatePlayerID(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        if (player != null) {
            if (event.phase == TickEvent.Phase.START) {
                if (player.func_70115_ae() && player.field_70154_o instanceof EntityMountSeat) {
                    EntityMountSeat seat = (EntityMountSeat)player.field_70154_o;
                    if (seat.host != null) {
                        EntityLivingBase camera;
                        if (seat.host.host != null && !this.isViewChanged && !this.isViewPlayer) {
                            ClientProxy.getMineraft().field_71451_h = seat.host.host;
                            this.isViewChanged = true;
                        }
                        if (this.isViewChanged && (camera = ClientProxy.getMineraft().field_71451_h) != null) {
                            camera.field_70761_aq = player.field_70761_aq;
                            camera.field_70125_A = player.field_70125_A;
                            camera.field_70177_z = player.field_70177_z;
                            camera.field_70759_as = player.field_70759_as;
                            camera.field_70727_aS = player.field_70727_aS;
                            camera.field_70760_ar = player.field_70760_ar;
                            camera.field_70127_C = player.field_70127_C;
                            camera.field_70126_B = player.field_70126_B;
                            camera.field_70758_at = player.field_70758_at;
                        }
                    }
                }
            } else if (event.phase == TickEvent.Phase.END && this.isViewChanged) {
                ClientProxy.getMineraft().field_71451_h = ClientProxy.getClientPlayer();
                this.isViewChanged = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerProxy.updateServerTick();
        }
    }
}

