/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.other;

import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipAttributes;
import com.lulan.shincolle.entity.IShipFlyable;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAbyssMissile
extends Entity
implements IShipOwner,
IShipAttributes,
IShipFlyable {
    private IShipAttackBase host;
    private EntityLiving host2;
    private int playerUID;
    private boolean isDirect;
    private float accParaY;
    private int midFlyTime;
    private static final float ACC = 0.01f;
    private float acce;
    private float accX;
    private float accY;
    private float accZ;
    public int type;
    private float atk;
    private float kbValue;
    private float missileHP;
    private World world;

    public EntityAbyssMissile(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityAbyssMissile(World world, IShipAttackBase host, float mX, float mY, float mZ, float pX, float pY, float pZ, float atk, float kbValue) {
        super(world);
        this.world = world;
        this.host = host;
        this.host2 = (EntityLiving)host;
        this.setPlayerUID(host.getPlayerUID());
        this.atk = atk;
        this.kbValue = kbValue;
        this.field_70165_t = pX;
        this.field_70163_u = pY;
        this.field_70161_v = pZ;
        this.isDirect = false;
        this.type = 4;
        this.acce = 0.01f;
        this.accParaY = this.acce * 0.5f;
        if (mY > 0.0f) {
            mY = 0.0f;
        }
        this.accX = mX * 0.1f;
        this.accY = -this.acce;
        this.accZ = mZ * 0.1f;
        this.field_70159_w = mX;
        this.field_70181_x = mY;
        this.field_70179_y = mZ;
    }

    public EntityAbyssMissile(World world, IShipAttackBase host, float tarX, float tarY, float tarZ, float launchPos, float atk, float kbValue, boolean isDirect, float customAcc) {
        super(world);
        this.world = world;
        this.host = host;
        this.host2 = (EntityLiving)host;
        this.setPlayerUID(host.getPlayerUID());
        this.atk = atk;
        this.kbValue = kbValue;
        this.field_70165_t = this.host2.field_70165_t;
        this.field_70161_v = this.host2.field_70161_v;
        this.field_70163_u = launchPos;
        float distX = (float)((double)tarX - this.field_70165_t);
        float distY = (float)((double)tarY - this.field_70163_u);
        float distZ = (float)((double)tarZ - this.field_70161_v);
        if (MathHelper.func_76135_e((float)distX) < 0.001f) {
            distX = 0.0f;
        }
        if (MathHelper.func_76135_e((float)distY) < 0.001f) {
            distY = 0.0f;
        }
        if (MathHelper.func_76135_e((float)distZ) < 0.001f) {
            distZ = 0.0f;
        }
        this.isDirect = isDirect;
        this.type = 0;
        if (customAcc > 0.0f) {
            this.acce = customAcc;
            if (customAcc > 0.09f) {
                this.type = 2;
            } else if (customAcc > 0.05f) {
                this.type = 1;
            }
        } else {
            this.acce = 0.01f;
        }
        if (customAcc == -2.0f) {
            this.type = 3;
            LogHelper.info("DEBUG : const type 3 missile ");
        }
        float dist = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        this.accX = distX / dist * this.acce;
        this.accY = distY / dist * this.acce;
        this.accZ = distZ / dist * this.acce;
        this.field_70159_w = this.accX;
        this.field_70181_x = this.accY;
        this.field_70179_y = this.accZ;
        if (!this.isDirect) {
            this.midFlyTime = (int)(0.5f * MathHelper.func_76129_c((float)(2.0f * dist / this.acce)));
            this.accParaY = this.acce;
            this.field_70181_x += (double)this.midFlyTime * (double)this.accParaY;
        }
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distanceSq) {
        double d1 = this.field_70121_D.func_72320_b() * 256.0;
        return distanceSq < d1 * d1;
    }

    public void func_70071_h_() {
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70181_x = !this.isDirect ? this.field_70181_x + (double)this.accY - (double)this.accParaY : (this.field_70181_x += (double)this.accY);
        if (this.type == 4) {
            this.field_70159_w *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        }
        this.field_70159_w += (double)this.accX;
        this.field_70179_y += (double)this.accZ;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70125_A = (float)Math.atan2(this.field_70181_x, f1);
        this.field_70177_z = (float)Math.atan2(this.field_70159_w, this.field_70179_y);
        this.field_70177_z = this.field_70159_w > 0.0 ? (float)((double)this.field_70177_z - Math.PI) : (float)((double)this.field_70177_z + Math.PI);
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.host == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa > 200) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa == 1) {
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, this.type, 8), point);
            }
            if (this.type == 3 && this.field_70173_aa > 15 && this.field_70173_aa % 8 == 0) {
                EntityAbyssMissile subm = new EntityAbyssMissile(this.field_70170_p, this.host, (float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y, (float)this.field_70165_t, (float)this.field_70163_u - 0.75f, (float)this.field_70161_v, this.atk, this.kbValue);
                this.field_70170_p.func_72838_d((Entity)subm);
            }
            if (!this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
                this.onImpact(null);
            }
            Vec3 vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            vec31 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingobjectposition != null) {
                vec31 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
                this.onImpact(null);
            }
            Entity hitEntity = null;
            List hitList = null;
            hitList = this.field_70170_p.func_72872_a(Entity.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; !(i >= hitList.size() || (hitEntity = (Entity)hitList.get(i)).func_70067_L() && this.isNotHost(hitEntity) && !EntityHelper.checkSameOwner((Entity)this.host2, hitEntity)); ++i) {
                    hitEntity = null;
                }
            }
            if (hitEntity != null) {
                this.onImpact(hitEntity);
            }
        } else if (this.type != 2) {
            byte smokeType = 15;
            switch (this.type) {
                case 1: {
                    smokeType = 41;
                    break;
                }
                case 3: 
                case 4: {
                    smokeType = 18;
                    break;
                }
            }
            for (int j = 0; j < 3; ++j) {
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t - this.field_70159_w * 1.5 * (double)j, this.field_70163_u + 1.0 - this.field_70181_x * 1.5 * (double)j, this.field_70161_v - this.field_70179_y * 1.5 * (double)j, -this.field_70159_w * 0.1, -this.field_70181_x * 0.1, -this.field_70179_y * 0.1, smokeType);
            }
        } else {
            ParticleHelper.spawnAttackParticleAtEntity(this, 0.0, 10.0, 4.0, (byte)9);
        }
    }

    private boolean isNotHost(Entity entity) {
        if (entity.equals((Object)this)) {
            return false;
        }
        return this.host2 == null || this.host2.func_145782_y() != entity.func_145782_y();
    }

    protected void onImpact(Entity target) {
        this.func_85030_a("shincolle:ship-explode", ConfigHandler.volumeFire * 1.5f, 0.7f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            float missileAtk = this.atk;
            Entity hitEntity = null;
            AxisAlignedBB impactBox = this.field_70121_D.func_72314_b(3.5, 3.5, 3.5);
            List hitList = this.field_70170_p.func_72872_a(Entity.class, impactBox);
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; i < hitList.size(); ++i) {
                    missileAtk = this.atk;
                    hitEntity = (Entity)hitList.get(i);
                    if (!EntityHelper.checkAttackable(hitEntity)) continue;
                    missileAtk = CalcHelper.calcDamageBySpecialEffect(this, hitEntity, missileAtk, 0);
                    if (!hitEntity.func_70067_L() || !this.isNotHost(hitEntity)) continue;
                    if (EntityHelper.checkSameOwner((Entity)this.host2, hitEntity)) {
                        missileAtk = 0.0f;
                    } else {
                        if (this.host != null && this.field_70146_Z.nextFloat() < this.host.getEffectEquip(0)) {
                            missileAtk *= 3.0f;
                            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 11, false), point);
                        }
                        if (hitEntity instanceof EntityPlayer && (missileAtk *= 0.25f) > 59.0f) {
                            missileAtk = 59.0f;
                        }
                        if (!EntityHelper.doFriendlyFire(this.host, hitEntity)) {
                            missileAtk = 0.0f;
                        }
                    }
                    hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.host2).func_94540_d(), missileAtk);
                }
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(this, 2, false), point);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        nbt.func_74776_a("atk", this.atk);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
        this.atk = nbt.func_74760_g("atk");
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource attacker, float atk) {
        if (EntityHelper.canDodge(this, 0.0f)) {
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.func_70089_S() && atk > 10.0f) {
            this.func_70106_y();
            this.onImpact(null);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        return 0xF000F0;
    }

    public void setMissileType(int par1) {
        this.type = par1;
    }

    @Override
    public int getPlayerUID() {
        return this.playerUID;
    }

    @Override
    public void setPlayerUID(int uid) {
        this.playerUID = uid;
    }

    @Override
    public Entity getHostEntity() {
        return this.host2;
    }

    @Override
    public float getEffectEquip(int id) {
        if (id == 6) {
            return 50.0f;
        }
        if (this.host != null) {
            return this.host.getEffectEquip(id);
        }
        return 0.0f;
    }
}

