/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.battleship;

import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.entity.BasicEntityShipSmall;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.entity.other.EntityProjectileBeam;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBattleshipYMT
extends BasicEntityShipSmall {
    public EntityBattleshipYMT(World world) {
        super(world);
        this.func_70105_a(0.8f, 2.1f);
        this.setStateMinor(19, 6);
        this.setStateMinor(20, 46);
        this.setStateMinor(25, 3);
        this.setGrudgeConsumption(ConfigHandler.consumeGrudgeShip[7]);
        this.setAmmoConsumption(ConfigHandler.consumeAmmoShip[7]);
        this.ModelPos = new float[]{0.0f, 15.0f, 0.0f, 40.0f};
        this.ExtProps = (ExtendShipProps)this.getExtendedProperties("ShipExtProps");
        this.StateFlag[15] = false;
        this.StateFlag[16] = false;
        this.setFoodSaturationMax(30);
        this.postInit();
    }

    @Override
    public float func_70047_e() {
        return 1.7375f;
    }

    @Override
    public int getEquipType() {
        return 1;
    }

    @Override
    public void setAIList() {
        super.setAIList();
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIShipRangeAttack(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 4 == 0 && this.getStateEmotion(0) >= 2 && !this.func_70906_o() && !this.getStateFlag(2)) {
                double smokeY = this.field_70163_u + 1.75;
                float[] partPos = ParticleHelper.rotateXZByAxis(-0.55f, 0.0f, this.field_70761_aq % 360.0f * ((float)Math.PI / 180), 1.0f);
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t + (double)partPos[1], smokeY, this.field_70161_v + (double)partPos[0], 0.0, 0.0, 0.0, (byte)20);
            }
            if (this.field_70173_aa % 16 == 0 && this.getStateEmotion(5) > 0) {
                ParticleHelper.spawnAttackParticleAtEntity((Entity)this, 0.0, 16.0, 1.0, (byte)4);
            }
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151105_aU) {
            this.setShipOutfit(player.func_70093_af());
            return true;
        }
        super.func_70085_c(player);
        return false;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float[] distVec;
        float atk = CalcHelper.calcDamageBySpecialEffect(this, target, this.StateFinal[6], 3);
        float tarX = (float)target.field_70165_t;
        float tarY = (float)(target.field_70163_u + (double)(target.field_70131_O * 0.5f));
        float tarZ = (float)target.field_70161_v;
        distVec = new float[]{tarX - (float)this.field_70165_t, tarY - (float)this.field_70163_u, tarZ - (float)this.field_70161_v, MathHelper.func_76129_c((float)(distVec[0] * distVec[0] + distVec[1] * distVec[1] + distVec[2] * distVec[2]))};
        if (distVec[3] < 0.001f) {
            distVec[3] = 0.001f;
        }
        distVec[0] = distVec[0] / distVec[3];
        distVec[1] = distVec[1] / distVec[3];
        distVec[2] = distVec[2] / distVec[3];
        this.addShipExp(ConfigHandler.expGain[2]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[1]);
        this.decrMorale(2);
        this.setCombatTick(this.field_70173_aa);
        if (!this.decrAmmoNum(1, this.getAmmoConsumption())) {
            return false;
        }
        this.applySoundAtAttacker(2, target);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        if (this.getStateEmotion(5) > 0) {
            this.func_85030_a("shincolle:ship-yamato-shot", ConfigHandler.volumeFire, 1.0f);
            EntityProjectileBeam beam = new EntityProjectileBeam(this.field_70170_p, this, 0, distVec[0], distVec[1], distVec[2], atk, 0.12f);
            this.field_70170_p.func_72838_d((Entity)beam);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, beam, (double)distVec[0], (double)distVec[1], (double)distVec[2], 1, true), point);
            this.setStateEmotion(5, 0, true);
            return true;
        }
        this.func_85030_a("shincolle:ship-yamato-ready", ConfigHandler.volumeFire, 1.0f);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 7, 1.0, 0.0, 0.0), point);
        this.setStateEmotion(5, 1, true);
        this.applyEmotesReaction(3);
        if (ConfigHandler.canFlare) {
            this.flareTarget(target);
        }
        return false;
    }

    @Override
    public int getKaitaiType() {
        return 3;
    }

    @Override
    public double func_70042_X() {
        if (this.func_70906_o()) {
            if (this.getStateEmotion(0) > 0) {
                return (double)this.field_70131_O * (double)0.4f;
            }
            if (this.getStateEmotion(1) == 4) {
                return (double)this.field_70131_O * (double)-0.1f;
            }
            return (double)this.field_70131_O * (double)0.3f;
        }
        return (double)this.field_70131_O * (double)0.8f;
    }

    @Override
    public void setShipOutfit(boolean isSneaking) {
        if (isSneaking) {
            switch (this.getStateEmotion(4)) {
                case 0: {
                    this.setStateEmotion(4, 1, true);
                    break;
                }
                case 1: {
                    this.setStateEmotion(4, 2, true);
                    break;
                }
                case 2: {
                    this.setStateEmotion(4, 3, true);
                    break;
                }
                default: {
                    this.setStateEmotion(4, 0, true);
                    break;
                }
            }
        } else {
            switch (this.getStateEmotion(0)) {
                case 0: {
                    this.setStateEmotion(0, 1, true);
                    break;
                }
                case 1: {
                    this.setStateEmotion(0, 2, true);
                    break;
                }
                case 2: {
                    this.setStateEmotion(0, 3, true);
                    break;
                }
                default: {
                    this.setStateEmotion(0, 0, true);
                }
            }
        }
    }

    @Override
    public void applyParticleAtAttacker(int type, Entity target, float[] vec) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        switch (type) {
            case 1: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 5, 1.0, 1.0, 1.5), point);
                break;
            }
            case 2: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
                break;
            }
            case 3: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
                break;
            }
            case 4: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
                break;
            }
            default: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
            }
        }
    }

    @Override
    public void applySoundAtAttacker(int type, Entity target) {
        switch (type) {
            case 1: {
                this.func_85030_a("shincolle:ship-firesmall", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                if (this.func_70681_au().nextInt(10) <= 7) break;
                this.func_85030_a(this.getSoundString(2), ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 2: {
                if (this.func_70681_au().nextInt(10) <= 7) break;
                this.func_85030_a(this.getSoundString(2), ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 3: {
                this.func_85030_a("shincolle:ship-aircraft", ConfigHandler.volumeFire * 0.5f, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 4: {
                this.func_85030_a("shincolle:ship-aircraft", ConfigHandler.volumeFire * 0.5f, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                break;
            }
            default: {
                if (this.func_70681_au().nextInt(10) <= 6) break;
                this.func_85030_a(this.getSoundString(2), ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            }
        }
    }
}

