/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.battleship;

import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.entity.BasicEntityShipSmall;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBattleshipNGT
extends BasicEntityShipSmall {
    public EntityBattleshipNGT(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.0f);
        this.setStateMinor(19, 6);
        this.setStateMinor(20, 37);
        this.setStateMinor(25, 3);
        this.setGrudgeConsumption(ConfigHandler.consumeGrudgeShip[7]);
        this.setAmmoConsumption(ConfigHandler.consumeAmmoShip[7]);
        this.ModelPos = new float[]{0.0f, 15.0f, 0.0f, 40.0f};
        this.ExtProps = (ExtendShipProps)this.getExtendedProperties("ShipExtProps");
        this.StateFlag[15] = false;
        this.StateFlag[16] = false;
        this.setFoodSaturationMax(20);
        this.postInit();
    }

    @Override
    public float func_70047_e() {
        return 1.7375f;
    }

    @Override
    public int getEquipType() {
        return 1;
    }

    @Override
    public void setAIList() {
        super.setAIList();
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIShipRangeAttack(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 10 == 0 && this.getStateEmotion(5) > 0) {
                ParticleHelper.spawnAttackParticleAtEntity((Entity)this, 0.1, 1.0, 0.0, (byte)1);
            }
            if (this.field_70173_aa % 4 == 0 && this.getStateEmotion(0) >= 2 && !this.func_70906_o() && !this.getStateFlag(2)) {
                double smokeY = this.field_70163_u + 1.6;
                float[] partPos = ParticleHelper.rotateXZByAxis(-0.55f, 0.0f, this.field_70761_aq % 360.0f / 57.2957f, 1.0f);
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t + (double)partPos[1], smokeY, this.field_70161_v + (double)partPos[0], 0.0, 0.0, 0.0, (byte)20);
            }
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151105_aU) {
            this.setShipOutfit(player.func_70093_af());
            return true;
        }
        super.func_70085_c(player);
        return false;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float atk1 = CalcHelper.calcDamageBySpecialEffect(this, target, this.StateFinal[6], 2);
        float atk2 = this.StateFinal[6] * 2.0f;
        boolean isTargetHurt = false;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        float distX = tarX - (float)this.field_70165_t;
        float distY = tarY - (float)this.field_70163_u;
        float distZ = tarZ - (float)this.field_70161_v;
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        float dX = distX / distSqrt;
        float dY = distY / distSqrt;
        float dZ = distZ / distSqrt;
        this.addShipExp(ConfigHandler.expGain[2]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[1]);
        this.decrMorale(2);
        this.setCombatTick(this.field_70173_aa);
        if (!this.decrAmmoNum(1, this.getAmmoConsumption())) {
            return false;
        }
        int atkPhase = this.getStateEmotion(5);
        switch (atkPhase) {
            case 0: 
            case 2: {
                this.func_85030_a("shincolle:ship-ap_phase1", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            case 1: {
                this.func_85030_a("shincolle:ship-ap_phase2", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            case 3: {
                this.func_85030_a("shincolle:ship-ap_attack", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            default: {
                this.func_85030_a("shincolle:ship-ap_phase1", ConfigHandler.volumeFire, 1.0f);
            }
        }
        if (this.func_70681_au().nextInt(10) > 7) {
            this.func_85030_a(this.getSoundString(2), ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        if (++atkPhase > 3) {
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 21, this.field_70165_t, this.field_70163_u, this.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v, true), point);
            float missChance = 0.2f + 0.15f * (distSqrt / this.StateFinal[5]) - 0.001f * (float)this.StateMinor[0];
            missChance -= this.EffectEquip[3];
            if (missChance > 0.35f) {
                missChance = 0.35f;
            }
            if (this.field_70146_Z.nextFloat() < missChance) {
                atk1 = 0.0f;
                atk2 *= 0.5f;
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 10, false), point);
            } else if (this.field_70146_Z.nextFloat() < this.EffectEquip[0]) {
                atk1 *= 1.5f;
                atk2 *= 1.5f;
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 11, false), point);
            }
            if (target instanceof EntityPlayer) {
                atk1 *= 0.25f;
                atk2 *= 0.25f;
                if (!ConfigHandler.friendlyFire) {
                    atk1 = 0.0f;
                    atk2 = 0.0f;
                } else if (atk2 > 40.0f) {
                    atk2 = 40.0f;
                }
            }
            isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), atk1);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70165_t = tarX + dX * 2.0f;
            this.field_70163_u = tarY;
            this.field_70161_v = tarZ + dZ * 2.0f;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            EntityLivingBase hitEntity = null;
            AxisAlignedBB impactBox = this.field_70121_D.func_72314_b(3.5, 3.5, 3.5);
            List hitList = this.field_70170_p.func_72872_a(EntityLivingBase.class, impactBox);
            float atkTemp = atk2;
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; i < hitList.size(); ++i) {
                    atkTemp = atk2;
                    hitEntity = (EntityLivingBase)hitList.get(i);
                    if (hitEntity == this || !EntityHelper.checkAttackable((Entity)hitEntity) || !hitEntity.func_70067_L() || !EntityHelper.checkNotSameEntityID((Entity)this, (Entity)hitEntity)) continue;
                    if (this.field_70146_Z.nextFloat() < missChance) {
                        atkTemp *= 0.5f;
                    } else if (this.field_70146_Z.nextFloat() < this.EffectEquip[0]) {
                        atkTemp *= 1.5f;
                    }
                    if (EntityHelper.checkSameOwner((Entity)this, (Entity)hitEntity)) {
                        atkTemp = 0.0f;
                    }
                    if (hitEntity instanceof EntityPlayer && (atkTemp *= 0.25f) > 59.0f) {
                        atkTemp = 59.0f;
                    }
                    if (!EntityHelper.doFriendlyFire(this, (Entity)hitEntity)) {
                        atkTemp = 0.0f;
                    }
                    hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), atkTemp);
                }
            }
            this.setStateEmotion(5, 0, true);
        } else {
            if (atkPhase == 2) {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 23, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, true), point);
            } else {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 22, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, true), point);
            }
            this.setStateEmotion(5, atkPhase, true);
        }
        this.applyEmotesReaction(3);
        if (ConfigHandler.canFlare) {
            this.flareTarget(target);
        }
        return isTargetHurt;
    }

    @Override
    public int getKaitaiType() {
        return 3;
    }

    @Override
    public double func_70042_X() {
        if (this.func_70906_o()) {
            if (this.getStateEmotion(0) > 0) {
                return (double)this.field_70131_O * (double)0.4f;
            }
            if (this.getStateEmotion(1) == 4) {
                return (double)this.field_70131_O * (double)-0.1f;
            }
            return (double)this.field_70131_O * (double)0.3f;
        }
        return (double)this.field_70131_O * (double)0.8f;
    }

    @Override
    public void setShipOutfit(boolean isSneaking) {
        switch (this.getStateEmotion(0)) {
            case 0: {
                this.setStateEmotion(0, 1, true);
                break;
            }
            case 1: {
                this.setStateEmotion(0, 2, true);
                break;
            }
            case 2: {
                this.setStateEmotion(0, 3, true);
                break;
            }
            default: {
                this.setStateEmotion(0, 0, true);
            }
        }
    }

    @Override
    public void applyParticleAtAttacker(int type, Entity target, float[] vec) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        switch (type) {
            case 1: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 19, this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, vec[0], 1.0, vec[2], true), point);
                break;
            }
            default: {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
            }
        }
    }
}

