/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity;

import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipAircraftAttack;
import com.lulan.shincolle.entity.other.EntityAirplane;
import com.lulan.shincolle.entity.other.EntityAirplaneTakoyaki;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.item.EquipAirplane;
import com.lulan.shincolle.utility.BlockHelper;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public abstract class BasicEntityShipCV
extends BasicEntityShip
implements IShipAircraftAttack {
    protected int maxAircraftLight;
    protected int maxAircraftHeavy;
    protected int delayAircraft = 0;
    protected double launchHeight;

    public BasicEntityShipCV(World world) {
        super(world);
    }

    @Override
    public int getNumAircraftLight() {
        return this.StateMinor[7];
    }

    @Override
    public int getNumAircraftHeavy() {
        return this.StateMinor[8];
    }

    @Override
    public boolean hasAirLight() {
        return this.StateMinor[7] > 0;
    }

    @Override
    public boolean hasAirHeavy() {
        return this.StateMinor[8] > 0;
    }

    @Override
    public boolean hasAmmoLight() {
        return this.StateMinor[4] >= 6 * this.StateMinor[29];
    }

    @Override
    public boolean hasAmmoHeavy() {
        return this.StateMinor[5] >= 2 * this.StateMinor[29];
    }

    @Override
    public void setNumAircraftLight(int par1) {
        if (this.field_70170_p.field_72995_K) {
            this.StateMinor[7] = par1;
        } else {
            this.StateMinor[7] = par1;
            if (this.getNumAircraftLight() > this.maxAircraftLight) {
                this.StateMinor[7] = this.maxAircraftLight;
            }
            if (this.getNumAircraftLight() < 0) {
                this.StateMinor[7] = 0;
            }
        }
    }

    @Override
    public void setNumAircraftHeavy(int par1) {
        if (this.field_70170_p.field_72995_K) {
            this.StateMinor[8] = par1;
        } else {
            this.StateMinor[8] = par1;
            if (this.getNumAircraftHeavy() > this.maxAircraftHeavy) {
                this.StateMinor[8] = this.maxAircraftHeavy;
            }
            if (this.getNumAircraftHeavy() < 0) {
                this.StateMinor[8] = 0;
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            --this.delayAircraft;
            if (this.delayAircraft <= 0) {
                this.delayAircraft = (int)(1000.0f / this.getStateFinal(3));
                if (this.delayAircraft > 1000) {
                    this.delayAircraft = 1000;
                }
                this.delayAircraft += 200;
                this.setNumAircraftLight(this.getNumAircraftLight() + 1);
                this.setNumAircraftHeavy(this.getNumAircraftHeavy() + 1);
            }
        }
    }

    @Override
    public void calcShipAttributes() {
        super.calcShipAttributes();
        this.maxAircraftLight = 8 + this.StateMinor[0] / 5;
        this.maxAircraftHeavy = 4 + this.StateMinor[0] / 10;
        int numair = this.getNumOfAircraftEquip();
        this.maxAircraftLight += numair * 4;
        this.maxAircraftHeavy += numair * 2;
    }

    public int getNumOfAircraftEquip() {
        int airNum = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.ExtProps.slots[i] == null || !(this.ExtProps.slots[i].func_77973_b() instanceof EquipAirplane)) continue;
            ++airNum;
        }
        return airNum;
    }

    protected BasicEntityAirplane getAttackAirplane(boolean isLightAirplane) {
        if (isLightAirplane) {
            return new EntityAirplane(this.field_70170_p);
        }
        return new EntityAirplaneTakoyaki(this.field_70170_p);
    }

    @Override
    public boolean attackEntityWithAircraft(Entity target) {
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.setEntityTarget(null);
        }
        this.setNumAircraftLight(this.getNumAircraftLight() - 1);
        if (!this.decrAmmoNum(0, 6 * this.getAmmoConsumption())) {
            return false;
        }
        this.addShipExp(ConfigHandler.expGain[3]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[2]);
        this.decrMorale(3);
        this.setCombatTick(this.field_70173_aa);
        this.applySoundAtAttacker(3, target);
        this.applyParticleAtAttacker(3, target, new float[4]);
        double summonHeight = this.field_70163_u + this.launchHeight;
        if (!BlockHelper.checkBlockSafe(this.field_70170_p, (int)this.field_70165_t, (int)(this.field_70163_u + this.launchHeight), (int)this.field_70161_v)) {
            summonHeight = this.field_70163_u + 1.0;
        }
        if (this.field_70154_o instanceof BasicEntityMount) {
            summonHeight -= 1.5;
        }
        BasicEntityAirplane plane = this.getAttackAirplane(true);
        plane.setAttrs(this.field_70170_p, this, target, summonHeight);
        this.field_70170_p.func_72838_d((Entity)plane);
        this.applySoundAtTarget(3, target);
        this.applyParticleAtTarget(3, target, new float[4]);
        this.applyEmotesReaction(3);
        return true;
    }

    @Override
    public boolean attackEntityWithHeavyAircraft(Entity target) {
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.setEntityTarget(null);
        }
        this.setNumAircraftHeavy(this.getNumAircraftHeavy() - 1);
        this.addShipExp(ConfigHandler.expGain[4]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[3]);
        this.decrMorale(4);
        this.setCombatTick(this.field_70173_aa);
        if (!this.decrAmmoNum(1, 2 * this.getAmmoConsumption())) {
            return false;
        }
        this.applySoundAtAttacker(4, target);
        this.applyParticleAtAttacker(4, target, new float[4]);
        double summonHeight = this.field_70163_u + this.launchHeight;
        if (!BlockHelper.checkBlockSafe(this.field_70170_p, (int)this.field_70165_t, (int)(this.field_70163_u + this.launchHeight), (int)this.field_70161_v)) {
            summonHeight = this.field_70163_u + 0.5;
        }
        if (this.field_70154_o instanceof BasicEntityMount) {
            summonHeight -= 1.5;
        }
        BasicEntityAirplane plane = this.getAttackAirplane(false);
        plane.setAttrs(this.field_70170_p, this, target, summonHeight);
        this.field_70170_p.func_72838_d((Entity)plane);
        this.applySoundAtTarget(4, target);
        this.applyParticleAtTarget(4, target, new float[4]);
        this.applyEmotesReaction(3);
        return true;
    }
}

