/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity;

import com.lulan.shincolle.ShinColle;
import com.lulan.shincolle.ai.EntityAIShipAttackOnCollide;
import com.lulan.shincolle.ai.EntityAIShipFloating;
import com.lulan.shincolle.ai.EntityAIShipFollowOwner;
import com.lulan.shincolle.ai.EntityAIShipGuarding;
import com.lulan.shincolle.ai.EntityAIShipOpenDoor;
import com.lulan.shincolle.ai.EntityAIShipWander;
import com.lulan.shincolle.ai.path.ShipMoveHelper;
import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipCannonAttack;
import com.lulan.shincolle.entity.IShipGuardian;
import com.lulan.shincolle.entity.IShipMount;
import com.lulan.shincolle.entity.mounts.EntityMountSeat;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.entity.other.EntityRensouhou;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class BasicEntityMount
extends EntityCreature
implements IShipMount,
IShipCannonAttack,
IShipGuardian {
    public BasicEntityShip host;
    public EntityMountSeat seat2;
    public EntityLivingBase riddenByEntity2;
    protected World world;
    protected ShipPathNavigate shipNavigator;
    protected ShipMoveHelper shipMoveHelper;
    protected Entity atkTarget;
    protected Entity rvgTarget;
    protected int revengeTime;
    protected float atkRange;
    protected float movSpeed;
    protected byte StateEmotion;
    protected byte StateEmotion2;
    protected int StartEmotion;
    protected int StartEmotion2;
    protected int StartEmotion3;
    protected boolean headTilt;
    protected float[] ridePos;
    protected double ShipDepth;
    public int keyPressed;
    public static boolean stopAI = false;

    public BasicEntityMount(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.field_70138_W = 3.0f;
        this.keyPressed = 0;
        this.shipNavigator = new ShipPathNavigate((EntityLiving)this, this.field_70170_p);
        this.shipMoveHelper = new ShipMoveHelper((EntityLiving)this, 20.0f);
        this.ridePos = new float[]{0.0f, 0.0f, 0.0f};
    }

    protected String func_70639_aQ() {
        if (ConfigHandler.useWakamoto && this.field_70146_Z.nextInt(30) == 0) {
            return "shincolle:ship-waka_idle";
        }
        return null;
    }

    protected String func_70621_aR() {
        if (ConfigHandler.useWakamoto && this.field_70146_Z.nextInt(30) == 0) {
            return "shincolle:ship-waka_hurt";
        }
        return null;
    }

    protected String func_70673_aS() {
        if (ConfigHandler.useWakamoto) {
            return "shincolle:ship-waka_death";
        }
        return null;
    }

    protected float func_70599_aP() {
        return ConfigHandler.volumeShip * 0.4f;
    }

    protected float func_70647_i() {
        return 1.0f;
    }

    public void setAIList() {
        if (!this.field_70170_p.field_72995_K) {
            this.clearAITasks();
            this.clearAITargetTasks();
            this.func_70661_as().func_75490_c(true);
            this.func_70661_as().func_75491_a(false);
            this.func_70661_as().func_75495_e(true);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIShipGuarding(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIShipFollowOwner(this));
            if (this.getStateFlag(3)) {
                this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIShipAttackOnCollide(this, 1.0));
            }
            this.field_70714_bg.func_75776_a(21, (EntityAIBase)new EntityAIShipOpenDoor(this, true));
            this.field_70714_bg.func_75776_a(22, (EntityAIBase)new EntityAIShipFloating(this));
            this.field_70714_bg.func_75776_a(25, (EntityAIBase)new EntityAIShipWander(this, 12, 7, 0.8));
        }
    }

    public boolean func_70097_a(DamageSource attacker, float atk) {
        if (attacker.func_76355_l() == "inWall") {
            return false;
        }
        if (attacker.func_76355_l() == "fall") {
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.host == null) {
                this.func_70106_y();
                return false;
            }
            if (this.host.getStateEmotion(1) != 3) {
                this.host.setStateEmotion(1, 3, true);
            }
            if (attacker.func_76346_g() != null) {
                Entity entity = attacker.func_76346_g();
                float dist = (float)this.func_70068_e(entity);
                if (EntityHelper.canDodge(this, dist)) {
                    return false;
                }
                if (entity.equals((Object)this)) {
                    return false;
                }
                if (entity instanceof EntityPlayer && !ConfigHandler.friendlyFire) {
                    return false;
                }
                float reduceAtk = atk * (1.0f - (this.getDefValue() - (float)this.field_70146_Z.nextInt(20) + 10.0f) * 0.01f);
                if (entity instanceof BasicEntityShip || entity instanceof BasicEntityAirplane || entity instanceof EntityRensouhou || entity instanceof BasicEntityMount) {
                    reduceAtk = reduceAtk * (float)ConfigHandler.dmgSummon * 0.01f;
                }
                if (entity instanceof IShipAttackBase) {
                    int modSet = this.field_70170_p.field_73011_w.isDaytime() ? 0 : 1;
                    reduceAtk = CalcHelper.calcDamageByType(reduceAtk, ((IShipAttackBase)entity).getDamageType(), this.getDamageType(), modSet);
                }
                if (reduceAtk < 0.0f) {
                    reduceAtk = 0.0f;
                }
                if (this.host != null) {
                    this.host.func_70904_g(false);
                }
                return super.func_70097_a(attacker, reduceAtk);
            }
        }
        return false;
    }

    protected void func_82167_n(Entity target) {
        if (target.equals((Object)this.field_70153_n) || target.equals((Object)this.riddenByEntity2) || target.equals((Object)this.field_70154_o) || target instanceof BasicEntityAirplane) {
            return;
        }
        target.func_70108_f((Entity)this);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && this.host != null) {
            if (itemstack.func_77973_b() == Items.field_151105_aU) {
                switch (this.host.getStateEmotion(0)) {
                    case 0: {
                        this.host.setStateEmotion(0, 1, true);
                        break;
                    }
                    case 1: {
                        this.host.setStateEmotion(0, 0, true);
                        this.setRiderNull();
                        break;
                    }
                    default: {
                        this.host.setStateEmotion(0, 0, true);
                    }
                }
                this.host.func_70634_a(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151058_ca && this.func_110164_bC()) {
                this.func_110162_b((Entity)player, true);
                return true;
            }
            if (itemstack.func_77973_b() == ModItems.PointerItem && !this.field_70170_p.field_72995_K && itemstack.func_77960_j() > 2) {
                int t = this.host.field_70173_aa - this.host.getMoraleTick();
                int m = this.host.getStateMinor(30);
                if (t > 3 && m < 6100) {
                    this.host.setMoraleTick(this.field_70173_aa);
                    this.host.setStateMinor(30, m + 3);
                }
                return true;
            }
        }
        if (this.func_110167_bD() && this.func_110166_bE() == player) {
            this.func_110160_i(true, !player.field_71075_bZ.field_75098_d);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_70093_af()) {
            if (this.riddenByEntity2 != null) {
                if (this.seat2 == null) {
                    EntityMountSeat seat = new EntityMountSeat(this.field_70170_p, this);
                    seat.field_70165_t = this.field_70165_t;
                    seat.field_70163_u = this.field_70163_u;
                    seat.field_70161_v = this.field_70161_v;
                    this.seat2 = seat;
                    this.field_70170_p.func_72838_d((Entity)seat);
                    player.func_70078_a((Entity)this.seat2);
                    this.riddenByEntity2 = player;
                    this.StateEmotion = 1;
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                    CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, 5), point);
                    return true;
                }
                if (EntityHelper.checkSameOwner((Entity)player, (Entity)this.host)) {
                    this.host.func_70904_g(!this.host.func_70906_o());
                    this.field_70703_bu = false;
                    this.func_70778_a(null);
                    this.func_70784_b(null);
                    this.host.func_70784_b(null);
                    this.func_70624_b(null);
                    this.setEntityTarget(null);
                    this.host.func_70624_b(null);
                    this.host.setEntityTarget(null);
                    return true;
                }
            } else {
                if (this.seat2 == null) {
                    EntityMountSeat seat = new EntityMountSeat(this.field_70170_p, this);
                    seat.field_70165_t = this.field_70165_t;
                    seat.field_70163_u = this.field_70163_u;
                    seat.field_70161_v = this.field_70161_v;
                    this.seat2 = seat;
                    this.field_70170_p.func_72838_d((Entity)seat);
                }
                player.func_70078_a((Entity)this.seat2);
                this.riddenByEntity2 = player;
                this.StateEmotion = 1;
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, 5), point);
                return true;
            }
        }
        if (player.func_70093_af() && !this.field_70170_p.field_72995_K && EntityHelper.checkSameOwner((Entity)player, (Entity)this.host)) {
            int eid = this.host.func_145782_y();
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ShinColle.instance, (int)0, (World)this.field_70170_p, (int)this.host.func_145782_y(), (int)0, (int)0);
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (stopAI) {
            return;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (stopAI) {
            return;
        }
        super.func_70071_h_();
        this.func_82168_bl();
        if (this.host != null && !this.host.getStateFlag(2) && this.seat2 != null && this.seat2.field_70153_n != null && this.keyPressed > 0) {
            EntityLivingBase rider2 = (EntityLivingBase)this.seat2.field_70153_n;
            float yaw = rider2.field_70759_as % 360.0f * ((float)Math.PI / 180);
            float pitch = rider2.field_70125_A % 360.0f * ((float)Math.PI / 180);
            this.applyMovement(pitch, yaw);
            this.field_70177_z = rider2.field_70177_z;
        }
        EntityHelper.checkDepth(this);
        if (this.field_70170_p.field_72995_K) {
            if (this.ShipDepth > 0.0) {
                double motX = this.field_70165_t - this.field_70169_q;
                double motZ = this.field_70161_v - this.field_70166_s;
                double parH = this.field_70163_u - (double)((int)this.field_70163_u);
                double limit = 0.25;
                if (motX > limit) {
                    motX = limit;
                } else if (motX < -limit) {
                    motX = -limit;
                }
                if (motZ > limit) {
                    motZ = limit;
                } else if (motZ < -limit) {
                    motZ = -limit;
                }
                if (motX != 0.0 || motZ != 0.0) {
                    ParticleHelper.spawnAttackParticleAt(this.field_70165_t + motX * 1.5, this.field_70163_u, this.field_70161_v + motZ * 1.5, -motX * 0.5, 0.0, -motZ * 0.5, (byte)15);
                }
            }
        } else if (this.host == null) {
            this.func_70106_y();
        } else {
            if (this.host.field_70154_o != this) {
                LogHelper.info("DEBUG : ride change " + this.field_70153_n);
                this.func_70106_y();
            }
            if (this.field_70173_aa % 8 == 0) {
                this.setEntityTarget(this.host.getEntityTarget());
                if (this.field_70173_aa % 16 == 0) {
                    if (EntityHelper.updateWaypointMove(this)) {
                        this.shipNavigator.tryMoveToXYZ(this.getGuardedPos(0), this.getGuardedPos(1), this.getGuardedPos(2), 1.0);
                        this.host.sendSyncPacket(15, true);
                    }
                    if (this.field_70173_aa % 128 == 0) {
                        this.sendSyncPacket();
                        this.atkRange = this.host.getStateFinal(5);
                        this.movSpeed = this.host.func_70906_o() ? 0.0f : this.host.getStateFinal(4);
                        this.setupAttrs();
                        if (this.func_70090_H()) {
                            this.func_70050_g(300);
                        }
                    }
                }
            }
        }
    }

    private void applyMovement(float pitch, float yaw) {
        float[] movez = ParticleHelper.rotateXZByAxis(this.movSpeed, 0.0f, yaw, 1.0f);
        float[] movex = ParticleHelper.rotateXZByAxis(0.0f, this.movSpeed, yaw, 1.0f);
        if (this.field_70122_E || EntityHelper.checkEntityIsInLiquid((Entity)this)) {
            if ((this.keyPressed & 1) > 0) {
                this.field_70159_w += (double)(movez[1] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movez[1])) {
                    this.field_70159_w = movez[1];
                }
                this.field_70179_y += (double)(movez[0] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movez[0])) {
                    this.field_70179_y = movez[0];
                }
            }
            if ((this.keyPressed & 2) > 0) {
                this.field_70159_w -= (double)(movez[1] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movez[1])) {
                    this.field_70159_w = -movez[1];
                }
                this.field_70179_y -= (double)(movez[0] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movez[0])) {
                    this.field_70179_y = -movez[0];
                }
            }
            if ((this.keyPressed & 4) > 0) {
                this.field_70159_w += (double)(movex[1] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movex[1])) {
                    this.field_70159_w = movex[1];
                }
                this.field_70179_y += (double)(movex[0] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movex[0])) {
                    this.field_70179_y = movex[0];
                }
            }
            if ((this.keyPressed & 8) > 0) {
                this.field_70159_w -= (double)(movex[1] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movex[1])) {
                    this.field_70159_w = -movex[1];
                }
                this.field_70179_y -= (double)(movex[0] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movex[0])) {
                    this.field_70179_y = -movex[0];
                }
            }
            if (pitch > 0.5f) {
                this.field_70181_x += (double)-0.1f;
                if (this.field_70181_x < (double)(-this.movSpeed / 2.0f)) {
                    this.field_70181_x = -this.movSpeed / 2.0f;
                }
            }
            if (pitch < -1.0f) {
                this.field_70181_x += (double)0.1f;
                if (this.field_70181_x > (double)(this.movSpeed / 2.0f)) {
                    this.field_70181_x = this.movSpeed / 2.0f;
                }
            }
            if (this.field_70123_F) {
                this.field_70181_x += 0.4;
            }
            if ((this.keyPressed & 0x10) > 0) {
                this.field_70181_x += (double)(this.movSpeed * 2.0f);
                if (this.field_70181_x > 1.0) {
                    this.field_70181_x = 1.0;
                }
                this.keyPressed -= 16;
            }
        } else {
            if ((this.keyPressed & 1) > 0) {
                this.field_70159_w += (double)(movez[1] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movez[1])) {
                    this.field_70159_w = movez[1];
                }
                this.field_70179_y += (double)(movez[0] / 4.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movez[0])) {
                    this.field_70179_y = movez[0];
                }
            }
            if ((this.keyPressed & 2) > 0) {
                this.field_70159_w -= (double)(movez[1] / 16.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movez[1])) {
                    this.field_70159_w = -movez[1];
                }
                this.field_70179_y -= (double)(movez[0] / 16.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movez[0])) {
                    this.field_70179_y = -movez[0];
                }
            }
            if ((this.keyPressed & 4) > 0) {
                this.field_70159_w += (double)(movex[1] / 32.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movex[1])) {
                    this.field_70159_w = movex[1];
                }
                this.field_70179_y += (double)(movex[0] / 32.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movex[0])) {
                    this.field_70179_y = movex[0];
                }
            }
            if ((this.keyPressed & 8) > 0) {
                this.field_70159_w -= (double)(movex[1] / 32.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70159_w)) > MathHelper.func_76135_e((float)movex[1])) {
                    this.field_70159_w = -movex[1];
                }
                this.field_70179_y -= (double)(movex[0] / 32.0f);
                if (MathHelper.func_76135_e((float)((float)this.field_70179_y)) > MathHelper.func_76135_e((float)movex[0])) {
                    this.field_70179_y = -movex[0];
                }
            }
        }
    }

    @Override
    public byte getStateEmotion(int id) {
        return id == 1 ? this.StateEmotion : this.StateEmotion2;
    }

    @Override
    public void setStateEmotion(int id, int value, boolean sync) {
        switch (id) {
            case 1: {
                this.StateEmotion = (byte)value;
                break;
            }
            case 2: {
                this.StateEmotion2 = (byte)value;
                break;
            }
        }
        if (sync && !this.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0);
            CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, 4), point);
        }
    }

    @Override
    public void setShipDepth(double par1) {
        this.ShipDepth = par1;
    }

    @Override
    public boolean getStateFlag(int flag) {
        if (this.host != null) {
            return this.host.getStateFlag(flag);
        }
        return false;
    }

    @Override
    public void setStateFlag(int id, boolean flag) {
        if (this.host != null) {
            this.host.setStateFlag(id, flag);
        }
    }

    @Override
    public int getFaceTick() {
        return this.StartEmotion;
    }

    @Override
    public int getHeadTiltTick() {
        return this.StartEmotion2;
    }

    @Override
    public void setFaceTick(int par1) {
        this.StartEmotion = par1;
    }

    @Override
    public void setHeadTiltTick(int par1) {
        this.StartEmotion2 = par1;
    }

    @Override
    public int getTickExisted() {
        return this.field_70173_aa;
    }

    @Override
    public int getAttackTime() {
        return this.field_70724_aR;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
    }

    protected void clearAITargetTasks() {
        this.field_70715_bh.field_75782_a.clear();
    }

    @Override
    public Entity getEntityTarget() {
        return this.atkTarget;
    }

    @Override
    public void setEntityTarget(Entity target) {
        this.atkTarget = target;
    }

    public boolean func_70652_k(Entity target) {
        float atk = this.host.getStateFinal(1);
        this.host.addShipExp(ConfigHandler.expGain[0]);
        this.host.setCombatTick(this.field_70173_aa);
        boolean isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), atk);
        if (this.func_70681_au().nextInt(10) > 8) {
            this.func_85030_a("shincolle:ship-waka_attack", ConfigHandler.volumeShip * 0.5f, 1.0f);
        }
        if (isTargetHurt && !this.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(target, 1, false), point);
        }
        if (this.host != null) {
            this.host.applyEmotesReaction(3);
            if (ConfigHandler.canFlare) {
                this.host.flareTarget(target);
            }
        }
        return isTargetHurt;
    }

    @Override
    public boolean attackEntityWithAmmo(Entity target) {
        float atkLight = CalcHelper.calcDamageBySpecialEffect(this, target, this.host.getStateFinal(1), 0);
        this.func_85030_a("shincolle:ship-firesmall", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (this.field_70146_Z.nextInt(10) > 8) {
            this.func_85030_a("shincolle:ship-waka_attack", ConfigHandler.volumeShip * 0.5f, 1.0f);
        }
        float distX = (float)(target.field_70165_t - this.field_70165_t);
        float distY = (float)(target.field_70163_u - this.field_70163_u);
        float distZ = (float)(target.field_70161_v - this.field_70161_v);
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        distX /= distSqrt;
        distY /= distSqrt;
        distZ /= distSqrt;
        this.host.addShipExp(ConfigHandler.expGain[1]);
        this.host.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[0]);
        this.host.setCombatTick(this.field_70173_aa);
        if (!this.host.decrAmmoNum(0, this.host.getAmmoConsumption())) {
            return false;
        }
        NetworkRegistry.TargetPoint point0 = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 19, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, distX, 1.2f, distZ, true), point0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 0, true), point0);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, 64.0);
        float missChance = 0.2f + 0.15f * (distSqrt / this.host.getStateFinal(5)) - 0.001f * (float)this.host.getLevel();
        missChance -= this.host.getEffectEquip(3);
        if (missChance > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            atkLight = 0.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 10, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(0)) {
            atkLight *= 1.5f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 11, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(1)) {
            atkLight *= 2.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 12, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(2)) {
            atkLight *= 3.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 13, false), point);
        }
        if (target instanceof EntityPlayer) {
            atkLight *= 0.25f;
            if (!ConfigHandler.friendlyFire) {
                atkLight = 0.0f;
            } else if (atkLight > 59.0f) {
                atkLight = 59.0f;
            }
        }
        boolean isTargetHurt = false;
        if (this.host != null) {
            isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.host).func_76349_b(), atkLight);
        }
        if (isTargetHurt) {
            NetworkRegistry.TargetPoint point1 = new NetworkRegistry.TargetPoint(this.field_71093_bK, target.field_70165_t, target.field_70163_u, target.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(target, 9, false), point1);
        }
        if (this.host != null) {
            this.host.applyEmotesReaction(3);
            if (ConfigHandler.canFlare) {
                this.host.flareTarget(target);
            }
        }
        return isTargetHurt;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float atkHeavy = this.host.getStateFinal(6);
        float kbValue = 0.08f;
        this.func_85030_a("shincolle:ship-fireheavy", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (this.field_70146_Z.nextInt(10) > 8) {
            this.func_85030_a("shincolle:ship-waka_attack", ConfigHandler.volumeShip * 0.5f, 1.0f);
        }
        boolean isDirect = false;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        float distX = tarX - (float)this.field_70165_t;
        float distY = tarY - (float)this.field_70163_u;
        float distZ = tarZ - (float)this.field_70161_v;
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        float launchPos = (float)this.field_70163_u + this.field_70131_O * 0.7f;
        if (distX * distX + distY * distY + distZ * distZ < 36.0f) {
            isDirect = true;
        }
        if (this.func_70090_H()) {
            isDirect = true;
            launchPos = (float)this.field_70163_u;
        }
        this.host.addShipExp(ConfigHandler.expGain[2]);
        this.host.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[1]);
        this.host.setCombatTick(this.field_70173_aa);
        if (!this.host.decrAmmoNum(1, this.host.getAmmoConsumption())) {
            return false;
        }
        float missChance = 0.2f + 0.15f * (distSqrt / this.host.getEffectEquip(1)) - 0.001f * (float)this.host.getLevel();
        if ((missChance -= this.host.getEffectEquip(3)) > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            tarX = tarX - 5.0f + this.field_70146_Z.nextFloat() * 10.0f;
            tarY += this.field_70146_Z.nextFloat() * 5.0f;
            tarZ = tarZ - 5.0f + this.field_70146_Z.nextFloat() * 10.0f;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host, 10, false), point);
        }
        EntityAbyssMissile missile = new EntityAbyssMissile(this.field_70170_p, (IShipAttackBase)this.host, tarX, tarY + target.field_70131_O * 0.2f, tarZ, launchPos, atkHeavy, kbValue, isDirect, -1.0f);
        this.field_70170_p.func_72838_d((Entity)missile);
        if (this.host != null) {
            this.host.applyEmotesReaction(3);
            if (ConfigHandler.canFlare) {
                this.host.flareTarget(target);
            }
        }
        return true;
    }

    public void func_70612_e(float movX, float movZ) {
        double d0;
        if (EntityHelper.checkEntityIsInLiquid((Entity)this)) {
            d0 = this.field_70163_u;
            this.func_70060_a(movX, movZ, this.movSpeed * 0.4f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + 0.6 - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3;
            }
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float f4 = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
            this.func_70060_a(movX, movZ, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            if (this.func_70617_f_()) {
                boolean flag;
                float f5 = 0.15f;
                if (this.field_70159_w < (double)(-f5)) {
                    this.field_70159_w = -f5;
                }
                if (this.field_70159_w > (double)f5) {
                    this.field_70159_w = f5;
                }
                if (this.field_70179_y < (double)(-f5)) {
                    this.field_70179_y = -f5;
                }
                if (this.field_70179_y > (double)f5) {
                    this.field_70179_y = f5;
                }
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
                if ((flag = this.func_70093_af()) && this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.4;
            }
            this.field_70181_x = !(!this.field_70170_p.field_72995_K || this.field_70170_p.func_72899_e((int)this.field_70165_t, 0, (int)this.field_70161_v) && this.field_70170_p.func_72938_d((int)((int)this.field_70165_t), (int)((int)this.field_70161_v)).field_76636_d) ? (this.field_70163_u > 0.0 ? -0.1 : 0.0) : (this.field_70181_x -= 0.08);
            this.field_70181_x *= 0.98;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ += (f6 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Override
    public int getLevel() {
        if (this.host != null) {
            return this.host.getLevel();
        }
        return 150;
    }

    @Override
    public float getAttackSpeed() {
        if (this.host != null) {
            return this.host.getStateFinal(3);
        }
        return 0.0f;
    }

    @Override
    public float getAttackRange() {
        if (this.host != null) {
            return this.host.getStateFinal(5);
        }
        return 0.0f;
    }

    @Override
    public float getMoveSpeed() {
        if (this.host != null) {
            return this.host.getStateFinal(4);
        }
        return 0.0f;
    }

    @Override
    public boolean getIsLeashed() {
        if (this.host != null) {
            return this.host.getIsLeashed() || this.func_110167_bD();
        }
        return false;
    }

    @Override
    public int getStateMinor(int id) {
        if (this.host != null) {
            return this.host.getStateMinor(id);
        }
        return 0;
    }

    @Override
    public void setStateMinor(int state, int par1) {
        if (this.host != null) {
            this.host.setStateMinor(state, par1);
        }
    }

    @Override
    public int getAmmoLight() {
        if (this.host != null) {
            return this.host.getStateMinor(4);
        }
        return 0;
    }

    @Override
    public int getAmmoHeavy() {
        if (this.host != null) {
            return this.host.getStateMinor(5);
        }
        return 0;
    }

    @Override
    public boolean useAmmoLight() {
        if (this.host != null) {
            return this.host.useAmmoLight();
        }
        return true;
    }

    @Override
    public boolean useAmmoHeavy() {
        if (this.host != null) {
            return this.host.useAmmoHeavy();
        }
        return true;
    }

    @Override
    public boolean hasAmmoLight() {
        return this.getAmmoLight() > 0;
    }

    @Override
    public boolean hasAmmoHeavy() {
        return this.getAmmoHeavy() > 0;
    }

    @Override
    public void setAmmoLight(int num) {
    }

    @Override
    public void setAmmoHeavy(int num) {
    }

    @Override
    public float getAttackDamage() {
        return 0.0f;
    }

    @Override
    public boolean getAttackType(int par1) {
        if (this.host != null) {
            return this.host.getAttackType(par1);
        }
        return true;
    }

    @Override
    public float getEffectEquip(int id) {
        if (this.host != null) {
            return this.host.getEffectEquip(id);
        }
        return 0.0f;
    }

    @Override
    public float getDefValue() {
        if (this.host != null) {
            return this.host.getStateFinal(2) * 0.5f;
        }
        return 0.0f;
    }

    @Override
    public boolean getIsRiding() {
        return false;
    }

    @Override
    public boolean getIsSprinting() {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        if (this.host != null) {
            return this.host.getIsSitting();
        }
        return false;
    }

    @Override
    public boolean getIsSneaking() {
        return false;
    }

    @Override
    public double getShipDepth() {
        return this.ShipDepth;
    }

    @Override
    public EntityLivingBase getRiddenByEntity() {
        return (EntityLivingBase)this.field_70153_n;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public ShipPathNavigate getShipNavigate() {
        return this.shipNavigator;
    }

    @Override
    public ShipMoveHelper getShipMoveHelper() {
        return this.shipMoveHelper;
    }

    protected void func_70619_bc() {
        if (stopAI) {
            return;
        }
        super.func_70619_bc();
        EntityHelper.updateShipNavigator(this);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public float[] getRidePos() {
        return this.ridePos;
    }

    public void setRiderNull() {
        if (this.seat2 != null) {
            this.seat2.setRiderNull();
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70154_o = null;
            this.field_70153_n = null;
        }
        this.riddenByEntity2 = null;
        this.func_70106_y();
    }

    public void setupAttrs() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.host.getStateFinal(0) * 0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(this.host.getStateFinal(5) + 32.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)this.host.getLevel() / 150.0);
    }

    @Override
    public void setEntitySit() {
        if (this.host != null) {
            this.host.setEntitySit();
        }
    }

    public void sendSyncPacket() {
        if (!this.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 48.0);
            CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, 7), point);
        }
    }

    @Override
    public Entity getGuardedEntity() {
        if (this.host != null) {
            return this.host.getGuardedEntity();
        }
        return null;
    }

    @Override
    public void setGuardedEntity(Entity entity) {
        if (this.host != null) {
            this.host.setGuardedEntity(entity);
        }
    }

    @Override
    public int getGuardedPos(int vec) {
        if (this.host != null) {
            return this.host.getGuardedPos(vec);
        }
        return -1;
    }

    @Override
    public void setGuardedPos(int x, int y, int z, int dim, int type) {
        if (this.host != null) {
            this.host.setGuardedPos(x, y, z, dim, type);
        }
    }

    @Override
    public float getModelRotate(int par1) {
        return 0.0f;
    }

    @Override
    public void setModelRotate(int par1, float par2) {
    }

    @Override
    public int getPlayerUID() {
        if (this.host != null) {
            return this.host.getPlayerUID();
        }
        return -1;
    }

    @Override
    public void setPlayerUID(int uid) {
    }

    @Override
    public Entity getHostEntity() {
        return this.host;
    }

    @Override
    public Entity getEntityRevengeTarget() {
        return this.rvgTarget;
    }

    @Override
    public int getEntityRevengeTime() {
        return this.revengeTime;
    }

    @Override
    public void setEntityRevengeTarget(Entity target) {
        this.rvgTarget = target;
    }

    @Override
    public void setEntityRevengeTime() {
        this.revengeTime = this.field_70173_aa;
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n != null) {
            ((EntityLivingBase)this.field_70153_n).field_70759_as = this.field_70759_as;
            ((EntityLivingBase)this.field_70153_n).field_70126_B = this.field_70126_B;
            ((EntityLivingBase)this.field_70153_n).field_70177_z = this.field_70177_z;
            ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            if (this.riddenByEntity2 != null && this.keyPressed != 0) {
                this.field_70759_as = this.riddenByEntity2.field_70759_as;
                this.field_70126_B = this.riddenByEntity2.field_70126_B;
                this.field_70177_z = this.riddenByEntity2.field_70177_z;
                this.field_70761_aq = this.riddenByEntity2.field_70761_aq;
                ((EntityLivingBase)this.field_70153_n).field_70759_as = this.field_70759_as;
                ((EntityLivingBase)this.field_70153_n).field_70126_B = this.field_70126_B;
                ((EntityLivingBase)this.field_70153_n).field_70177_z = this.field_70177_z;
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
                this.getShipNavigate().clearPathEntity();
            }
        }
    }

    @Override
    public int getAttackAniTick() {
        return this.StartEmotion3;
    }

    @Override
    public void setAttackAniTick(int par1) {
        this.StartEmotion3 = par1;
    }

    @Override
    public float getSwingTime(float partialTick) {
        return this.func_70678_g(partialTick);
    }

    protected void func_82168_bl() {
        int swingMaxTick = 6;
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= swingMaxTick) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)swingMaxTick;
    }

    @Override
    public int[] getLastWaypoint() {
        return new int[]{this.getStateMinor(40), this.getStateMinor(41), this.getStateMinor(42)};
    }

    @Override
    public void setLastWaypoint(int[] pos) {
        if (pos != null) {
            this.setStateMinor(40, pos[0]);
            this.setStateMinor(41, pos[1]);
            this.setStateMinor(42, pos[2]);
        }
    }

    @Override
    public int getWpStayTime() {
        if (this.host != null) {
            return this.host.getStateTimer(4);
        }
        return 0;
    }

    @Override
    public int getWpStayTimeMax() {
        if (this.host != null) {
            return BasicEntityShip.wpStayTime2Ticks(this.getStateMinor(44));
        }
        return 0;
    }

    @Override
    public void setWpStayTime(int time) {
        if (this.host != null) {
            this.host.setStateTimer(4, time);
        }
    }
}

