/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.crafting;

import com.lulan.shincolle.crafting.EquipCalc;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.TileEntityHelper;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SmallRecipes {
    private static Random rand = new Random();
    public static final int minAmount = 16;
    private static final int basePower = 57600;
    private static final int powerPerMat = 2100;

    public static boolean canRecipeBuild(int[] matAmount) {
        return matAmount[0] >= 16 && matAmount[1] >= 16 && matAmount[2] >= 16 && matAmount[3] >= 16;
    }

    public static int calcGoalPower(int[] matAmount) {
        if (SmallRecipes.canRecipeBuild(matAmount)) {
            int extraAmount = matAmount[0] + matAmount[1] + matAmount[2] + matAmount[3] - 64;
            return 57600 + 2100 * extraAmount;
        }
        return 0;
    }

    public static boolean isMaterial(ItemStack itemstack) {
        if (itemstack != null) {
            Item item = itemstack.func_77973_b();
            int meta = itemstack.func_77960_j();
            return item == ModItems.Grudge || item == ModItems.AbyssMetal && meta == 0 || item == ModItems.Ammo && meta == 0 || item == ModItems.AbyssMetal && meta == 1;
        }
        return false;
    }

    public static int getMaterialType(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        int meta = itemstack.func_77960_j();
        int itemID = -1;
        if (item == ModItems.Grudge) {
            itemID = 0;
        } else if (item == ModItems.AbyssMetal && meta == 0) {
            itemID = 1;
        } else if (item == ModItems.Ammo && meta == 0) {
            itemID = 2;
        } else if (item == ModItems.AbyssMetal && meta == 1) {
            itemID = 3;
        } else if (TileEntityHelper.getItemFuelValue(itemstack) > 0) {
            itemID = 4;
        } else if (item == ModItems.InstantConMat) {
            itemID = 4;
        }
        return itemID;
    }

    public static int[] getMaterialAmount(ItemStack[] item) {
        int[] itemAmount = new int[4];
        for (int i = 0; i < 4; ++i) {
            itemAmount[i] = item[i] != null ? item[i].field_77994_a : 0;
        }
        return itemAmount;
    }

    public static ItemStack getBuildResultShip(int[] matAmount) {
        ItemStack buildResult = new ItemStack((Item)ModItems.ShipSpawnEgg);
        buildResult.func_77964_b(0);
        buildResult.field_77990_d = new NBTTagCompound();
        buildResult.field_77990_d.func_74774_a("Grudge", (byte)matAmount[0]);
        buildResult.field_77990_d.func_74774_a("Abyssium", (byte)matAmount[1]);
        buildResult.field_77990_d.func_74774_a("Ammo", (byte)matAmount[2]);
        buildResult.field_77990_d.func_74774_a("Polymetal", (byte)matAmount[3]);
        return buildResult;
    }

    public static ItemStack getBuildResultEquip(int[] matAmount) {
        ItemStack buildResult = null;
        int totalMats = matAmount[0] + matAmount[1] + matAmount[2] + matAmount[3];
        int[] matsInt = new int[]{0, 0, 0, 0};
        int rollType = -1;
        float equipRate = (float)totalMats / 128.0f;
        float randRate = rand.nextFloat();
        if (equipRate > 1.0f) {
            equipRate = 1.0f;
        }
        LogHelper.info("DEBUG : equip build roll: rate / random " + String.format("%.2f", Float.valueOf(equipRate)) + " " + String.format("%.2f", Float.valueOf(randRate)));
        if (randRate < equipRate) {
            matsInt[0] = matAmount[0];
            matsInt[1] = matAmount[1];
            matsInt[2] = matAmount[2];
            matsInt[3] = matAmount[3];
            rollType = EquipCalc.rollEquipType(0, matsInt);
            return EquipCalc.rollEquipsOfTheType(rollType, totalMats, 0);
        }
        buildResult = rand.nextInt(2) == 0 ? new ItemStack((Item)ModItems.Ammo, 11 + rand.nextInt(11), 1) : new ItemStack((Item)ModItems.Ammo, 2 + rand.nextInt(2), 3);
        return buildResult;
    }
}

