/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.crafting;

import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class ShipCalc {
    private static Random rand = new Random();
    private static final float[] baseRate = new float[]{64.0f, 16.0f, 4.0f, 1.0f};
    private static List<int[]> EquipSmall = new ArrayList<int[]>();
    private static List<int[]> EquipLarge = new ArrayList<int[]>();

    private static int[] getMatAmount(ItemStack itemstack) {
        int[] matAmount = new int[]{0, 0, 0, 0};
        if (itemstack.func_77942_o()) {
            matAmount[0] = itemstack.func_77978_p().func_74762_e("Grudge");
            matAmount[1] = itemstack.func_77978_p().func_74762_e("Abyssium");
            matAmount[2] = itemstack.func_77978_p().func_74762_e("Ammo");
            matAmount[3] = itemstack.func_77978_p().func_74762_e("Polymetal");
        }
        LogHelper.info("DEBUG : shipcalc get matAmount : " + matAmount[0] + " " + matAmount[1] + " " + matAmount[2] + " " + matAmount[3]);
        return matAmount;
    }

    public static int rollShipType(ItemStack item) {
        ArrayList shipList = new ArrayList();
        int[] material = new int[4];
        int totalMats = 0;
        if (item.func_77960_j() > 1) {
            return item.func_77960_j() - 2;
        }
        if (item.field_77990_d != null) {
            material[0] = item.field_77990_d.func_74762_e("Grudge");
            material[1] = item.field_77990_d.func_74762_e("Abyssium");
            material[2] = item.field_77990_d.func_74762_e("Ammo");
            material[3] = item.field_77990_d.func_74762_e("Polymetal");
            totalMats = material[0] + material[1] + material[2] + material[3];
        }
        List<int[]> shiplistOrg = null;
        float te = 4000.0f;
        if (item.func_77960_j() == 0) {
            shiplistOrg = EquipSmall;
            te = 256.0f;
        } else {
            shiplistOrg = EquipLarge;
        }
        HashMap<Integer, Float> probList = new HashMap<Integer, Float>();
        int meanNew = 0;
        int meanDist = 0;
        float prob = 0.0f;
        for (int[] i : shiplistOrg) {
            meanNew = i[2] >= 0 && i[2] <= 3 ? i[1] - material[i[2]] : i[1];
            meanDist = MathHelper.func_76130_a((int)(totalMats - meanNew));
            if (item.func_77960_j() == 0) {
                meanDist = (int)((float)meanDist * 15.625f);
            }
            prob = CalcHelper.getNormDist(meanDist);
            probList.put(i[0], Float.valueOf(prob));
            LogHelper.info("DEBUG: roll ship type: prob list: ID " + i[0] + " MEAN(ORG) " + i[1] + " MEAN(NEW) " + meanNew + " MEAN(P) " + (float)meanNew / te + " MD " + meanDist + " PR " + prob);
        }
        float random = rand.nextFloat();
        float totalProb = 0.0f;
        float sumProb = 0.0125f;
        int rollresult = -1;
        for (Map.Entry entry : probList.entrySet()) {
            totalProb += ((Float)entry.getValue()).floatValue();
        }
        random *= totalProb;
        for (Map.Entry entry : probList.entrySet()) {
            LogHelper.info("DEBUG: roll ship type: random: " + random + " sum.pr " + (sumProb += ((Float)entry.getValue()).floatValue()) + " total.pr " + totalProb);
            if (!(sumProb > random)) continue;
            rollresult = (Integer)entry.getKey();
            LogHelper.info("DEBUG: roll ship type: get ship:" + rollresult);
            break;
        }
        return rollresult;
    }

    public static String getEntityToSpawnName(int type) {
        switch (type) {
            case 0: {
                return "shincolle.EntityDestroyerI";
            }
            case 1: {
                return "shincolle.EntityDestroyerRo";
            }
            case 2: {
                return "shincolle.EntityDestroyerHa";
            }
            case 3: {
                return "shincolle.EntityDestroyerNi";
            }
            case 9: {
                return "shincolle.EntityHeavyCruiserRi";
            }
            case 10: {
                return "shincolle.EntityHeavyCruiserNe";
            }
            case 12: {
                return "shincolle.EntityCarrierWo";
            }
            case 14: {
                return "shincolle.EntityBattleshipTa";
            }
            case 15: {
                return "shincolle.EntityBattleshipRe";
            }
            case 16: {
                return "shincolle.EntityTransportWa";
            }
            case 17: {
                return "shincolle.EntitySubmKa";
            }
            case 18: {
                return "shincolle.EntitySubmYo";
            }
            case 19: {
                return "shincolle.EntitySubmSo";
            }
            case 21: {
                return "shincolle.EntityAirfieldHime";
            }
            case 20: {
                return "shincolle.EntityCarrierHime";
            }
            case 26: {
                return "shincolle.EntityBattleshipHime";
            }
            case 28: {
                return "shincolle.EntityHarbourHime";
            }
            case 31: {
                return "shincolle.EntityNorthernHime";
            }
            case 33: {
                return "shincolle.EntityCarrierWD";
            }
            case 36: {
                return "shincolle.EntityDestroyerShimakaze";
            }
            case 2036: {
                return "shincolle.EntityDestroyerShimakazeBoss";
            }
            case 37: {
                return "shincolle.EntityBattleshipNGT";
            }
            case 2037: {
                return "shincolle.EntityBattleshipNGTBoss";
            }
            case 46: {
                return "shincolle.EntityBattleshipYMT";
            }
            case 2046: {
                return "shincolle.EntityBattleshipYMTBoss";
            }
            case 38: {
                return "shincolle.EntitySubmU511";
            }
            case 2038: {
                return "shincolle.EntitySubmU511Mob";
            }
            case 39: {
                return "shincolle.EntitySubmRo500";
            }
            case 2039: {
                return "shincolle.EntitySubmRo500Mob";
            }
            case 47: {
                return "shincolle.EntityCarrierKaga";
            }
            case 2047: {
                return "shincolle.EntityCarrierKagaBoss";
            }
            case 48: {
                return "shincolle.EntityCarrierAkagi";
            }
            case 2048: {
                return "shincolle.EntityCarrierAkagiBoss";
            }
            case 51: {
                return "shincolle.EntityDestroyerAkatsuki";
            }
            case 2051: {
                return "shincolle.EntityDestroyerAkatsukiMob";
            }
            case 52: {
                return "shincolle.EntityDestroyerHibiki";
            }
            case 2052: {
                return "shincolle.EntityDestroyerHibikiMob";
            }
            case 53: {
                return "shincolle.EntityDestroyerIkazuchi";
            }
            case 2053: {
                return "shincolle.EntityDestroyerIkazuchiMob";
            }
            case 54: {
                return "shincolle.EntityDestroyerInazuma";
            }
            case 2054: {
                return "shincolle.EntityDestroyerInazumaMob";
            }
        }
        return "shincolle.EntityDestroyerI";
    }

    public static String getRandomMobToSpawnName(int type) {
        switch (type) {
            case 2: {
                switch (rand.nextInt(2)) {
                    default: 
                }
                return ShipCalc.getEntityToSpawnName(2036);
            }
            case 3: {
                switch (rand.nextInt(4)) {
                    case 1: {
                        return ShipCalc.getEntityToSpawnName(2047);
                    }
                    case 2: {
                        return ShipCalc.getEntityToSpawnName(2048);
                    }
                    case 3: {
                        return ShipCalc.getEntityToSpawnName(2046);
                    }
                }
                return ShipCalc.getEntityToSpawnName(2037);
            }
        }
        switch (rand.nextInt(6)) {
            case 1: {
                return ShipCalc.getEntityToSpawnName(2039);
            }
            case 2: {
                return ShipCalc.getEntityToSpawnName(2053);
            }
            case 3: {
                return ShipCalc.getEntityToSpawnName(2054);
            }
            case 4: {
                return ShipCalc.getEntityToSpawnName(2051);
            }
            case 5: {
                return ShipCalc.getEntityToSpawnName(2052);
            }
        }
        return ShipCalc.getEntityToSpawnName(2038);
    }

    public static ItemStack[] getKaitaiItems(int shipID) {
        ItemStack[] amount = new ItemStack[4];
        switch (shipID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                amount[0] = new ItemStack((Item)ModItems.Grudge, 12 + rand.nextInt(8));
                amount[1] = new ItemStack((Item)ModItems.AbyssMetal, 12 + rand.nextInt(8), 0);
                amount[2] = new ItemStack((Item)ModItems.Ammo, 12 + rand.nextInt(8), 0);
                amount[3] = new ItemStack((Item)ModItems.AbyssMetal, 12 + rand.nextInt(8), 1);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                if (ConfigHandler.easyMode) {
                    amount[0] = new ItemStack(ModBlocks.BlockGrudge, 1);
                    amount[1] = new ItemStack(ModBlocks.BlockAbyssium, 1);
                    amount[2] = new ItemStack((Item)ModItems.Ammo, 1, 1);
                    amount[3] = new ItemStack(ModBlocks.BlockPolymetal, 1);
                    break;
                }
                amount[0] = new ItemStack(ModBlocks.BlockGrudge, 10 + rand.nextInt(3));
                amount[1] = new ItemStack(ModBlocks.BlockAbyssium, 10 + rand.nextInt(3));
                amount[2] = new ItemStack((Item)ModItems.Ammo, 10 + rand.nextInt(3), 1);
                amount[3] = new ItemStack(ModBlocks.BlockPolymetal, 10 + rand.nextInt(3));
                break;
            }
            case 38: 
            case 39: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                amount[0] = new ItemStack((Item)ModItems.Grudge, ConfigHandler.kaitaiAmountSmall + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountSmall * 0.25f) + 1));
                amount[1] = new ItemStack((Item)ModItems.AbyssMetal, ConfigHandler.kaitaiAmountSmall + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountSmall * 0.25f) + 1), 0);
                amount[2] = new ItemStack((Item)ModItems.Ammo, ConfigHandler.kaitaiAmountSmall + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountSmall * 0.25f) + 1), 0);
                amount[3] = new ItemStack((Item)ModItems.AbyssMetal, ConfigHandler.kaitaiAmountSmall + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountSmall * 0.25f) + 1), 1);
                break;
            }
            case 36: 
            case 56: {
                amount[0] = new ItemStack(ModBlocks.BlockGrudge, ConfigHandler.kaitaiAmountLarge + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountLarge * 0.25f) + 1));
                amount[1] = new ItemStack(ModBlocks.BlockAbyssium, ConfigHandler.kaitaiAmountLarge + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountLarge * 0.25f) + 1));
                amount[2] = new ItemStack((Item)ModItems.Ammo, ConfigHandler.kaitaiAmountLarge + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountLarge * 0.25f) + 1), 1);
                amount[3] = new ItemStack(ModBlocks.BlockPolymetal, ConfigHandler.kaitaiAmountLarge + rand.nextInt((int)((float)ConfigHandler.kaitaiAmountLarge * 0.25f) + 1));
                break;
            }
            case 37: 
            case 46: 
            case 47: 
            case 48: {
                amount[0] = new ItemStack(ModBlocks.BlockGrudge, ConfigHandler.kaitaiAmountLarge + rand.nextInt(ConfigHandler.kaitaiAmountLarge + 1));
                amount[1] = new ItemStack(ModBlocks.BlockAbyssium, ConfigHandler.kaitaiAmountLarge + rand.nextInt(ConfigHandler.kaitaiAmountLarge + 1));
                amount[2] = new ItemStack((Item)ModItems.Ammo, ConfigHandler.kaitaiAmountLarge + rand.nextInt(ConfigHandler.kaitaiAmountLarge + 1), 1);
                amount[3] = new ItemStack(ModBlocks.BlockPolymetal, ConfigHandler.kaitaiAmountLarge + rand.nextInt(ConfigHandler.kaitaiAmountLarge + 1));
            }
        }
        return amount;
    }

    static {
        EquipSmall.add(new int[]{0, 80, 0});
        EquipSmall.add(new int[]{1, 90, 0});
        EquipSmall.add(new int[]{2, 100, 0});
        EquipSmall.add(new int[]{3, 110, 0});
        EquipSmall.add(new int[]{16, 120, 1});
        EquipSmall.add(new int[]{17, 140, 2});
        EquipSmall.add(new int[]{18, 160, 2});
        EquipSmall.add(new int[]{19, 180, 2});
        EquipSmall.add(new int[]{9, 200, 2});
        EquipSmall.add(new int[]{10, 256, 2});
        EquipLarge.add(new int[]{12, 500, 3});
        EquipLarge.add(new int[]{14, 800, 2});
        EquipLarge.add(new int[]{31, 2600, 1});
        EquipLarge.add(new int[]{28, 2800, 1});
        EquipLarge.add(new int[]{21, 3000, 1});
        EquipLarge.add(new int[]{20, 3000, 3});
        EquipLarge.add(new int[]{15, 3800, 2});
        EquipLarge.add(new int[]{26, 4600, 2});
        EquipLarge.add(new int[]{33, 5000, 3});
    }
}

