/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.client.particle;

import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EntityFXStickyLightning
extends EntityFX {
    private int particleType;
    private Entity host;
    private int numStem;
    private double[][] prevShape;
    private float scaleX;
    private float scaleZ;
    private float scaleY;
    private float stemWidth;

    public EntityFXStickyLightning(World world, Entity entity, float scale, int life, int type) {
        super(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0);
        this.host = entity;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70544_f = scale;
        this.field_70145_X = true;
        this.particleType = type;
        switch (type) {
            case 1: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.5f;
                this.field_70551_j = 0.7f;
                this.field_82339_as = 1.0f;
                this.field_70547_e = life;
                this.numStem = 4;
                this.scaleX = 0.5f + this.host.field_70130_N * 0.5f;
                this.scaleY = 0.5f + this.host.field_70130_N * 0.5f;
                this.scaleZ = 0.5f + this.host.field_70130_N * 0.5f;
                this.stemWidth = 0.01f * this.host.field_70130_N;
                this.field_70165_t = this.host.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0;
                this.field_70163_u = this.host.field_70163_u + (double)this.host.field_70131_O * 0.6;
                this.field_70161_v = this.host.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0;
                break;
            }
            case 2: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.5f;
                this.field_70551_j = 0.7f;
                this.field_82339_as = 1.0f;
                this.field_70547_e = life;
                this.numStem = 12;
                this.scaleX = 0.25f;
                this.scaleY = 0.25f;
                this.scaleZ = 0.25f;
                this.stemWidth = 0.005f;
                float[] partPos = ParticleHelper.rotateXZByAxis(1.0f, 0.0f, ((EntityLivingBase)this.host).field_70761_aq % 360.0f * ((float)Math.PI / 180), 1.0f);
                this.field_70165_t = this.host.field_70165_t + (double)partPos[1];
                this.field_70163_u = this.host.field_70163_u + (double)this.host.field_70131_O * 0.8;
                this.field_70161_v = this.host.field_70161_v + (double)partPos[0];
                break;
            }
            case 3: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.5f;
                this.field_70551_j = 0.7f;
                this.field_82339_as = 1.0f;
                this.field_70547_e = life;
                this.numStem = 4;
                this.scaleX = 1.0f;
                this.scaleY = 1.0f;
                this.scaleZ = 1.0f;
                this.stemWidth = 0.025f;
                break;
            }
            case 4: {
                this.field_70552_h = 0.0f;
                this.field_70553_i = 0.7f;
                this.field_70551_j = 1.0f;
                this.field_82339_as = 1.0f;
                this.field_70547_e = life;
                this.numStem = 12;
                this.scaleX = 0.75f;
                this.scaleY = 0.75f;
                this.scaleZ = 0.75f;
                this.stemWidth = 0.008f;
                this.field_70165_t = this.host.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 0.25f) - 0.125;
                this.field_70163_u = this.host.field_70163_u + (double)this.host.field_70131_O * 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.25f) - 0.125;
                this.field_70161_v = this.host.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 0.25f) - 0.125;
                break;
            }
            default: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.5f;
                this.field_70551_j = 0.7f;
                this.field_82339_as = 1.0f;
                this.field_70547_e = life;
                this.numStem = 8;
                this.scaleX = 1.75f;
                this.scaleY = 1.75f;
                this.scaleZ = 1.75f;
                this.stemWidth = 0.006f;
                this.field_70165_t = this.host.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0;
                this.field_70163_u = this.host.field_70163_u + (double)this.host.field_70131_O * 0.5 + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0;
                this.field_70161_v = this.host.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 2.0f) - 1.0;
            }
        }
        this.prevShape = new double[this.numStem][6];
    }

    public void func_70539_a(Tessellator tess, float ticks, float par3, float par4, float par5, float par6, float par7) {
        int i;
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        float px = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)ticks - field_70556_an);
        float py = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)ticks - field_70554_ao);
        float pz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)ticks - field_70555_ap);
        float offx = 0.0f;
        float offz = 0.0f;
        float offy = 0.0f;
        if (this.field_70546_d % 2 == 0) {
            for (i = 0; i < this.numStem; ++i) {
                offx = (this.field_70146_Z.nextFloat() - 0.5f) * this.scaleX;
                offz = (this.field_70146_Z.nextFloat() - 0.5f) * this.scaleZ;
                offy = (this.field_70146_Z.nextFloat() - 0.5f) * this.scaleY;
                if (i == 0) {
                    this.prevShape[i][0] = px + offx;
                    this.prevShape[i][1] = py + offy;
                    this.prevShape[i][2] = pz + offz;
                    this.prevShape[i][3] = this.prevShape[i][0];
                    this.prevShape[i][4] = this.prevShape[i][1];
                    this.prevShape[i][5] = this.prevShape[i][2];
                    continue;
                }
                if (i == this.numStem - 1) {
                    this.prevShape[i][0] = this.prevShape[i - 1][0] + (double)offx;
                    this.prevShape[i][1] = this.prevShape[i - 1][1] + (double)offy;
                    this.prevShape[i][2] = this.prevShape[i - 1][2] + (double)offz;
                    this.prevShape[i][3] = this.prevShape[i][0];
                    this.prevShape[i][4] = this.prevShape[i][1];
                    this.prevShape[i][5] = this.prevShape[i][2];
                    continue;
                }
                this.prevShape[i][0] = this.prevShape[i - 1][0] + (double)offx;
                this.prevShape[i][1] = this.prevShape[i - 1][1] + (double)offy;
                this.prevShape[i][2] = this.prevShape[i - 1][2] + (double)offz;
                this.prevShape[i][3] = this.prevShape[i - 1][3] + (double)offx + (double)this.stemWidth;
                this.prevShape[i][4] = this.prevShape[i - 1][4] + (double)offy + (double)this.stemWidth;
                this.prevShape[i][5] = this.prevShape[i - 1][5] + (double)offz + (double)this.stemWidth;
            }
        }
        tess.func_78371_b(8);
        tess.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        tess.func_78380_c(240);
        for (i = this.numStem - 1; i >= 0; --i) {
            tess.func_78377_a(this.prevShape[i][0], this.prevShape[i][1], this.prevShape[i][2]);
            tess.func_78377_a(this.prevShape[i][3], this.prevShape[i][4], this.prevShape[i][5]);
        }
        tess.func_78381_a();
        tess.func_78371_b(8);
        tess.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        tess.func_78380_c(240);
        for (i = this.numStem - 1; i >= 0; --i) {
            tess.func_78377_a(this.prevShape[i][3], this.prevShape[i][4], this.prevShape[i][5]);
            tess.func_78377_a(this.prevShape[i][0], this.prevShape[i][1], this.prevShape[i][2]);
        }
        tess.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70546_d++ > this.field_70547_e) {
            this.func_70106_y();
        }
        switch (this.particleType) {
            case 3: {
                float[] partPos2 = ParticleHelper.rotateXZByAxis(this.host.field_70130_N * 2.0f, 0.0f, ((EntityLivingBase)this.host).field_70761_aq % 360.0f * ((float)Math.PI / 180), 1.0f);
                this.field_70165_t = this.host.field_70165_t + (double)partPos2[1];
                this.field_70163_u = this.host.field_70163_u + (double)this.host.field_70131_O * 0.6;
                this.field_70161_v = this.host.field_70161_v + (double)partPos2[0];
            }
        }
        switch (this.particleType) {
            case 4: {
                if (this.field_70547_e - this.field_70546_d < 6) {
                    this.field_82339_as = (float)(this.field_70547_e - this.field_70546_d) * 0.15f + 0.2f;
                }
                this.field_70553_i = 0.6f + this.field_70146_Z.nextFloat() * 0.6f;
                this.field_70552_h = this.field_70553_i - 0.3f;
                break;
            }
            default: {
                if (this.field_70547_e - this.field_70546_d < 6) {
                    this.field_82339_as = (float)(this.field_70547_e - this.field_70546_d) * 0.15f + 0.2f;
                }
                this.field_70553_i = 0.4f + this.field_70146_Z.nextFloat() * 0.75f;
                this.field_70551_j = 0.1f + this.field_70553_i;
            }
        }
    }
}

