/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.client.gui;

import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.reference.Values;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.GuiHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBook {
    private static final ResourceLocation guiBookPic01 = new ResourceLocation("shincolle:textures/gui/book/BookPic01.png");
    private static TextureManager tm = ClientProxy.getMineraft().func_110434_K();
    private static GuiContainer gui;
    private static FontRenderer font;
    private static RenderItem itemRender;
    private static int numChap;
    private static int numPage;
    public static int PageWidth;
    public static int Page0LX;
    public static int Page0RX;
    public static int Page0Y;
    public static int PageTLX;
    public static int PageTRX;
    public static int PageTY;
    public static final int[] PageLimit;

    public static void drawBookContent(GuiContainer par1, FontRenderer par2, int chap, int page) {
        int index = GuiBook.getIndexID(chap, page);
        List<int[]> cont = Values.BookList.get(index);
        gui = par1;
        font = par2;
        numChap = chap;
        numPage = page;
        if (cont == null) {
            cont = Arrays.asList({0, 0, 0, 0}, {0, 1, 0, 0});
        }
        if (cont != null) {
            for (int[] getc : cont) {
                if (getc == null || getc.length <= 3) continue;
                switch (getc[0]) {
                    case 0: {
                        GuiBook.drawBookText(getc[1], getc[2], getc[3]);
                        break;
                    }
                    case 1: {
                        GuiBook.drawBookPic(getc);
                        break;
                    }
                    case 2: {
                        GuiBook.drawBookIcon(getc[1], getc[2], getc[3], getc[4]);
                    }
                }
            }
        }
    }

    private static void drawBookText(int pageSide, int offX, int offY) {
        GuiBook.drawTitleText();
        GuiBook.drawPageText(pageSide, offX, offY);
    }

    private static void drawTitleText() {
        String str = null;
        switch (numChap) {
            case 0: {
                str = I18n.func_135052_a((String)("gui.shincolle:book.chap" + numChap + ".title"), (Object[])new Object[0]);
                break;
            }
            default: {
                str = I18n.func_135052_a((String)("gui.shincolle:book.chap" + numChap + ".title" + numPage), (Object[])new Object[0]);
            }
        }
        int strlen = (int)((float)font.func_78256_a(str) * 0.5f);
        str = EnumChatFormatting.UNDERLINE + str;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        font.func_78276_b(str, 82 - strlen, 40, GuiHelper.pickColor(GuiHelper.pickColorName.RED2.ordinal()));
        GL11.glPopMatrix();
    }

    private static void drawPageText(int pageSide, int offX, int offY) {
        int picY = PageTY + offY - 4;
        int picX = PageTLX;
        if (pageSide > 0) {
            picX = PageTRX;
        }
        String str = I18n.func_135052_a((String)("gui.shincolle:book.chap" + numChap + ".text" + numPage + "d" + pageSide), (Object[])new Object[0]);
        GuiBook.drawStringWithSpecialSymbol(str, picX += offX, picY);
    }

    private static void drawStringWithSpecialSymbol(String str, int x, int y) {
        String[] strArray = CalcHelper.stringConvNewlineToArray(str);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        int newY = y;
        for (String s : strArray) {
            font.func_78279_b(s, x, newY, PageWidth, 0);
            newY += font.func_78267_b(s, PageWidth);
        }
        GL11.glPopMatrix();
    }

    private static void drawBookPic(int[] parms) {
        if (parms == null || parms.length != 9) {
            return;
        }
        int pageSide = parms[1];
        int posX = parms[2];
        int posY = parms[3];
        int picID = parms[4];
        int picU = parms[5];
        int picV = parms[6];
        int sizeX = parms[7];
        int sizeY = parms[8];
        int picY = Page0Y + posY;
        int picX = Page0LX;
        if (pageSide > 0) {
            picX = Page0RX;
        }
        picX += posX;
        switch (picID) {
            case 0: {
                tm.func_110577_a(guiBookPic01);
                break;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        gui.func_73729_b(picX, picY, picU, picV, sizeX, sizeY);
        GL11.glDisable((int)3042);
    }

    private static void drawBookIcon(int pageSide, int offX, int offY, int iconID) {
        int picY = Page0Y + offY;
        int picX = Page0LX;
        if (pageSide > 0) {
            picX = Page0RX;
        }
        GuiBook.drawItemIcon(GuiBook.getItemStackForIcon(iconID), picX += offX, picY, false);
    }

    private static void drawItemIcon(ItemStack item, int x, int y, boolean effect) {
        if (item != null) {
            itemRender.func_82406_b(font, tm, item, x, y);
        }
    }

    public static int getMaxPageNumber(int chap) {
        if (chap < PageLimit.length) {
            return PageLimit[chap];
        }
        return 0;
    }

    public static int getIndexID(int ch, int pg) {
        return ch * 1000 + pg;
    }

    public static ItemStack getItemStackForIcon(int itemID) {
        return Values.ItemIconMap.get((byte)itemID);
    }

    static {
        itemRender = new RenderItem();
        PageWidth = 135;
        Page0LX = 13;
        Page0RX = 133;
        Page0Y = 48;
        PageTLX = 13;
        PageTRX = 162;
        PageTY = 58;
        PageLimit = new int[]{1, 23, 5, 15, 19, 11, 3};
    }
}

