/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import com.lulan.shincolle.ai.path.ShipPathEntity;
import com.lulan.shincolle.ai.path.ShipPathFinder;
import com.lulan.shincolle.ai.path.ShipPathPoint;
import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipNavigator;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShipPathNavigate {
    private EntityLiving host;
    private IShipNavigator theEntity2;
    private World worldObj;
    private ShipPathEntity currentPath;
    private double speed;
    private int pathTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private boolean canFly;

    public ShipPathNavigate(EntityLiving entity, World world) {
        this.host = entity;
        this.theEntity2 = (IShipNavigator)entity;
        this.worldObj = world;
        this.canFly = false;
    }

    public void setSpeed(double par1) {
        this.speed = par1;
    }

    public void setCanFly(boolean par1) {
        this.canFly = par1;
    }

    public boolean getCanFly() {
        return this.canFly;
    }

    public float getPathSearchRange() {
        if (this.host instanceof BasicEntityAirplane) {
            return 64.0f;
        }
        if (this.host instanceof IShipAttackBase) {
            return ((IShipAttackBase)this.host).getAttackRange() + 24.0f;
        }
        return 32.0f;
    }

    public boolean tryMoveToXYZ(double x, double y, double z, double speed) {
        ShipPathEntity pathentity = this.getPathToXYZ(MathHelper.func_76128_c((double)x), (int)y, MathHelper.func_76128_c((double)z));
        return this.setPath(pathentity, speed);
    }

    public ShipPathEntity getPathToXYZ(double x, double y, double z) {
        return !this.canNavigate() ? null : this.getShipPathToXYZ((Entity)this.host, MathHelper.func_76128_c((double)x), (int)y, MathHelper.func_76128_c((double)z), this.getPathSearchRange(), this.canFly);
    }

    public ShipPathEntity getShipPathToXYZ(Entity entity, int x, int y, int z, float range, boolean canFly) {
        this.worldObj.field_72984_F.func_76320_a("pathfind");
        int x1 = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y1 = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z1 = MathHelper.func_76128_c((double)entity.field_70161_v);
        int range1 = (int)(range + 8.0f);
        int x2 = x1 - range1;
        int y2 = y1 - range1;
        int z2 = z1 - range1;
        int x3 = x1 + range1;
        int y3 = y1 + range1;
        int z3 = z1 + range1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, x2, y2, z2, x3, y3, z3, 0);
        ShipPathEntity pathentity = new ShipPathFinder((IBlockAccess)chunkcache, canFly).createEntityPathTo(entity, x, y, z, range);
        this.worldObj.field_72984_F.func_76319_b();
        return pathentity;
    }

    public ShipPathEntity getPathToEntityLiving(Entity entity) {
        return !this.canNavigate() ? null : this.getPathEntityToEntity((Entity)this.host, entity, this.getPathSearchRange(), this.canFly);
    }

    public ShipPathEntity getPathEntityToEntity(Entity entity, Entity targetEntity, float range, boolean canFly) {
        this.worldObj.field_72984_F.func_76320_a("pathfind");
        int x1 = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y1 = MathHelper.func_76128_c((double)(entity.field_70163_u + 1.0));
        int z1 = MathHelper.func_76128_c((double)entity.field_70161_v);
        int range1 = (int)(range + 16.0f);
        int x2 = x1 - range1;
        int y2 = y1 - range1;
        int z2 = z1 - range1;
        int x3 = x1 + range1;
        int y3 = y1 + range1;
        int z3 = z1 + range1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, x2, y2, z2, x3, y3, z3, 0);
        ShipPathEntity pathentity = new ShipPathFinder((IBlockAccess)chunkcache, canFly).createEntityPathTo(entity, targetEntity, range);
        this.worldObj.field_72984_F.func_76319_b();
        return pathentity;
    }

    public boolean tryMoveToEntityLiving(Entity entity, double speed) {
        ShipPathEntity pathentity = this.getPathToEntityLiving(entity);
        return pathentity != null ? this.setPath(pathentity, speed) : false;
    }

    public boolean setPath(ShipPathEntity pathEntity, double speed) {
        if (pathEntity == null) {
            this.currentPath = null;
            return false;
        }
        if (!pathEntity.isSamePath(this.currentPath)) {
            this.currentPath = pathEntity;
        }
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = speed;
        Vec3 vec3 = this.getEntityPosition();
        this.lastPosCheck.field_72450_a = vec3.field_72450_a;
        this.lastPosCheck.field_72448_b = vec3.field_72448_b;
        this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        return true;
    }

    public ShipPathEntity getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        if (this.host.field_70173_aa > 64) {
            ++this.pathTicks;
            if (!this.noPath()) {
                if (this.canNavigate()) {
                    this.pathFollow();
                }
                if (this.noPath()) {
                    return;
                }
                Vec3 vec3 = this.currentPath.getPosition((Entity)this.host);
                if (vec3 != null) {
                    this.theEntity2.getShipMoveHelper().setMoveTo(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, this.speed);
                }
            }
        }
    }

    private void pathFollow() {
        int k;
        Vec3 entityPos = this.getEntityPosition();
        int pptemp = this.currentPath.getCurrentPathLength();
        float widthSq = this.host.field_70130_N * this.host.field_70130_N;
        for (k = this.currentPath.getCurrentPathIndex(); k < pptemp; ++k) {
            if (!(entityPos.func_72436_e(this.currentPath.getVectorFromIndex((Entity)this.host, k)) < (double)widthSq)) continue;
            this.currentPath.setCurrentPathIndex(++k);
        }
        k = MathHelper.func_76123_f((float)this.host.field_70130_N);
        int heighInt = (int)this.host.field_70131_O;
        int widthInt = k;
        for (int j1 = pptemp - 1; j1 >= this.currentPath.getCurrentPathIndex(); --j1) {
            if (!this.isDirectPathBetweenPoints(entityPos, this.currentPath.getVectorFromIndex((Entity)this.host, j1), k, heighInt, widthInt)) continue;
            this.currentPath.setCurrentPathIndex(j1);
            break;
        }
        if (this.pathTicks - this.ticksAtLastPos > 32) {
            if (entityPos.func_72436_e(this.lastPosCheck) < 3.0) {
                if (!this.currentPath.isFinished()) {
                    float dx = (float)(this.currentPath.getVectorFromIndex((Entity)this.host, (int)this.currentPath.getCurrentPathIndex()).field_72450_a - this.host.field_70165_t);
                    float dz = (float)(this.currentPath.getVectorFromIndex((Entity)this.host, (int)this.currentPath.getCurrentPathIndex()).field_72449_c - this.host.field_70161_v);
                    double targetX = this.host.field_70165_t;
                    double targetZ = this.host.field_70161_v;
                    if (dx > 0.2f || dx < -0.2f) {
                        targetZ = this.host.func_70681_au().nextInt(2) == 0 ? targetZ - 2.0 : targetZ + 2.0;
                        targetX = dx < 0.0f ? targetX + 2.0 : targetX - 2.0;
                    } else if (dz > 0.2f || dz < -0.2f) {
                        targetX = this.host.func_70681_au().nextInt(2) == 0 ? targetX - 2.0 : targetX + 2.0;
                        targetZ = dz < 0.0f ? targetZ + 2.0 : targetZ - 2.0;
                    }
                    this.theEntity2.getShipMoveHelper().setMoveTo(targetX, this.host.field_70163_u, targetZ, this.speed);
                    if (this.host.func_70681_au().nextInt(3) == 0) {
                        this.host.func_70683_ar().func_75660_a();
                        float speed = (float)this.host.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f;
                        if (dx > 0.5f) {
                            this.host.field_70159_w += (double)speed;
                        }
                        if (dx < 0.5f) {
                            this.host.field_70159_w -= (double)speed;
                        }
                        if (dz > 0.5f) {
                            this.host.field_70179_y += (double)speed;
                        }
                        if (dz < 0.5f) {
                            this.host.field_70179_y -= (double)speed;
                        }
                    }
                }
                if (this.pathTicks - this.ticksAtLastPos > 50) {
                    this.ticksAtLastPos = this.pathTicks;
                    this.lastPosCheck.field_72450_a = entityPos.field_72450_a;
                    this.lastPosCheck.field_72448_b = entityPos.field_72448_b;
                    this.lastPosCheck.field_72449_c = entityPos.field_72449_c;
                    this.clearPathEntity();
                    return;
                }
            } else {
                this.ticksAtLastPos = this.pathTicks;
                this.lastPosCheck.field_72450_a = entityPos.field_72450_a;
                this.lastPosCheck.field_72448_b = entityPos.field_72448_b;
                this.lastPosCheck.field_72449_c = entityPos.field_72449_c;
            }
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return Vec3.func_72443_a((double)this.host.field_70165_t, (double)this.host.field_70163_u, (double)this.host.field_70161_v);
    }

    private double getPathableYPos() {
        if (this.canFly) {
            return this.host.field_70163_u;
        }
        int i = (int)this.host.field_70121_D.field_72338_b;
        Block block = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.host.field_70165_t), i, MathHelper.func_76128_c((double)this.host.field_70161_v));
        int j = 0;
        do {
            if (block != Blocks.field_150350_a && block != null) {
                if (BlockHelper.checkBlockIsLiquid(block)) {
                    return (double)i + 0.4;
                }
                return i;
            }
            block = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.host.field_70165_t), ++i, MathHelper.func_76128_c((double)this.host.field_70161_v));
        } while (++j <= 16);
        return (int)this.host.field_70121_D.field_72338_b;
    }

    private boolean canNavigate() {
        return !this.host.func_70115_ae() && (this.canFly || this.host.field_70122_E || EntityHelper.checkEntityIsFree((Entity)this.host));
    }

    private boolean isInLiquid() {
        return EntityHelper.checkEntityIsInLiquid((Entity)this.host);
    }

    private void removeSunnyPath() {
        if (!this.worldObj.func_72937_j(MathHelper.func_76128_c((double)this.host.field_70165_t), (int)(this.host.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)this.host.field_70161_v))) {
            for (int i = 0; i < this.currentPath.getCurrentPathLength(); ++i) {
                ShipPathPoint pathpoint = this.currentPath.getPathPointFromIndex(i);
                if (!this.worldObj.func_72937_j(pathpoint.xCoord, pathpoint.yCoord, pathpoint.zCoord)) continue;
                this.currentPath.setCurrentPathLength(i - 1);
                return;
            }
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3 pos1, Vec3 pos2, int xSize, int ySize, int zSize) {
        int x1 = MathHelper.func_76128_c((double)pos1.field_72450_a);
        int z1 = MathHelper.func_76128_c((double)pos1.field_72449_c);
        int y1 = (int)pos1.field_72448_b;
        double xOffset = pos2.field_72450_a - pos1.field_72450_a;
        double zOffset = pos2.field_72449_c - pos1.field_72449_c;
        double yOffset = pos2.field_72448_b - pos1.field_72448_b;
        double xzOffsetSq = xOffset * xOffset + zOffset * zOffset + yOffset * yOffset;
        if (xzOffsetSq < 1.0E-12) {
            return false;
        }
        double xzOffset = 1.0 / Math.sqrt(xzOffsetSq);
        yOffset *= xzOffset;
        if (!this.isSafeToStandAt(x1, y1, z1, xSize += 2, ySize += 2, zSize += 2, pos1, xOffset *= xzOffset, zOffset *= xzOffset)) {
            return false;
        }
        xSize -= 2;
        zSize -= 2;
        ySize -= 2;
        double xOffAbs = 1.0 / Math.abs(xOffset);
        double zOffAbs = 1.0 / Math.abs(zOffset);
        double yOffAbs = 1.0 / Math.abs(yOffset);
        double x1Theta = (double)(x1 * 1) - pos1.field_72450_a;
        double z1Theta = (double)(z1 * 1) - pos1.field_72449_c;
        double y1Theta = (double)(y1 * 1) - pos1.field_72448_b;
        if (xOffset >= 0.0) {
            x1Theta += 1.0;
        }
        if (zOffset >= 0.0) {
            z1Theta += 1.0;
        }
        if (yOffset >= 0.0) {
            y1Theta += 1.0;
        }
        x1Theta /= xOffset;
        z1Theta /= zOffset;
        y1Theta /= yOffset;
        int xDir = xOffset < 0.0 ? -1 : 1;
        int zDir = zOffset < 0.0 ? -1 : 1;
        int yDir = yOffset < 0.0 ? -1 : 1;
        int x2 = MathHelper.func_76128_c((double)pos2.field_72450_a);
        int z2 = MathHelper.func_76128_c((double)pos2.field_72449_c);
        int y2 = MathHelper.func_76128_c((double)pos2.field_72448_b);
        int xIntOffset = x2 - x1;
        int zIntOffset = z2 - z1;
        int yIntOffset = y2 - y1;
        do {
            if (xIntOffset * xDir <= 0 && zIntOffset * zDir <= 0 && yIntOffset * yDir <= 0) {
                return true;
            }
            switch (CalcHelper.min(x1Theta, y1Theta, z1Theta)) {
                case 1: {
                    x1Theta += xOffAbs;
                    xIntOffset = x2 - (x1 += xDir);
                    break;
                }
                case 2: {
                    y1Theta += yOffAbs;
                    yIntOffset = y2 - (y1 += yDir);
                    break;
                }
                case 3: {
                    z1Theta += zOffAbs;
                    zIntOffset = z2 - (z1 += zDir);
                    break;
                }
            }
        } while (this.isSafeToStandAt(x1, y1, z1, xSize, ySize, zSize, pos1, xOffset, zOffset));
        return false;
    }

    private boolean isSafeToStandAt(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, Vec3 orgPos, double vecX, double vecZ) {
        int xSize2 = xOffset - xSize / 2;
        int zSize2 = zOffset - zSize / 2;
        if (this.canFly) {
            return true;
        }
        if (!this.isPositionClear(xSize2, yOffset, zSize2, xSize, ySize, zSize, orgPos, vecX, vecZ)) {
            return false;
        }
        for (int x1 = xSize2; x1 < xSize2 + xSize; ++x1) {
            for (int z1 = zSize2; z1 < zSize2 + zSize; ++z1) {
                double x2 = (double)x1 + 0.5 - orgPos.field_72450_a;
                double z2 = (double)z1 + 0.5 - orgPos.field_72449_c;
                if (!(x2 * vecX + z2 * vecZ >= 0.0)) continue;
                Block block = this.worldObj.func_147439_a(x1, yOffset - 1, z1);
                Material material = block.func_149688_o();
                if (block != null && material != Material.field_151579_a) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, Vec3 orgPos, double vecX, double vecZ) {
        for (int x1 = xOffset; x1 < xOffset + xSize; ++x1) {
            for (int y1 = yOffset; y1 < yOffset + ySize; ++y1) {
                for (int z1 = zOffset; z1 < zOffset + zSize; ++z1) {
                    double x2 = (double)x1 + 0.5 - orgPos.field_72450_a;
                    double z2 = (double)z1 + 0.5 - orgPos.field_72449_c;
                    if (!(x2 * vecX + z2 * vecZ >= 0.0)) continue;
                    Block block = this.worldObj.func_147439_a(x1, y1, z1);
                    if (BlockHelper.checkBlockSafe(block)) {
                        return true;
                    }
                    if (block == Blocks.field_150422_aJ) {
                        return false;
                    }
                    if (block.func_149655_b((IBlockAccess)this.worldObj, x1, y1, z1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

