/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import com.lulan.shincolle.ai.path.ShipPath;
import com.lulan.shincolle.ai.path.ShipPathEntity;
import com.lulan.shincolle.ai.path.ShipPathPoint;
import com.lulan.shincolle.utility.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class ShipPathFinder {
    private IBlockAccess worldMap;
    private ShipPath path = new ShipPath();
    private IntHashMap pointMap = new IntHashMap();
    private ShipPathPoint[] pathOptions = new ShipPathPoint[32];
    private boolean isPathingInAir;
    private boolean canEntityFly;

    public ShipPathFinder(IBlockAccess block, boolean canFly) {
        this.worldMap = block;
        this.isPathingInAir = false;
        this.canEntityFly = canFly;
    }

    public ShipPathEntity createEntityPathTo(Entity fromEnt, Entity toEnt, float range) {
        return this.createEntityPathTo(fromEnt, toEnt.field_70165_t, toEnt.field_70121_D.field_72338_b, toEnt.field_70161_v, range);
    }

    public ShipPathEntity createEntityPathTo(Entity entity, int x, int y, int z, float range) {
        return this.createEntityPathTo(entity, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, range);
    }

    private ShipPathEntity createEntityPathTo(Entity entity, double x, double y, double z, float range) {
        this.path.clearPath();
        this.pointMap.func_76046_c();
        int i = MathHelper.func_76128_c((double)(entity.field_70121_D.field_72338_b + 0.5));
        ShipPathPoint startpp = this.openPoint(MathHelper.func_76128_c((double)entity.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)entity.field_70121_D.field_72339_c));
        ShipPathPoint endpp = this.openPoint(MathHelper.func_76128_c((double)(x - (double)(entity.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)(z - (double)(entity.field_70130_N / 2.0f))));
        ShipPathPoint entitySize = new ShipPathPoint(MathHelper.func_76141_d((float)(entity.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(entity.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(entity.field_70130_N + 1.0f)));
        ShipPathEntity pathentity = this.addToPath(entity, startpp, endpp, entitySize, range);
        return pathentity;
    }

    private ShipPathEntity addToPath(Entity entity, ShipPathPoint startpp, ShipPathPoint endpp, ShipPathPoint entitySize, float range) {
        startpp.totalPathDistance = 0.0f;
        startpp.distanceToTarget = startpp.distanceToNext = startpp.distanceToSquared(endpp);
        this.path.clearPath();
        this.path.addPoint(startpp);
        ShipPathPoint ppTemp = startpp;
        int findCount = 0;
        while (!this.path.isPathEmpty()) {
            ShipPathPoint ppDequeue = this.path.dequeue();
            ++findCount;
            if (ppDequeue.equals(endpp)) {
                return this.createEntityPath(startpp, endpp);
            }
            if (findCount > 600) break;
            if (ppDequeue.distanceToSquared(endpp) < ppTemp.distanceToSquared(endpp)) {
                ppTemp = ppDequeue;
            }
            ppDequeue.isFirst = true;
            int i = this.findPathOptions(entity, ppDequeue, entitySize, endpp, range);
            for (int j = 0; j < i; ++j) {
                ShipPathPoint ppTemp2 = this.pathOptions[j];
                float f1 = ppDequeue.totalPathDistance + ppDequeue.distanceToSquared(ppTemp2);
                if (ppTemp2.isAssigned() && !(f1 < ppTemp2.totalPathDistance)) continue;
                ppTemp2.previous = ppDequeue;
                ppTemp2.totalPathDistance = f1;
                ppTemp2.distanceToNext = ppTemp2.distanceToSquared(endpp);
                if (ppTemp2.isAssigned()) {
                    this.path.changeDistance(ppTemp2, ppTemp2.totalPathDistance + ppTemp2.distanceToNext);
                    continue;
                }
                ppTemp2.distanceToTarget = ppTemp2.totalPathDistance + ppTemp2.distanceToNext;
                this.path.addPoint(ppTemp2);
            }
        }
        if (ppTemp == startpp) {
            return null;
        }
        return this.createEntityPath(startpp, ppTemp);
    }

    private int findPathOptions(Entity entity, ShipPathPoint currentpp, ShipPathPoint entitySize, ShipPathPoint targetpp, float range) {
        int i = 0;
        int pathCase = 0;
        int j = this.getVerticalOffset(entity, currentpp.xCoord, currentpp.yCoord + 1, currentpp.zCoord, entitySize);
        if (j == 1 || j == 3) {
            pathCase = 1;
        }
        ShipPathPoint pathpoint2 = this.getSafePoint(entity, currentpp.xCoord, currentpp.yCoord - 1, currentpp.zCoord, entitySize, pathCase);
        ShipPathPoint pathpoint3 = this.getSafePoint(entity, currentpp.xCoord, currentpp.yCoord, currentpp.zCoord + 1, entitySize, pathCase);
        ShipPathPoint pathpoint4 = this.getSafePoint(entity, currentpp.xCoord - 1, currentpp.yCoord, currentpp.zCoord, entitySize, pathCase);
        ShipPathPoint pathpoint5 = this.getSafePoint(entity, currentpp.xCoord + 1, currentpp.yCoord, currentpp.zCoord, entitySize, pathCase);
        ShipPathPoint pathpoint6 = this.getSafePoint(entity, currentpp.xCoord, currentpp.yCoord, currentpp.zCoord - 1, entitySize, pathCase);
        ShipPathPoint pathpoint7 = null;
        if (j == 3 || j == 1 && this.canEntityFly) {
            pathpoint7 = this.getSafePoint(entity, currentpp.xCoord, currentpp.yCoord + 1, currentpp.zCoord, entitySize, pathCase);
        }
        if (pathpoint2 != null && !pathpoint2.isFirst && pathpoint2.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.isFirst && pathpoint3.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.isFirst && pathpoint4.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.isFirst && pathpoint5.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.isFirst && pathpoint6.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint6;
        }
        if (pathpoint7 != null && !pathpoint7.isFirst && pathpoint7.distanceTo(targetpp) < range) {
            this.pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    private ShipPathPoint getSafePoint(Entity entity, int x, int y, int z, ShipPathPoint entitySize, int pathOption) {
        ShipPathPoint pathpoint1 = null;
        int pathCase = this.getVerticalOffset(entity, x, y, z, entitySize);
        if (pathCase == 2 || pathCase == 3) {
            return this.openPoint(x, y, z);
        }
        if (pathCase == 1) {
            pathpoint1 = this.openPoint(x, y, z);
        }
        if (pathpoint1 == null && pathOption > 0 && pathCase != -3 && pathCase != -4 && this.getVerticalOffset(entity, x, y + pathOption, z, entitySize) == 1) {
            pathpoint1 = this.openPoint(x, y + pathOption, z);
            y += pathOption;
        }
        if (pathpoint1 != null) {
            if (this.canEntityFly) {
                return pathpoint1;
            }
            int j1 = 0;
            int downCase = 0;
            while (y > 0) {
                downCase = this.getVerticalOffset(entity, x, y - 1, z, entitySize);
                if (downCase == 3) {
                    pathpoint1 = this.openPoint(x, y - 1, z);
                    break;
                }
                if (downCase != 1) break;
                if (j1++ >= 32) {
                    return null;
                }
                if (--y <= 0) continue;
                pathpoint1 = this.openPoint(x, y, z);
            }
        }
        return pathpoint1;
    }

    private final ShipPathPoint openPoint(int x, int y, int z) {
        int l = ShipPathPoint.makeHash(x, y, z);
        ShipPathPoint pathpoint = (ShipPathPoint)this.pointMap.func_76041_a(l);
        if (pathpoint == null) {
            pathpoint = new ShipPathPoint(x, y, z);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    public int getVerticalOffset(Entity entity, int x, int y, int z, ShipPathPoint entitySize) {
        return ShipPathFinder.getVerticalOffset(entity, x, y, z, entitySize, this.isPathingInAir);
    }

    public static int getVerticalOffset(Entity entity, int x, int y, int z, ShipPathPoint entitySize, boolean inAir) {
        boolean pathToDoor = false;
        boolean pathInLiquid = true;
        for (int x1 = x; x1 < x + entitySize.xCoord; ++x1) {
            for (int y1 = y; y1 < y + entitySize.yCoord; ++y1) {
                for (int z1 = z; z1 < z + entitySize.zCoord; ++z1) {
                    Block block = entity.field_70170_p.func_147439_a(x1, y1, z1);
                    if (block.func_149688_o() != Material.field_151579_a) {
                        if (pathInLiquid && y1 == y && !BlockHelper.checkBlockIsLiquid(block)) {
                            pathInLiquid = false;
                        }
                        if (block == Blocks.field_150466_ao || block == Blocks.field_150396_be) {
                            return 1;
                        }
                        int k1 = block.func_149645_b();
                        if (block.func_149655_b((IBlockAccess)entity.field_70170_p, x1, y1, z1)) continue;
                        if (k1 == 11 || k1 == 32) {
                            return -3;
                        }
                        if (block == Blocks.field_150415_aT) {
                            return -4;
                        }
                        if (BlockHelper.checkBlockIsLiquid(block)) continue;
                        return 0;
                    }
                    if (!pathInLiquid || y1 != y) continue;
                    pathInLiquid = false;
                }
            }
        }
        return pathInLiquid ? 3 : (pathToDoor ? 2 : 1);
    }

    private ShipPathEntity createEntityPath(ShipPathPoint startpp, ShipPathPoint endpp) {
        int i = 1;
        ShipPathPoint pathpoint2 = endpp;
        while (pathpoint2.previous != null) {
            ++i;
            pathpoint2 = pathpoint2.previous;
        }
        ShipPathPoint[] pathtemp = new ShipPathPoint[i];
        pathpoint2 = endpp;
        pathtemp[--i] = endpp;
        while (pathpoint2.previous != null) {
            pathpoint2 = pathpoint2.previous;
            pathtemp[--i] = pathpoint2;
        }
        return new ShipPathEntity(pathtemp);
    }
}

