/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import com.lulan.shincolle.ai.path.ShipPathPoint;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class ShipPathEntity {
    private final ShipPathPoint[] points;
    private int currentPathIndex;
    private int pathLength;

    public ShipPathEntity(ShipPathPoint[] pathpoint) {
        this.points = pathpoint;
        this.pathLength = pathpoint.length;
    }

    public void incrementPathIndex() {
        ++this.currentPathIndex;
    }

    public boolean isFinished() {
        return this.currentPathIndex >= this.pathLength;
    }

    public ShipPathPoint getFinalPathPoint() {
        return this.pathLength > 0 ? this.points[this.pathLength - 1] : null;
    }

    public ShipPathPoint getPathPointFromIndex(int i) {
        return this.points[i];
    }

    public int getCurrentPathLength() {
        return this.pathLength;
    }

    public void setCurrentPathLength(int i) {
        this.pathLength = i;
    }

    public int getCurrentPathIndex() {
        return this.currentPathIndex;
    }

    public void setCurrentPathIndex(int i) {
        this.currentPathIndex = i;
    }

    public Vec3 getVectorFromIndex(Entity entity, int i) {
        if (i >= this.points.length) {
            i = this.points.length - 1;
        }
        double d0 = (double)this.points[i].xCoord + (double)((int)(entity.field_70130_N + 1.0f)) * 0.5;
        double d1 = this.points[i].yCoord;
        double d2 = (double)this.points[i].zCoord + (double)((int)(entity.field_70130_N + 1.0f)) * 0.5;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public Vec3 getPosition(Entity entity) {
        return this.getVectorFromIndex(entity, this.currentPathIndex);
    }

    public boolean isSamePath(ShipPathEntity path) {
        if (path == null) {
            return false;
        }
        if (path.points.length != this.points.length) {
            return false;
        }
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i].xCoord == path.points[i].xCoord && this.points[i].yCoord == path.points[i].yCoord && this.points[i].zCoord == path.points[i].zCoord) continue;
            return false;
        }
        return true;
    }

    public boolean isDestinationSame(Vec3 vec) {
        ShipPathPoint pathpoint = this.getFinalPathPoint();
        return pathpoint == null ? false : pathpoint.xCoord == (int)vec.field_72450_a && pathpoint.zCoord == (int)vec.field_72449_c;
    }
}

