/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import com.lulan.shincolle.ai.path.ShipPathPoint;

public class ShipPath {
    private ShipPathPoint[] pathPoints = new ShipPathPoint[1024];
    private int count;

    public ShipPathPoint[] getPathPoints() {
        return this.pathPoints;
    }

    public int getCount() {
        return this.count;
    }

    public ShipPathPoint addPoint(ShipPathPoint point) {
        if (point.index >= 0) {
            throw new IllegalStateException("OW KNOWS!");
        }
        if (this.count == this.pathPoints.length) {
            ShipPathPoint[] apathpoint = new ShipPathPoint[this.count << 1];
            System.arraycopy(this.pathPoints, 0, apathpoint, 0, this.count);
            this.pathPoints = apathpoint;
        }
        this.pathPoints[this.count] = point;
        point.index = this.count;
        this.sortBack(this.count++);
        return point;
    }

    public void clearPath() {
        this.count = 0;
    }

    public ShipPathPoint dequeue() {
        ShipPathPoint pathpoint = this.pathPoints[0];
        this.pathPoints[0] = this.pathPoints[--this.count];
        this.pathPoints[this.count] = null;
        if (this.count > 0) {
            this.sortForward(0);
        }
        pathpoint.index = -1;
        return pathpoint;
    }

    public void changeDistance(ShipPathPoint point, float dist) {
        float f1 = point.distanceToTarget;
        point.distanceToTarget = dist;
        if (dist < f1) {
            this.sortBack(point.index);
        } else {
            this.sortForward(point.index);
        }
    }

    private void sortBack(int id) {
        ShipPathPoint pathpoint = this.pathPoints[id];
        float f = pathpoint.distanceToTarget;
        while (id > 0) {
            int j = id - 1 >> 1;
            ShipPathPoint pathpoint1 = this.pathPoints[j];
            if (f >= pathpoint1.distanceToTarget) break;
            this.pathPoints[id] = pathpoint1;
            pathpoint1.index = id;
            id = j;
        }
        this.pathPoints[id] = pathpoint;
        pathpoint.index = id;
    }

    private void sortForward(int id) {
        ShipPathPoint pathpoint = this.pathPoints[id];
        float f = pathpoint.distanceToTarget;
        while (true) {
            float f2;
            ShipPathPoint pathpoint2;
            int j = 1 + (id << 1);
            int k = j + 1;
            if (j >= this.count) break;
            ShipPathPoint pathpoint1 = this.pathPoints[j];
            float f1 = pathpoint1.distanceToTarget;
            if (k >= this.count) {
                pathpoint2 = null;
                f2 = Float.POSITIVE_INFINITY;
            } else {
                pathpoint2 = this.pathPoints[k];
                f2 = pathpoint2.distanceToTarget;
            }
            if (f1 < f2) {
                if (f1 >= f) break;
                this.pathPoints[id] = pathpoint1;
                pathpoint1.index = id;
                id = j;
                continue;
            }
            if (f2 >= f) break;
            this.pathPoints[id] = pathpoint2;
            pathpoint2.index = id;
            id = k;
        }
        this.pathPoints[id] = pathpoint;
        pathpoint.index = id;
    }

    public boolean isPathEmpty() {
        return this.count == 0;
    }
}

