/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai.path;

import com.lulan.shincolle.entity.IShipNavigator;
import com.lulan.shincolle.utility.EntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.MathHelper;

public class ShipMoveHelper {
    private EntityLiving entity;
    private IShipNavigator entityN;
    private double posX;
    private double posY;
    private double posZ;
    private double speed;
    private boolean update;
    private float rotateLimit;
    private int stuckTick;

    public ShipMoveHelper(EntityLiving entity, float rotlimit) {
        this.entity = entity;
        this.entityN = (IShipNavigator)entity;
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
        this.rotateLimit = rotlimit;
        this.stuckTick = 0;
    }

    public boolean isUpdating() {
        return this.update;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setMoveTo(double x, double y, double z, double speed) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.speed = speed;
        this.update = true;
    }

    public void onUpdateMoveHelper() {
        this.entity.func_70657_f(0.0f);
        if (this.update) {
            this.update = false;
            int i = MathHelper.func_76128_c((double)(this.entity.field_70121_D.field_72338_b + 0.5));
            double x1 = this.posX - this.entity.field_70165_t;
            double y1 = this.posY - this.entity.field_70163_u;
            double z1 = this.posZ - this.entity.field_70161_v;
            double moveSq = x1 * x1 + y1 * y1 + z1 * z1;
            if (moveSq >= 0.001) {
                float f = (float)(Math.atan2(z1, x1) * 180.0 / Math.PI) - 90.0f;
                float moveSpeed = (float)(this.speed * this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entity.field_70177_z = this.limitAngle(this.entity.field_70177_z, f, this.rotateLimit);
                if (this.entityN.canFly()) {
                    if (y1 > 0.5) {
                        this.entity.field_70181_x += (double)moveSpeed * 0.12;
                        moveSpeed *= 0.8f;
                    } else if (y1 < -0.5) {
                        this.entity.field_70181_x -= (double)moveSpeed * 0.16;
                        moveSpeed *= 0.92f;
                    }
                } else if (EntityHelper.checkEntityIsInLiquid((Entity)this.entity)) {
                    if (y1 > 0.0) {
                        this.entity.field_70181_x += (double)moveSpeed * 0.1;
                        moveSpeed *= 0.5f;
                    } else if (y1 < -0.2) {
                        this.entity.field_70181_x -= (double)moveSpeed * 0.2;
                        moveSpeed *= 0.82f;
                    }
                } else if (y1 > 0.2 && x1 * x1 + z1 * z1 < 3.0) {
                    this.entity.func_70683_ar().func_75660_a();
                }
                this.entity.func_70659_e(moveSpeed);
            }
        }
    }

    private float limitAngle(float yaw, float degree, float limit) {
        float f3 = MathHelper.func_76142_g((float)(degree - yaw));
        if (f3 > limit) {
            f3 = limit;
        }
        if (f3 < -limit) {
            f3 = -limit;
        }
        return yaw + f3;
    }
}

