/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.IShipCannonAttack;
import com.lulan.shincolle.handler.ConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIShipRangeAttack
extends EntityAIBase {
    private IShipCannonAttack host;
    private EntityLiving host2;
    private Entity target;
    private int delayLight;
    private int maxDelayLight;
    private int delayHeavy;
    private int maxDelayHeavy;
    private int onSightTime;
    private float range;
    private float rangeSq;
    private int aimTime;
    private double distSq;
    private double distSqrt;
    private double distX;
    private double distY;
    private double distZ;

    public EntityAIShipRangeAttack(IShipCannonAttack host) {
        if (!(host instanceof IShipCannonAttack)) {
            throw new IllegalArgumentException("RangeAttack AI requires interface IShipCannonAttack");
        }
        this.host = host;
        this.host2 = (EntityLiving)host;
        this.func_75248_a(1);
        this.delayLight = 20;
        this.delayHeavy = 40;
        this.maxDelayLight = 20;
        this.maxDelayHeavy = 40;
    }

    public boolean func_75250_a() {
        if (this.host2 != null) {
            if (this.host.getIsSitting() || this.host.getStateMinor(43) > 0) {
                return false;
            }
            if (this.host.getIsRiding() && this.host2.field_70154_o instanceof BasicEntityMount) {
                return false;
            }
            Entity target = this.host.getEntityTarget();
            if (target != null && target.func_70089_S() && (this.host.getAttackType(13) && this.host.getStateFlag(4) && this.host.hasAmmoLight() || this.host.getAttackType(14) && this.host.getStateFlag(5) && this.host.hasAmmoHeavy())) {
                this.target = target;
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        if (this.host != null) {
            this.updateAttackParms();
            if (this.delayLight <= this.aimTime) {
                this.delayLight = this.aimTime;
            }
            if (this.delayHeavy <= this.aimTime * 2) {
                this.delayHeavy = this.aimTime * 2;
            }
            this.distZ = 0.0;
            this.distY = 0.0;
            this.distX = 0.0;
            this.distSq = 0.0;
        }
    }

    public boolean func_75253_b() {
        if (this.host != null) {
            if (this.target != null && this.target.func_70089_S() && !this.host.getShipNavigate().noPath()) {
                return true;
            }
            return this.func_75250_a();
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
        this.onSightTime = 0;
    }

    public void func_75246_d() {
        boolean onSight = false;
        if (this.host != null && this.target != null) {
            if (this.host2.field_70173_aa % 64 == 0) {
                this.updateAttackParms();
            }
            --this.delayLight;
            --this.delayHeavy;
            this.distX = this.target.field_70165_t - this.host2.field_70165_t;
            this.distY = this.target.field_70163_u - this.host2.field_70163_u;
            this.distZ = this.target.field_70161_v - this.host2.field_70161_v;
            this.distSq = this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ;
            onSight = this.host2.func_70635_at().func_75522_a(this.target);
            if (onSight) {
                ++this.onSightTime;
            } else {
                this.onSightTime = 0;
                if (this.host.getStateFlag(12)) {
                    this.func_75251_c();
                    return;
                }
            }
            if (this.distSq < (double)this.rangeSq && onSight && !this.host.getStateFlag(3)) {
                this.host.getShipNavigate().clearPathEntity();
            } else if (this.host2.field_70173_aa % 32 == 0) {
                this.host.getShipNavigate().tryMoveToEntityLiving(this.target, 1.0);
            }
            this.host2.func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
            if (this.host2.func_70115_ae() && this.host2.field_70154_o instanceof BasicEntityMount) {
                ((BasicEntityMount)this.host2.field_70154_o).func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
            }
            if (onSight && this.distSq <= (double)this.rangeSq && this.onSightTime >= this.aimTime) {
                if (this.delayLight <= 0 && this.host.useAmmoLight() && this.host.hasAmmoLight()) {
                    this.host.attackEntityWithAmmo(this.target);
                    this.delayLight = this.maxDelayLight;
                }
                if (this.delayHeavy <= 0 && this.host.useAmmoHeavy() && this.host.hasAmmoHeavy()) {
                    this.host.attackEntityWithHeavyAmmo(this.target);
                    this.delayHeavy = this.maxDelayHeavy;
                }
            }
            if (this.delayHeavy < -40 || this.delayLight < -40) {
                this.delayLight = 20;
                this.delayHeavy = 20;
                this.func_75251_c();
                return;
            }
        }
    }

    private void updateAttackParms() {
        this.maxDelayLight = (int)((float)ConfigHandler.baseAttackSpeed[1] / this.host.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[1];
        this.maxDelayHeavy = (int)((float)ConfigHandler.baseAttackSpeed[2] / this.host.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[2];
        this.aimTime = (int)(20.0f * (float)(150 - this.host.getLevel()) / 150.0f) + 10;
        this.range = this.host.getAttackRange();
        this.rangeSq = this.range * this.range;
    }
}

