/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.ai.path.ShipPathEntity;
import com.lulan.shincolle.ai.path.ShipPathPoint;
import com.lulan.shincolle.entity.IShipNavigator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class EntityAIShipOpenDoor
extends EntityAIBase {
    private Entity host;
    private IShipNavigator host2;
    private int doorX;
    private int doorY;
    private int doorZ;
    private BlockDoor door;
    private List<int[]> gates;
    private boolean hasPassed;
    private float vecX;
    private float vecZ;
    private boolean closeDoor;
    private int delay;

    public EntityAIShipOpenDoor(IShipNavigator host, boolean closeDoor) {
        this.host = (Entity)host;
        this.host2 = host;
        this.closeDoor = closeDoor;
    }

    public boolean func_75250_a() {
        if (!this.host.field_70123_F) {
            return false;
        }
        ShipPathEntity path = this.host2.getShipNavigate().getPath();
        if (path != null && !path.isFinished()) {
            for (int i = 0; i < Math.min(path.getCurrentPathIndex() + 2, path.getCurrentPathLength()); ++i) {
                ShipPathPoint pp = path.getPathPointFromIndex(i);
                this.doorX = pp.xCoord;
                this.doorY = pp.yCoord;
                this.doorZ = pp.zCoord;
                if (!(this.host.func_70092_e((double)this.doorX, this.host.field_70163_u, (double)this.doorZ) <= 2.25)) continue;
                this.door = this.getDoor(this.doorX, this.doorY + 1, this.doorZ);
                if (this.door != null) {
                    ++this.doorY;
                    return true;
                }
                if (!this.getGate((float)this.doorX + 0.5f, this.doorY, (float)this.doorZ + 0.5f)) continue;
                return true;
            }
            this.doorX = MathHelper.func_76128_c((double)this.host.field_70165_t);
            this.doorY = MathHelper.func_76128_c((double)(this.host.field_70163_u + 1.0));
            this.doorZ = MathHelper.func_76128_c((double)this.host.field_70161_v);
            this.door = this.getDoor(this.doorX, this.doorY, this.doorZ);
            if (this.door != null) {
                return true;
            }
            return this.getGate((float)this.host.field_70165_t, (float)this.host.field_70163_u, (float)this.host.field_70161_v);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.closeDoor && this.delay > 0 && !this.hasPassed;
    }

    public void func_75249_e() {
        this.delay = 40;
        this.hasPassed = false;
        if (this.door != null) {
            this.vecX = (float)((double)((float)this.doorX + 0.5f) - this.host.field_70165_t);
            this.vecZ = (float)((double)((float)this.doorZ + 0.5f) - this.host.field_70161_v);
            this.door.func_150014_a(this.host.field_70170_p, this.doorX, this.doorY, this.doorZ, true);
        } else if (this.gates != null && !this.gates.isEmpty()) {
            this.activateGate(true);
        }
    }

    public void func_75251_c() {
        if (this.closeDoor) {
            if (this.door != null) {
                this.door.func_150014_a(this.host.field_70170_p, this.doorX, this.doorY, this.doorZ, false);
            } else if (this.gates != null && !this.gates.isEmpty()) {
                this.activateGate(false);
            }
        }
    }

    public void func_75246_d() {
        --this.delay;
        if (this.door != null) {
            float vx = (float)((double)this.doorX + 0.5 - this.host.field_70165_t);
            float vz = (float)((double)this.doorZ + 0.5 - this.host.field_70161_v);
            float v = this.vecX * vx + this.vecZ * vz;
            if (v < 0.0f) {
                this.hasPassed = true;
            }
        } else if (this.delay <= 0) {
            this.hasPassed = true;
        }
    }

    private BlockDoor getDoor(int x, int y, int z) {
        Block block = this.host.field_70170_p.func_147439_a(x, y, z);
        return block != Blocks.field_150466_ao ? null : (BlockDoor)block;
    }

    private boolean getGate(float x, float y, float z) {
        boolean getGate = false;
        float range = this.host.field_70130_N < 1.0f ? 1.0f : this.host.field_70130_N;
        this.gates = new ArrayList<int[]>();
        for (float ix = x - range; ix <= x + range; ix += 1.0f) {
            for (float iz = z - range; iz <= z + range; iz += 1.0f) {
                for (float iy = y; iy <= y + this.host.field_70131_O; iy += 1.0f) {
                    int gz;
                    int gy;
                    int gx = MathHelper.func_76141_d((float)ix);
                    Block block = this.host.field_70170_p.func_147439_a(gx, gy = (int)iy, gz = MathHelper.func_76141_d((float)iz));
                    if (!(block instanceof BlockFenceGate)) continue;
                    this.gates.add(new int[]{gx, gy, gz});
                    getGate = true;
                }
            }
        }
        return getGate;
    }

    private void activateGate(boolean openGate) {
        for (int[] gpos : this.gates) {
            Block b = this.host.field_70170_p.func_147439_a(gpos[0], gpos[1], gpos[2]);
            if (!(b instanceof BlockFenceGate)) continue;
            int meta = this.host.field_70170_p.func_72805_g(gpos[0], gpos[1], gpos[2]);
            if (BlockFenceGate.func_149896_b((int)meta)) {
                if (openGate) continue;
                this.host.field_70170_p.func_72921_c(gpos[0], gpos[1], gpos[2], meta & 0xFFFFFFFB, 2);
                this.host.field_70170_p.func_72889_a(null, 1003, gpos[0], gpos[1], gpos[2], 0);
                continue;
            }
            if (!openGate) continue;
            int j1 = (MathHelper.func_76128_c((double)((double)(this.host.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            int k1 = BlockFenceGate.func_149895_l((int)meta);
            if (k1 == (j1 + 2) % 4) {
                meta = j1;
            }
            this.host.field_70170_p.func_72921_c(gpos[0], gpos[1], gpos[2], meta | 4, 2);
            this.host.field_70170_p.func_72889_a(null, 1003, gpos[0], gpos[1], gpos[2], 0);
        }
    }
}

