/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.ai;

import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.IShipAircraftAttack;
import com.lulan.shincolle.handler.ConfigHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;

public class EntityAIShipCarrierAttack
extends EntityAIBase {
    private Random rand = new Random();
    private IShipAircraftAttack host;
    private EntityLiving host2;
    private Entity target;
    private int launchDelay;
    private int launchDelayMax;
    private boolean launchType;
    private float range;
    private float rangeSq;
    private double distSq;
    private double distX;
    private double distY;
    private double distZ;

    public EntityAIShipCarrierAttack(IShipAircraftAttack host) {
        if (!(host instanceof IShipAircraftAttack)) {
            throw new IllegalArgumentException("CarrierAttack AI requires IShipAircraftAttack");
        }
        this.host = host;
        this.host2 = (EntityLiving)host;
        this.func_75248_a(2);
        this.launchDelay = 20;
        this.launchDelayMax = 40;
        this.launchType = false;
    }

    public boolean func_75250_a() {
        if (this.host.getIsSitting() || this.host.getStateMinor(43) > 0) {
            return false;
        }
        if (this.host.getIsRiding() && this.host2.field_70154_o instanceof BasicEntityMount) {
            return false;
        }
        Entity target = this.host.getEntityTarget();
        if (target != null && target.func_70089_S() && (this.host.getAttackType(15) && this.host.getStateFlag(6) && this.host.hasAmmoLight() && this.host.hasAirLight() || this.host.getAttackType(16) && this.host.getStateFlag(7) && this.host.hasAmmoHeavy() && this.host.hasAirHeavy())) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.distZ = 0.0;
        this.distY = 0.0;
        this.distX = 0.0;
        this.distSq = 0.0;
    }

    public boolean func_75253_b() {
        if (this.host != null) {
            if (this.target != null && this.target.func_70089_S() && !this.host.getShipNavigate().noPath()) {
                return true;
            }
            return this.func_75250_a();
        }
        return false;
    }

    public void func_75251_c() {
        this.target = null;
    }

    public void func_75246_d() {
        if (this.target != null && this.host != null) {
            boolean onSight = this.host2.func_70635_at().func_75522_a(this.target);
            if (!onSight && this.host.getStateFlag(12)) {
                this.func_75251_c();
                return;
            }
            if (this.host2.field_70173_aa % 64 == 0) {
                this.launchDelayMax = (int)((float)ConfigHandler.baseAttackSpeed[3] / this.host.getAttackSpeed()) + ConfigHandler.fixedAttackDelay[3];
                this.range = this.host.getAttackRange();
                this.rangeSq = this.range * this.range;
            }
            if (this.distSq >= (double)this.rangeSq) {
                this.distX = this.target.field_70165_t - this.host2.field_70165_t;
                this.distY = this.target.field_70163_u - this.host2.field_70163_u;
                this.distZ = this.target.field_70161_v - this.host2.field_70161_v;
                this.distSq = this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ;
                if (this.distSq < (double)this.rangeSq && onSight && !this.host.getStateFlag(3)) {
                    this.host.getShipNavigate().clearPathEntity();
                } else if (this.host2.field_70173_aa % 32 == 0) {
                    this.host.getShipNavigate().tryMoveToEntityLiving(this.target, 1.0);
                }
            }
            this.host2.func_70671_ap().func_75650_a(this.target.field_70165_t, this.target.field_70163_u + 2.0, this.target.field_70161_v, 30.0f, 60.0f);
            --this.launchDelay;
            if (!this.host.getStateFlag(6)) {
                this.launchType = false;
            }
            if (!this.host.getStateFlag(7)) {
                this.launchType = true;
            }
            if (onSight && this.distSq <= (double)this.rangeSq && this.launchDelay <= 0) {
                if (this.launchType && this.host.hasAmmoLight() && this.host.hasAirLight()) {
                    this.host.attackEntityWithAircraft(this.target);
                    this.launchDelay = this.launchDelayMax;
                }
                if (!this.launchType && this.host.hasAmmoHeavy() && this.host.hasAirHeavy()) {
                    this.host.attackEntityWithHeavyAircraft(this.target);
                    this.launchDelay = this.launchDelayMax;
                }
                boolean bl = this.launchType = !this.launchType;
            }
            if (this.launchDelay < -80) {
                this.launchDelay = 20;
                this.func_75251_c();
                return;
            }
        }
    }
}

