/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.TextureClip;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.writer.ThemeWriter;

public class XMLThemeWriter
implements ThemeWriter {
    private LinkedList<String> elementStack = new LinkedList();
    private OutputStreamWriter output;
    private int indentation = 0;

    @Override
    public boolean write(Theme theme, OutputStream outputStream) {
        try {
            this.output = new OutputStreamWriter(outputStream);
            this.openElement("theme", new String[0]);
            this.openElement("metadata", new String[0]);
            this.writeElement("id", theme.id, new String[0]);
            this.writeElement("name", theme.name, new String[0]);
            this.writeElement("description", theme.description, new String[0]);
            for (String dependency : theme.dependencies) {
                this.writeElement("dependency", dependency, new String[0]);
            }
            this.closeElement("metadata");
            for (String image : theme.images.keySet()) {
                this.openElement("image", "id", image);
                for (Object[] source : theme.images.get(image)) {
                    this.writeElement("source", (String)source[0], "type", (String)source[1]);
                }
                this.closeElement("image");
            }
            for (String texture : theme.textures.keySet()) {
                if (!(theme.textures.get(texture) instanceof TextureClip)) continue;
                TextureClip clip = (TextureClip)theme.textures.get(texture);
                this.openElement("texture", "id", texture, "type", "clip");
                if (clip.source instanceof DynamicTexture) {
                    this.writeElement("source", ((DynamicTexture)clip.source).id, new String[0]);
                }
                this.writeRect(clip.rect);
                this.closeElement("texture");
            }
            this.closeElement("theme");
            this.output.flush();
            return true;
        }
        catch (ElementException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void writeRect(Rect rect) throws ElementAttributeCountException, IOException {
        this.writeElement("rect", "", "x", Integer.toString(rect.x), "y", Integer.toString(rect.y), "width", Integer.toString(rect.width), "height", Integer.toString(rect.height));
    }

    private void writeElement(String elementName, String contents, String ... attributes) throws IOException, ElementAttributeCountException {
        this.indent();
        this.output.write("<" + elementName + this.attributes(attributes) + ">" + this.escape(contents) + "</" + elementName + ">\n");
    }

    private String attributes(String[] attributes) throws ElementAttributeCountException {
        if ((attributes.length & 1) != 0) {
            throw new ElementAttributeCountException();
        }
        String result = "";
        for (int i = 0; i < attributes.length; i += 2) {
            result = result + " " + attributes[i] + "=\"" + this.escape(attributes[i + 1]) + "\"";
        }
        return result;
    }

    private void openElement(String elementName, String ... attributes) throws IOException, ElementAttributeCountException {
        this.elementStack.push(elementName);
        this.indent();
        this.output.write("<" + elementName + this.attributes(attributes) + ">\n");
        ++this.indentation;
    }

    private void closeElement(String elementName) throws ElementCloseMismatchException, IOException {
        if (!elementName.equals(this.elementStack.pop())) {
            throw new ElementCloseMismatchException();
        }
        --this.indentation;
        this.indent();
        this.output.write("</" + elementName + ">\n");
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.write("\t");
        }
    }

    private String escape(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;");
    }

    private class ElementAttributeCountException
    extends ElementException {
        private static final long serialVersionUID = 5363934302886278365L;

        private ElementAttributeCountException() {
        }
    }

    private class ElementCloseMismatchException
    extends ElementException {
        private static final long serialVersionUID = 3826879376987706602L;

        private ElementCloseMismatchException() {
        }
    }

    private class ElementException
    extends Exception {
        private static final long serialVersionUID = -1106134229546685224L;

        private ElementException() {
        }
    }
}

