/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme.reader;

import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.ThemeManager;
import uristqwerty.gui_craftguide.theme.reader.ElementHandler;
import uristqwerty.gui_craftguide.theme.reader.NullElement;
import uristqwerty.gui_craftguide.theme.reader.ValueTemplate;
import uristqwerty.gui_craftguide.theme.reader.ValueType;

public class TextureElement
implements ValueTemplate {
    private String type;
    private String id;
    private Texture texture = null;

    @Override
    public void startElement(Theme theme, String name, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getLocalName(i).equalsIgnoreCase("type")) {
                this.type = attributes.getValue(i);
                Class<? extends Texture> textureClass = ThemeManager.textureTypes.get(this.type.toLowerCase());
                if (textureClass == null) continue;
                try {
                    this.texture = textureClass.newInstance();
                }
                catch (InstantiationException e) {
                    CraftGuideLog.log(e);
                }
                catch (IllegalAccessException e) {
                    CraftGuideLog.log(e);
                }
                continue;
            }
            if (attributes.getLocalName(i).equalsIgnoreCase("id")) {
                this.id = attributes.getValue(i);
                continue;
            }
            if (!attributes.getLocalName(i).equalsIgnoreCase("sourceid")) continue;
            this.texture = DynamicTexture.instance(attributes.getValue(i));
        }
    }

    @Override
    public void characters(Theme theme, char[] chars, int start, int length) {
    }

    @Override
    public ElementHandler getSubElement(String name, Attributes attributes) {
        if (this.texture != null) {
            for (Field field : this.texture.getClass().getFields()) {
                ValueTemplate template;
                if (!field.getName().equalsIgnoreCase(name) || (template = ValueType.getTemplate(field)) == null) continue;
                return template;
            }
        }
        return NullElement.instance;
    }

    @Override
    public void endSubElement(Theme theme, ElementHandler handler, String name) {
        if (this.texture != null) {
            for (Field field : this.texture.getClass().getFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                if (!field.isAnnotationPresent(TextureMeta.TextureParameter.class)) break;
                try {
                    if (!(handler instanceof ValueTemplate)) break;
                    ValueTemplate template = (ValueTemplate)handler;
                    if (!field.getType().isAssignableFrom(template.valueType()) && (!field.getType().equals(Integer.TYPE) || !template.valueType().equals(Integer.class))) break;
                    field.set(this.texture, template.getValue());
                }
                catch (IllegalArgumentException e) {
                    CraftGuideLog.log(e);
                }
                catch (IllegalAccessException e) {
                    CraftGuideLog.log(e);
                }
                break;
            }
        }
    }

    @Override
    public void endElement(Theme theme, String name) {
        if (this.id != null) {
            theme.addTexture(this.id, this.texture);
        }
    }

    @Override
    public Class valueType() {
        return Texture.class;
    }

    @Override
    public Object getValue() {
        return this.texture;
    }
}

