/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.client.CraftGuideClient;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.minecraft.Image;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.theme.Theme;
import uristqwerty.gui_craftguide.theme.reader.ThemeReader;

public class ThemeManager {
    private ThemeReader xmlReader = new ThemeReader();
    public Map<String, Theme> themeList;
    public static boolean debugOutput = false;
    public static ThemeManager instance = new ThemeManager();
    public static Theme currentTheme;
    public static Map<String, Class<? extends Texture>> textureTypes;
    public static String currentThemeName;

    public void reload() {
        Theme theme;
        File themeDir = CraftGuideClient.themeDirectory();
        Image.unloadFileTextures();
        if (themeDir == null || !themeDir.isDirectory()) {
            return;
        }
        HashMap<String, Theme> themes = new HashMap<String, Theme>();
        CraftGuideLog.log("(re)loading themes...");
        for (File file : themeDir.listFiles()) {
            theme = null;
            if (file.isDirectory()) {
                CraftGuideLog.log("  Trying to load directory: " + file.getName());
                theme = this.loadDirectory(file);
            } else {
                if (file.getName().toLowerCase().endsWith(".txt")) continue;
                CraftGuideLog.log("  Trying to load file: " + file.getName());
                theme = this.loadFile(file);
            }
            if (theme != null) {
                CraftGuideLog.log("    Loaded " + file.getName());
                themes.put(theme.id, theme);
                continue;
            }
            CraftGuideLog.log("    Failed to load " + file.getName());
        }
        try {
            String line;
            IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
            IResource packThemes = resourceManager.func_110536_a(new ResourceLocation("craftguide", "themes.txt"));
            CraftGuideLog.log("Loading themes from texture pack...");
            BufferedReader reader = new BufferedReader(new InputStreamReader(packThemes.func_110527_b()));
            while ((line = reader.readLine()) != null) {
                CraftGuideLog.log("  Trying to load file from texture pack: " + line);
                try {
                    theme = this.loadStream(resourceManager.func_110536_a(new ResourceLocation("craftguide", line)).func_110527_b());
                    if (theme != null) {
                        CraftGuideLog.log("    Loaded " + line);
                        themes.put(theme.id, theme);
                        continue;
                    }
                    CraftGuideLog.log("    Failed to load " + line);
                }
                catch (IOException e) {
                    CraftGuideLog.log(e, "Exception while trying to load a theme from a texturepack:", false);
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            CraftGuideLog.log(e, "Error while checking if any currently loaded resource pack defines a list of CraftGuide themes:", true);
        }
        HashMap<String, Theme> validatedThemes = new HashMap<String, Theme>();
        ArrayList<String> processed = new ArrayList<String>();
        ThemeManager.debug("Validating themes:");
        while (themes.size() > 0) {
            ThemeManager.debug("  Looping over unvalidated themes:");
            for (String themeID : themes.keySet()) {
                ThemeManager.debug("    Theme '" + themeID + "':");
                theme = (Theme)themes.get(themeID);
                if (theme.loadError != null) {
                    ThemeManager.debug("      Already marked as having an error");
                    processed.add(themeID);
                    continue;
                }
                boolean hasDependencies = true;
                ThemeManager.debug("      Checking dependencies...");
                for (String dependency : theme.dependencies) {
                    ThemeManager.debug("        Dependency '" + dependency + "'");
                    if (themes.containsKey(dependency)) {
                        hasDependencies = false;
                        break;
                    }
                    if (!validatedThemes.containsKey(dependency)) {
                        theme.loadError = "Dependency '" + dependency + "' missing or unloadable";
                        break;
                    }
                    if (((Theme)validatedThemes.get((Object)dependency)).loadError == null) continue;
                    theme.loadError = "Error in dependency '" + dependency + "'";
                    break;
                }
                if (theme.loadError != null) {
                    ThemeManager.debug("      Dependency error '" + theme.loadError + "'");
                    processed.add(themeID);
                    continue;
                }
                if (!hasDependencies) continue;
                ThemeManager.debug("      All dependencies processed without error. Validating theme...");
                for (String imageID : theme.images.keySet()) {
                    ThemeManager.debug("      Checking image sources for image '" + imageID + "'");
                    boolean valid = false;
                    for (Object[] imageSource : theme.images.get(imageID)) {
                        ThemeManager.debug("        Source '" + imageSource + "'");
                        if (!this.validImage(theme, imageSource, validatedThemes)) continue;
                        valid = true;
                        break;
                    }
                    if (valid) continue;
                    theme.loadError = "Unable to locate valid source for image '" + imageID + "'";
                    break;
                }
                processed.add(themeID);
            }
            if (processed.size() > 0) {
                ThemeManager.debug("  " + processed.size() + " themes validated");
                for (String themeID : processed) {
                    validatedThemes.put(themeID, (Theme)themes.get(themeID));
                    themes.remove(themeID);
                }
                processed.clear();
                continue;
            }
            ThemeManager.debug("  No themes validated, marking remaining themes as having a cyclic dependency");
            for (String themeID : themes.keySet()) {
                theme = (Theme)themes.get(themeID);
                theme.loadError = "Possible cyclic dependency";
                validatedThemes.put(themeID, theme);
            }
        }
        ThemeManager.debug("Result:");
        for (String themeID : validatedThemes.keySet()) {
            if (((Theme)validatedThemes.get((Object)themeID)).loadError == null) {
                ThemeManager.debug("  '" + themeID + "' loaded successfully");
                continue;
            }
            ThemeManager.debug("  '" + themeID + "' failed to load with error \"" + ((Theme)validatedThemes.get((Object)themeID)).loadError + "\"");
        }
        this.themeList = validatedThemes;
    }

    private boolean validImage(Theme theme, Object[] imageSource, Map<String, Theme> validatedThemes) {
        String builtin;
        ThemeManager.debug("          Checking if image exists and is valid...");
        String type = (String)imageSource[0];
        String source = (String)imageSource[1];
        if (type.equalsIgnoreCase("parent-theme")) {
            ThemeManager.debug("            Searching for definition in parent theme(s)");
            for (String id : theme.dependencies) {
                ThemeManager.debug("              Checking theme '" + id + "'");
                if (!this.definesImage(validatedThemes.get(id), source, validatedThemes)) continue;
                return true;
            }
            ThemeManager.debug("            No parent theme defines image.");
            return false;
        }
        if (type.equalsIgnoreCase("file-jar") || type.equalsIgnoreCase("resource")) {
            ThemeManager.debug("            Searching resource packs, Minecraft.jar, and mod jars/zips/dirs for '" + source + "'");
            try {
                if (Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(source)) != null) {
                    ThemeManager.debug("              Found.");
                    return true;
                }
                ThemeManager.debug("              Not found.");
                return false;
            }
            catch (FileNotFoundException e) {
                ThemeManager.debug("              Not found.");
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                ThemeManager.debug("              Not found.");
                return false;
            }
        }
        if (type.equalsIgnoreCase("file")) {
            ThemeManager.debug("            Checking theme location for '" + source + "'");
            if (theme.fileSourceType == Theme.SourceType.DIRECTORY) {
                return new File((File)imageSource[2], source).isFile();
            }
        } else if (type.equalsIgnoreCase("builtin:") && (builtin = source).equalsIgnoreCase("error")) {
            return true;
        }
        return false;
    }

    private boolean definesImage(Theme theme, String sourceID, Map<String, Theme> validatedThemes) {
        if (theme.images.containsKey(sourceID)) {
            return true;
        }
        for (String id : theme.dependencies) {
            if (!this.definesImage(validatedThemes.get(id), sourceID, validatedThemes)) continue;
            return true;
        }
        return false;
    }

    private Theme loadDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.getName().startsWith("theme")) continue;
            CraftGuideLog.log("    Found " + file.getName());
            if (!file.isDirectory() && file.getName().endsWith(".xml")) {
                try {
                    Theme theme = this.xmlReader.read(new FileInputStream(file), dir);
                    if (theme != null) {
                        theme.fileSource = dir;
                        theme.fileSourceType = Theme.SourceType.DIRECTORY;
                        return theme;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    CraftGuideLog.log(e);
                }
            }
            CraftGuideLog.log("      Could not read " + file.getName());
        }
        return null;
    }

    private Theme loadStream(InputStream stream) {
        Theme theme = this.xmlReader.read(stream, null);
        if (theme != null) {
            theme.fileSource = null;
            theme.fileSourceType = Theme.SourceType.STREAM;
        }
        return theme;
    }

    private Theme loadFile(File file) {
        return null;
    }

    public static void debug(String text) {
        if (debugOutput) {
            CraftGuideLog.log(text, true);
        }
    }

    public Theme buildTheme(String string) {
        ThemeManager.debug("Building theme '" + string + "':");
        Theme theme = this.themeList.get(string);
        if (theme == null) {
            ThemeManager.debug("  Could not find theme.");
            return null;
        }
        Theme combined = new Theme(null);
        ThemeManager.debug("  Merging...");
        this.merge(combined, theme);
        combined.id = "[built-theme:" + string + "]";
        combined.fileSourceType = Theme.SourceType.GENERATED;
        combined.description = "Internal Theme that is a combination of the currently selected theme and all of its prerequisites.";
        ThemeManager.debug("  Generating textures...");
        combined.generateTextures();
        return combined;
    }

    private void merge(Theme combined, Theme theme) {
        ThemeManager.debug("    Handling dependencies:");
        for (String dependency : theme.dependencies) {
            ThemeManager.debug("      Dependency '" + dependency + "'");
            if (!combined.dependencies.contains(dependency)) {
                Theme dep = this.themeList.get(dependency);
                if (dep != null) {
                    ThemeManager.debug("        Not merged yet. Merging... [");
                    this.merge(combined, dep);
                    ThemeManager.debug("        ] finished merging '" + dependency + "'");
                    continue;
                }
                ThemeManager.debug("        Not merged yet. Could not find theme, though.");
                continue;
            }
            ThemeManager.debug("        Already merged.");
        }
        ThemeManager.debug("    Merging:");
        if (combined.dependencies.contains(theme.id)) {
            ThemeManager.debug("      Already merged, skipping.");
            return;
        }
        ThemeManager.debug("      Not already merged. adding images and textures.");
        combined.dependencies.add(theme.id);
        combined.images.putAll(theme.images);
        combined.textures.putAll(theme.textures);
    }

    public static void addTextureType(Class<? extends Texture> textureClass) {
        TextureMeta meta = textureClass.getAnnotation(TextureMeta.class);
        if (meta != null) {
            textureTypes.put(meta.name().toLowerCase(), textureClass);
        }
    }

    static {
        textureTypes = new HashMap<String, Class<? extends Texture>>();
    }
}

