/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.theme;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import uristqwerty.gui_craftguide.minecraft.Image;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.SolidColorTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.theme.ThemeManager;

public class Theme {
    private static Texture errorTexture = new SolidColorTexture(255, 0, 255, 255);
    public String id;
    public String name;
    public String description;
    public File fileSource;
    public SourceType fileSourceType;
    public Map<String, List<Object[]>> images = new HashMap<String, List<Object[]>>();
    public String loadError = null;
    public List<String> dependencies = new ArrayList<String>();
    public Map<String, Texture> textures = new HashMap<String, Texture>();
    private static Object[] errorImage = new Object[]{"builtin", "error", null};

    public Theme(File location) {
        this.fileSource = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setID(String id) {
        this.id = id.toLowerCase().replaceAll("[^a-z0-9_-]", "");
    }

    public void setMetadata(String propertyName, String value) {
        if (propertyName.equalsIgnoreCase("id")) {
            this.setID(value);
        } else if (propertyName.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (propertyName.equalsIgnoreCase("description")) {
            this.setDescription(value);
        }
    }

    public void addImage(String id, List<String> sources) {
        ArrayList<Object[]> converted = new ArrayList<Object[]>(sources.size());
        for (String source : sources) {
            Object[] o = new Object[]{source.substring(0, source.indexOf(58)), source.substring(source.indexOf(58) + 1), this.fileSource};
            converted.add(o);
        }
        this.images.put(id, converted);
    }

    public void addDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    public void generateTextures() {
        for (String imageID : this.images.keySet()) {
            Object[] imageFormat;
            ThemeManager.debug("    Loading image '" + imageID + "'");
            Texture texture = null;
            Iterator<Object[]> i$ = this.images.get(imageID).iterator();
            while (i$.hasNext() && (texture = this.loadImage(imageFormat = i$.next())) == null) {
            }
            if (texture == null) {
                texture = this.loadImage(errorImage);
            }
            this.textures.put(imageID, texture);
        }
        for (String id : this.textures.keySet()) {
            ThemeManager.debug("    Adding texture '" + id + "'. Maps to '" + this.textures.get(id) + "'");
            DynamicTexture.instance(id, this.textures.get(id));
        }
    }

    private Texture loadImage(Object[] imageFormat) {
        String sourceType = (String)imageFormat[0];
        String source = (String)imageFormat[1];
        ThemeManager.debug("      Loading " + sourceType + " image '" + source + "'");
        if (sourceType.equalsIgnoreCase("builtin")) {
            if (source.equalsIgnoreCase("error")) {
                return errorTexture;
            }
        } else if (sourceType.equalsIgnoreCase("file-jar") || sourceType.equalsIgnoreCase("resource")) {
            try {
                if (Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(source)) != null) {
                    return Image.fromJar(source);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sourceType.equalsIgnoreCase("file") && imageFormat[2] != null) {
            return Image.fromFile((File)imageFormat[2], source);
        }
        ThemeManager.debug("        Not found.");
        return null;
    }

    public void addTexture(String id, Texture texture) {
        this.textures.put(id, texture);
    }

    public static enum SourceType {
        DIRECTORY,
        GENERATED,
        STREAM;

    }
}

