/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.texture;

import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.editor.TextureMeta;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

@TextureMeta(name="clip")
public class TextureClip
implements Texture {
    @TextureMeta.TextureParameter
    public Texture source;
    @TextureMeta.TextureParameter
    public Rect rect;

    public TextureClip(Texture source, int u, int v, int width, int height) {
        this.source = source;
        this.rect = new Rect(u, v, width, height);
    }

    public TextureClip(Texture source, Rect rect) {
        this.source = source;
        this.rect = rect;
    }

    public TextureClip() {
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        if (u < 0) {
            width += u;
            u = 0;
        }
        if (u + width > this.rect.width) {
            width = this.rect.width - u;
        }
        if (v < 0) {
            height += v;
            v = 0;
        }
        if (v + height > this.rect.height) {
            height = this.rect.height - v;
        }
        if (width > 0 && height > 0) {
            this.source.renderRect(renderer, x, y, width, height, u + this.rect.x, v + this.rect.y);
        }
    }
}

