/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.texture;

import java.util.HashMap;
import java.util.Map;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

public class DynamicTexture
implements Texture {
    public Texture mapped;
    public final String id;
    private static Map<String, DynamicTexture> instances = new HashMap<String, DynamicTexture>();

    private DynamicTexture(String id) {
        this.id = id;
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int u, int v) {
        if (this.mapped != null) {
            this.mapped.renderRect(renderer, x, y, width, height, u, v);
        }
    }

    public static Texture instance(String id, Texture mappedTo) {
        DynamicTexture texture = (DynamicTexture)DynamicTexture.instance(id);
        if (texture != null) {
            texture.mapped = mappedTo;
        }
        return texture;
    }

    public static Texture instance(String id) {
        DynamicTexture texture = instances.get(id);
        if (texture == null) {
            texture = new DynamicTexture(id);
            instances.put(id, texture);
        }
        return texture;
    }
}

