/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.minecraft;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import uristqwerty.gui_craftguide.rendering.RendererBase;
import uristqwerty.gui_craftguide.texture.Texture;

public class Image
implements Texture {
    private int texID;
    private static Map<String, Image> jarCache = new HashMap<String, Image>();
    private static Map<String, Image> fileCache = new HashMap<String, Image>();
    private static Image err = new Image(-1);
    private static boolean needsInit = true;

    public static void initJarTextures() {
        if (needsInit) {
            for (Map.Entry<String, Image> entry : jarCache.entrySet()) {
                Image image = entry.getValue();
                if (image.texID != -1) continue;
                ResourceLocation resourceLocation = new ResourceLocation(entry.getKey());
                ITextureObject texture = Minecraft.func_71410_x().func_110434_K().func_110581_b(resourceLocation);
                if (texture == null) {
                    texture = new SimpleTexture(resourceLocation);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, texture);
                }
                image.texID = texture.func_110552_b();
            }
            needsInit = false;
        }
    }

    public static Image fromJar(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return err;
        }
        Image image = jarCache.get(filename);
        if (image == null) {
            image = new Image(-1);
            jarCache.put(filename, image);
            needsInit = true;
        }
        return image;
    }

    public static Image fromFile(File directory, String filename) {
        String key;
        try {
            key = new File(directory, filename).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Image image = fileCache.get(key);
        if (image == null) {
            image = new Image(-1);
            fileCache.put(key, image);
        }
        if (image.texID == -1) {
            image.texID = Image.LoadImageFile(directory, filename);
        }
        return image;
    }

    private static int LoadImageFile(File directory, String filename) {
        try {
            int width;
            int height = 4;
            FileInputStream input = new FileInputStream(new File(directory, filename));
            BufferedImage image = ImageIO.read(input);
            for (width = 4; width < image.getWidth(); width *= 2) {
            }
            while (height < image.getHeight()) {
                height *= 2;
            }
            ByteBuffer pixels = ByteBuffer.allocateDirect(width * height * 4);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = (y * width + x) * 4;
                    if (x < image.getWidth() && y < image.getHeight()) {
                        int rgb = image.getRGB(x, y);
                        pixels.put(pixel + 0, (byte)(rgb >> 16 & 0xFF));
                        pixels.put(pixel + 1, (byte)(rgb >> 8 & 0xFF));
                        pixels.put(pixel + 2, (byte)(rgb >> 0 & 0xFF));
                        pixels.put(pixel + 3, (byte)(rgb >> 24 & 0xFF));
                        continue;
                    }
                    pixels.put(pixel + 0, (byte)127);
                    pixels.put(pixel + 1, (byte)127);
                    pixels.put(pixel + 2, (byte)127);
                    pixels.put(pixel + 3, (byte)127);
                }
            }
            int texID = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)texID);
            GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)pixels);
            return texID;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private Image(int textureID) {
        this.texID = textureID;
    }

    @Override
    public void renderRect(RendererBase renderer, int x, int y, int width, int height, int textureX, int textureY) {
        if (this.texID >= 0) {
            double u = (double)(textureX % 256) / 256.0;
            double v = (double)(textureY % 256) / 256.0;
            double u2 = (double)(textureX % 256 + width) / 256.0;
            double v2 = (double)(textureY % 256 + height) / 256.0;
            renderer.setTextureID(this.texID);
            renderer.drawTexturedRect(x, y, width, height, u, v, u2, v2);
        }
    }

    public static void unloadFileTextures() {
        for (Image image : fileCache.values()) {
            GL11.glDeleteTextures((int)image.texID);
            image.texID = -1;
        }
    }
}

