/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.gui_craftguide.components;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.gui_craftguide.MutableRect;
import uristqwerty.gui_craftguide.Rect;
import uristqwerty.gui_craftguide.components.Window;
import uristqwerty.gui_craftguide.editor.GuiElementMeta;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.texture.Texture;

public class GuiElement {
    protected MutableRect bounds;
    @GuiElementMeta.GuiElementProperty(name="background")
    public Texture background = null;
    private GuiElement parent = null;
    private List<GuiElement> children = new ArrayList<GuiElement>();
    private AnchorPoint anchorTL = AnchorPoint.TOP_LEFT;
    private AnchorPoint anchorBR = AnchorPoint.TOP_LEFT;
    private boolean clickable = true;

    public GuiElement(int x, int y, int width, int height) {
        this.bounds = new MutableRect(x, y, width, height);
    }

    public GuiElement(Rect bounds) {
        this.bounds = new MutableRect(bounds);
    }

    public GuiElement(Rect bounds, String template) {
        this.bounds = new MutableRect(bounds);
        this.applyTemplate(template);
    }

    public GuiElement getLayer(Window.Layer layer) {
        if (this.parent != null) {
            return this.parent.getLayer(layer);
        }
        return null;
    }

    public GuiElement getElementAtPoint(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        GuiElement clicked = this.clickable ? this : null;
        for (GuiElement child : this.children) {
            GuiElement element = child.getElementAtPoint(x - this.bounds.x(), y - this.bounds.y());
            if (element == null) continue;
            clicked = element;
        }
        return clicked;
    }

    private void applyTemplate(String template) {
        for (Field field : this.getClass().getFields()) {
            GuiElementMeta.GuiElementProperty property = field.getAnnotation(GuiElementMeta.GuiElementProperty.class);
            if (property == null) continue;
            try {
                CraftGuideLog.log("Annotated property '" + property.name() + "', field '" + field.getName() + "', currentValue '" + field.get(this) + "'", true);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Map<String, Object> values = this.getTemplate(template);
        if (values != null) {
            // empty if block
        }
    }

    private Map<String, Object> getTemplate(String template) {
        if (template.equalsIgnoreCase("")) {
            // empty if block
        }
        return null;
    }

    public GuiElement addElement(GuiElement element) {
        element.parent = this;
        this.children.add(element);
        return this;
    }

    public void removeElement(GuiElement element) {
        element.parent = null;
        this.children.remove(element);
    }

    public void update() {
        for (GuiElement element : this.children) {
            element.update();
        }
    }

    public void draw() {
        this.drawBackground();
        this.drawChildren();
    }

    public void drawChildren() {
        for (GuiElement element : this.children) {
            element.draw();
        }
    }

    public void drawBackground() {
        if (this.background != null) {
            this.render(this.background, 0, 0, this.bounds.width(), this.bounds.height());
        }
    }

    public void mouseMoved(int x, int y) {
        for (GuiElement element : this.children) {
            element.mouseMoved(x - this.bounds.x(), y - this.bounds.y());
        }
    }

    public void mousePressed(int x, int y) {
        for (GuiElement element : this.children) {
            element.mousePressed(x - this.bounds.x(), y - this.bounds.y());
        }
    }

    public void mouseReleased(int x, int y) {
        for (GuiElement element : this.children) {
            element.mouseReleased(x - this.bounds.x(), y - this.bounds.y());
        }
    }

    public GuiRenderer getRenderer() {
        if (this.parent != null) {
            return this.parent.getRenderer();
        }
        return null;
    }

    public void render(Renderable renderable) {
        this.render(renderable, 0, 0);
    }

    public void render(Texture texture, int x, int y, int width, int height) {
        if (this.parent != null && texture != null && width > 0 && height > 0) {
            this.parent.render(texture, x + this.bounds.x(), y + this.bounds.y(), width, height);
        }
    }

    public void render(Renderable renderable, int xOffset, int yOffset) {
        if (this.parent != null && renderable != null) {
            this.parent.render(renderable, xOffset + this.bounds.x(), yOffset + this.bounds.y());
        }
    }

    public boolean containsPoint(int x, int y) {
        return x >= this.bounds.x() && x < this.bounds.x() + this.bounds.width() && y >= this.bounds.y() && y < this.bounds.y() + this.bounds.height();
    }

    public GuiElement setSize(int width, int height) {
        if (width != this.bounds.width() || height != this.bounds.height()) {
            int oldWidth = this.bounds.width();
            int oldHeight = this.bounds.height();
            this.bounds.setSize(width, height);
            this.onResize(oldWidth, oldHeight);
            for (GuiElement element : this.children) {
                element.onParentResize(oldWidth, oldHeight, width, height);
            }
        }
        return this;
    }

    public void onParentResize(int oldWidth, int oldHeight, int newWidth, int newHeight) {
        int x1 = this.bounds.x();
        int y1 = this.bounds.y();
        int x2 = this.bounds.x() + this.bounds.width();
        int y2 = this.bounds.y() + this.bounds.height();
        if (this.anchorTL == AnchorPoint.TOP_RIGHT || this.anchorTL == AnchorPoint.BOTTOM_RIGHT) {
            x1 += newWidth - oldWidth;
        }
        if (this.anchorTL == AnchorPoint.BOTTOM_LEFT || this.anchorTL == AnchorPoint.BOTTOM_RIGHT) {
            y1 += newHeight - oldHeight;
        }
        if (this.anchorBR == AnchorPoint.TOP_RIGHT || this.anchorBR == AnchorPoint.BOTTOM_RIGHT) {
            x2 += newWidth - oldWidth;
        }
        if (this.anchorBR == AnchorPoint.BOTTOM_LEFT || this.anchorBR == AnchorPoint.BOTTOM_RIGHT) {
            y2 += newHeight - oldHeight;
        }
        if (x1 != this.bounds.x() || y1 != this.bounds.y()) {
            this.setPosition(x1, y1);
        }
        if (x2 - x1 != this.bounds.width() || y2 - y1 != this.bounds.height()) {
            this.setSize(x2 - x1, y2 - y1);
        }
    }

    public GuiElement setPosition(int x, int y) {
        if (x == this.bounds.x() && y == this.bounds.y()) {
            return this;
        }
        this.bounds.setPosition(x, y);
        this.onMove();
        for (GuiElement element : this.children) {
            element.onParentMove();
        }
        return this;
    }

    public GuiElement setPositionAbsolute(int x, int y) {
        return this.setPosition(x - this.absoluteX() + this.bounds.x(), y - this.absoluteY() + this.bounds.y());
    }

    public GuiElement anchor(AnchorPoint topLeft, AnchorPoint bottomRight) {
        this.anchorTL = topLeft;
        this.anchorBR = bottomRight;
        return this;
    }

    public GuiElement anchor(AnchorPoint point) {
        return this.anchor(point, point);
    }

    public int absoluteX() {
        if (this.parent == null) {
            return this.bounds.x();
        }
        return this.parent.absoluteX() + this.bounds.x();
    }

    public int absoluteY() {
        if (this.parent == null) {
            return this.bounds.y();
        }
        return this.parent.absoluteY() + this.bounds.y();
    }

    public int relativeX() {
        return this.bounds.x();
    }

    public int relativeY() {
        return this.bounds.y();
    }

    public void onKeyTyped(char eventChar, int eventKey) {
        for (GuiElement element : this.children) {
            element.onKeyTyped(eventChar, eventKey);
        }
    }

    public void scrollWheelTurned(int change) {
        for (GuiElement element : this.children) {
            element.scrollWheelTurned(change);
        }
    }

    public void onGuiClosed() {
        for (GuiElement element : this.children) {
            element.onGuiClosed();
        }
    }

    public Iterable<GuiElement> getChildren() {
        return this.children;
    }

    public GuiElement setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public GuiElement setBackground(Texture background) {
        this.background = background;
        return this;
    }

    public int width() {
        return this.bounds.width();
    }

    public int height() {
        return this.bounds.height();
    }

    public void onResize(int oldWidth, int oldHeight) {
    }

    public void onParentMove() {
    }

    public void onMove() {
    }

    public void elementClicked(int x, int y, MouseClick mouseButton) {
    }

    public static enum MouseClick {
        LEFT_CLICK,
        RIGHT_CLICK;

    }

    public static enum AnchorPoint {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

