/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.recipes;

import ic2.api.item.IC2Items;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.IScrapboxManager;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.api.ChanceSlot;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.EUSlot;
import uristqwerty.CraftGuide.api.ExtraSlot;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.StackInfo;
import uristqwerty.CraftGuide.recipes.IC2ExperimentalAmplifiers;
import uristqwerty.CraftGuide.recipes.IC2GeneratorFuel;
import uristqwerty.CraftGuide.recipes.IC2Power;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class IC2ExperimentalRecipes
extends CraftGuideAPIObject
implements RecipeProvider {
    public static List<AdditionalMachines> additionalMachines = new ArrayList<AdditionalMachines>();

    public IC2ExperimentalRecipes() {
        StackInfo.addSource(new IC2GeneratorFuel());
        StackInfo.addSource(new IC2Power());
        StackInfo.addSource(new IC2ExperimentalAmplifiers());
    }

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        try {
            this.addCraftingRecipes(generator);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"macerator"), this.getMacerator(), Recipes.macerator);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"extractor"), this.getExtractor(), Recipes.extractor);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"compressor"), this.getCompressor(), Recipes.compressor);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"centrifuge"), Recipes.centrifuge);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"metalformer"), Recipes.metalformerExtruding);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"metalformer"), Recipes.metalformerCutting);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"metalformer"), Recipes.metalformerRolling);
            this.addMachineRecipes(generator, IC2Items.getItem((String)"orewashingplant"), Recipes.oreWashing);
            this.addScrapboxOutput(generator, IC2Items.getItem((String)"scrapBox"), Recipes.scrapboxDrops);
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (InvocationTargetException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchMethodException e) {
            CraftGuideLog.log(e, "", true);
        }
    }

    private Object getMacerator() {
        ArrayList<Object> macerator = new ArrayList<Object>();
        macerator.add(IC2Items.getItem((String)"macerator"));
        for (AdditionalMachines additional : additionalMachines) {
            Object[] machines = additional.extraMacerators();
            if (machines == null) continue;
            for (Object machine : machines) {
                macerator.add(machine);
            }
        }
        return macerator;
    }

    private Object getExtractor() {
        ArrayList<Object> extractor = new ArrayList<Object>();
        extractor.add(IC2Items.getItem((String)"extractor"));
        for (AdditionalMachines additional : additionalMachines) {
            Object[] machines = additional.extraExtractors();
            if (machines == null) continue;
            for (Object machine : machines) {
                extractor.add(machine);
            }
        }
        return extractor;
    }

    private Object getCompressor() {
        ArrayList<Object> compressor = new ArrayList<Object>();
        compressor.add(IC2Items.getItem((String)"compressor"));
        for (AdditionalMachines additional : additionalMachines) {
            Object[] machines = additional.extraCompressors();
            if (machines == null) continue;
            for (Object machine : machines) {
                compressor.add(machine);
            }
        }
        return compressor;
    }

    private void addMachineRecipes(RecipeGenerator generator, ItemStack type, IMachineRecipeManager recipeManager) {
        this.addMachineRecipes(generator, type, type, recipeManager);
    }

    private void addMachineRecipes(RecipeGenerator generator, ItemStack type, Object machine, IMachineRecipeManager recipeManager) {
        this.addMachineRecipes(generator, type, machine, recipeManager, 2, 800);
    }

    private void addMachineRecipes(RecipeGenerator generator, ItemStack type, Object machine, IMachineRecipeManager recipeManager, int eut, int totalEU) {
        int maxOutput = 1;
        for (RecipeOutput output : recipeManager.getRecipes().values()) {
            maxOutput = Math.max(maxOutput, output.items.size());
        }
        int columns = (maxOutput + 1) / 2;
        Slot[] recipeSlots = new Slot[maxOutput + 3];
        recipeSlots[0] = new ItemSlot(columns > 1 ? 3 : 12, 21, 16, 16, true).drawOwnBackground();
        recipeSlots[1] = new ExtraSlot(columns > 1 ? 23 : 31, 30, 16, 16, machine).clickable().showName().setSlotType(SlotType.MACHINE_SLOT);
        recipeSlots[2] = new EUSlot(columns > 1 ? 23 : 31, 12).setConstantPacketSize(eut).setConstantEUValue(-totalEU);
        for (int i = 0; i < maxOutput / 2; ++i) {
            recipeSlots[i * 2 + 3] = new ItemSlot((columns > 1 ? 41 : 50) + i * 18, 12, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
            recipeSlots[i * 2 + 4] = new ItemSlot((columns > 1 ? 41 : 50) + i * 18, 30, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
        }
        if ((maxOutput & 1) == 1) {
            recipeSlots[columns * 2 + 1] = new ItemSlot((columns > 1 ? 23 : 32) + columns * 18, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
        }
        RecipeTemplate template = generator.createRecipeTemplate(recipeSlots, type);
        for (Map.Entry recipe : recipeManager.getRecipes().entrySet()) {
            Object[] recipeContents = new Object[maxOutput + 3];
            recipeContents[0] = ((IRecipeInput)recipe.getKey()).getInputs();
            recipeContents[1] = machine;
            recipeContents[2] = null;
            List output = ((RecipeOutput)recipe.getValue()).items;
            for (int i = 0; i < Math.min(maxOutput, output.size()); ++i) {
                recipeContents[i + 3] = output.get(i);
            }
            generator.addRecipe(template, recipeContents);
        }
    }

    private void addScrapboxOutput(RecipeGenerator generator, ItemStack scrapbox, IScrapboxManager scrapboxDrops) {
        Slot[] recipeSlots = new Slot[]{new ExtraSlot(18, 21, 16, 16, scrapbox).clickable().showName().setSlotType(SlotType.INPUT_SLOT), new ChanceSlot(44, 21, 16, 16, true).setFormatString(" (%1$.3f%% chance)").setRatio(100000).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
        RecipeTemplate template = generator.createRecipeTemplate(recipeSlots, scrapbox);
        for (Map.Entry entry : scrapboxDrops.getDrops().entrySet()) {
            Object[] recipeContents = new Object[]{scrapbox, new Object[]{entry.getKey(), (int)(((Float)entry.getValue()).floatValue() * 100000.0f)}};
            generator.addRecipe(template, recipeContents);
        }
    }

    private void addCraftingRecipes(RecipeGenerator generator) throws ClassNotFoundException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
        Class<?> advancedRecipe = Class.forName("ic2.core.AdvRecipe");
        Field outputField = advancedRecipe.getField("output");
        Field inputField = advancedRecipe.getField("input");
        Field widthField = advancedRecipe.getField("inputWidth");
        Method canShow = advancedRecipe.getMethod("canShow", new Class[0]);
        Field maskField = null;
        try {
            maskField = advancedRecipe.getField("masks");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        Class<?> shapelessRecipe = Class.forName("ic2.core.AdvShapelessRecipe");
        Field shapelessInput = shapelessRecipe.getField("input");
        Field shapelessOutput = shapelessRecipe.getField("output");
        Method shapelessCanShow = shapelessRecipe.getMethod("canShow", new Class[0]);
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        RecipeTemplate template = generator.createRecipeTemplate(new Slot[]{new ItemSlot(3, 3, 16, 16).drawOwnBackground(), new ItemSlot(21, 3, 16, 16).drawOwnBackground(), new ItemSlot(39, 3, 16, 16).drawOwnBackground(), new ItemSlot(3, 21, 16, 16).drawOwnBackground(), new ItemSlot(21, 21, 16, 16).drawOwnBackground(), new ItemSlot(39, 21, 16, 16).drawOwnBackground(), new ItemSlot(3, 39, 16, 16).drawOwnBackground(), new ItemSlot(21, 39, 16, 16).drawOwnBackground(), new ItemSlot(39, 39, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()}, null);
        DefaultRecipeTemplate shapelessTemplate = new DefaultRecipeTemplate(new Slot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)}, RecipeGeneratorImplementation.workbench, new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 1, 121, 79, 58), new TextureClip(DynamicTexture.instance("recipe_backgrounds"), 82, 121, 79, 58));
        RecipeTemplate smallTemplate = generator.createRecipeTemplate(new Slot[]{new ItemSlot(12, 12, 16, 16).drawOwnBackground(), new ItemSlot(30, 12, 16, 16).drawOwnBackground(), new ItemSlot(12, 30, 16, 16).drawOwnBackground(), new ItemSlot(30, 30, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()}, null);
        for (Object recipe : recipes) {
            Object[] input;
            ItemStack output;
            if (advancedRecipe.isInstance(recipe) && ((Boolean)canShow.invoke(recipe, new Object[0])).booleanValue()) {
                output = (ItemStack)outputField.get(recipe);
                input = (Object[])inputField.get(recipe);
                int width = (Integer)widthField.get(recipe);
                if (maskField != null) {
                    input = this.expandInput(input, width, ((int[])maskField.get(recipe))[0]);
                }
                if (width < 3 && input.length / width < 3) {
                    this.addSmallRecipe(generator, smallTemplate, input, output, width);
                    continue;
                }
                this.addLargeRecipe(generator, template, input, output, width);
                continue;
            }
            if (!shapelessRecipe.isInstance(recipe) || !((Boolean)shapelessCanShow.invoke(recipe, new Object[0])).booleanValue()) continue;
            output = (ItemStack)shapelessOutput.get(recipe);
            input = (Object[])shapelessInput.get(recipe);
            this.addShapelessRecipe(generator, shapelessTemplate, input, output);
        }
    }

    private Object[] expandInput(Object[] input, int width, int mask) {
        int height = ((mask & 7) != 0 ? 1 : 0) + ((mask & 0x38) != 0 ? 1 : 0) + ((mask & 0x1C0) != 0 ? 1 : 0);
        Object[] expanded = new Object[width * height];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if ((mask & 1 << 8 - (y * 3 + x)) == 0) continue;
                expanded[y * width + x] = input[i++];
            }
        }
        return expanded;
    }

    private void addLargeRecipe(RecipeGenerator generator, RecipeTemplate template, Object[] input, ItemStack output, int width) {
        Object[] recipeContents = new Object[10];
        int hShift = width == 1 ? 1 : 0;
        int vShift = width == input.length ? 1 : 0;
        for (int y = 0; y < input.length / width; ++y) {
            for (int x = 0; x < width; ++x) {
                recipeContents[(y + vShift) * 3 + x + hShift] = this.resolve(input[y * width + x]);
            }
        }
        recipeContents[9] = output;
        generator.addRecipe(template, recipeContents);
    }

    private void addSmallRecipe(RecipeGenerator generator, RecipeTemplate template, Object[] input, ItemStack output, int width) {
        Object[] recipeContents = new Object[5];
        for (int y = 0; y < input.length / width; ++y) {
            for (int x = 0; x < width; ++x) {
                recipeContents[y * 2 + x] = this.resolve(input[y * width + x]);
            }
        }
        recipeContents[4] = output;
        generator.addRecipe(template, recipeContents);
    }

    private void addShapelessRecipe(RecipeGenerator generator, RecipeTemplate template, Object[] input, ItemStack output) {
        Object[] recipeContents = new Object[10];
        for (int i = 0; i < Math.min(input.length, 9); ++i) {
            recipeContents[i] = this.resolve(input[i]);
        }
        recipeContents[9] = output;
        generator.addRecipe(template, recipeContents);
    }

    private Object resolve(Object item) {
        if (item instanceof String) {
            String itemString = (String)item;
            if (itemString.startsWith("liquid$")) {
                String fluidName = itemString.substring(7);
                ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
                for (FluidContainerRegistry.FluidContainerData container : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                    if (!container.fluid.getFluid().getName().equals(fluidName)) continue;
                    containers.add(container.filledContainer);
                }
                return containers;
            }
            return OreDictionary.getOres((String)itemString);
        }
        if (item instanceof ItemStack) {
            return item;
        }
        if (item instanceof IRecipeInput) {
            return ((IRecipeInput)item).getInputs();
        }
        if (item instanceof List) {
            boolean containsItemStacks = true;
            for (Object o : (List)item) {
                if (o instanceof ItemStack) continue;
                containsItemStacks = false;
                break;
            }
            if (containsItemStacks) {
                return item;
            }
            ArrayList<Object> newlist = new ArrayList<Object>(((List)item).size());
            for (Object o : (List)item) {
                Object r = this.resolve(o);
                if (r instanceof Collection) {
                    newlist.addAll((Collection)r);
                    continue;
                }
                newlist.add(r);
            }
            return newlist;
        }
        if (item instanceof Iterable) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object o : (Iterable)item) {
                Object r = this.resolve(o);
                if (r instanceof Collection) {
                    newlist.addAll((Collection)r);
                    continue;
                }
                newlist.add(r);
            }
            return newlist;
        }
        if (item != null && item.getClass().isArray()) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            for (Object o : (Object[])item) {
                Object r = this.resolve(o);
                if (r instanceof Collection) {
                    newlist.addAll((Collection)r);
                    continue;
                }
                newlist.add(r);
            }
            return newlist;
        }
        return null;
    }

    public static interface AdditionalMachines {
        public Object[] extraMacerators();

        public Object[] extraExtractors();

        public Object[] extraCompressors();
    }
}

